/*****************************************************************************************
*
* \file       dia_IMediaFileCounter.h
*
* \brief      interface of dia_IMediaFileCounter
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     aoo2kor
*
* \date       13 Sept 2021
*
* \copyright  (c) 2020 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER__
#define __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

#ifndef IID_MEDIA_FILE_COUNTER_PRJ
#define IID_MEDIA_FILE_COUNTER_PRJ                          ((dia::IID) 0x4fbc5f70) // {ecf7a49f-041e-448a-bf84-ca94b277d772}	
#endif
//------------------------------------------------------------------------------

enum dia_eMediaPlayerDeviceType
{
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_UNKNOWN = 0,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_BLUETOOTH,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_CDDA,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_CDROM,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_DVD_DRIVE,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_FLASH,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_IPHONE,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_IPOD,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_MTP,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_MUSICBOX,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_SD,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_USB,
   DIA_EN_MEDIAPLAYER_DEVICE_TYPE_COUNT
};

//------------------------------------------------------------------------------


enum dia_eMediaPlayerDeviceIndexedState
{
   DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_UNKNOWN = 0,
   DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_COMPLETE,
   DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_NOTSTARTED,
   DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_NOTSUPPORTED,
   DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_PARTIAL,
   DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_COUNT
};

enum dia_eMediaPlayerConnectionState
{
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNKNOWN = 0,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_CONNECTED,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_ATTACHED,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_DISCONNECTED,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_HW_MALFUNCTION,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNSUPPORTED,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_OVERTEMP,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_ON_HOLD,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_ON_UNDEFINED,
   DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNDERVOLTAGE

};

//------------------------------------------------------------------------------

struct dia_tDeviceInfoItem
{
public:
   //! default constructor
   dia_tDeviceInfoItem ( void )
      : mDeviceTag(),
        mDeviceName(),
        m_eIndexedState(DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_UNKNOWN),
        m_eDeviceType(DIA_EN_MEDIAPLAYER_DEVICE_TYPE_UNKNOWN),
        m_eConnectionState(DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNKNOWN),
        mNumberOfFiles(),
        mNumberOfVideoFiles(),
        mNumberOfImageFiles()
   {}

   //! copy constructor
   dia_tDeviceInfoItem ( const dia_tDeviceInfoItem& obj )
      : mDeviceTag(obj.mDeviceTag),
        mDeviceName(obj.mDeviceName),
        m_eIndexedState(obj.m_eIndexedState),
        m_eDeviceType(obj.m_eDeviceType),
        m_eConnectionState(obj.m_eConnectionState),
        mNumberOfFiles(obj.mNumberOfFiles),
        mNumberOfVideoFiles(obj.mNumberOfVideoFiles),
        mNumberOfImageFiles(obj.mNumberOfImageFiles)
   {}

   //! assignment operator
   dia_tDeviceInfoItem& operator = ( const dia_tDeviceInfoItem& obj )
   {
      if ( this != &obj ) {
      	mDeviceTag = obj.mDeviceTag;
        mDeviceName = obj.mDeviceName;
        m_eIndexedState = obj.m_eIndexedState;
        m_eDeviceType = obj.m_eDeviceType;
        m_eConnectionState = obj.m_eConnectionState;
        mNumberOfFiles = obj.mNumberOfFiles;
        mNumberOfVideoFiles = obj.mNumberOfVideoFiles;
        mNumberOfImageFiles = obj.mNumberOfImageFiles;
      }
      return *this;
   }

   // comparison operators (added manually)
   bool operator==(dia_tDeviceInfoItem const & r)
   {
      return ((this->mDeviceTag == r.mDeviceTag) && (this->mDeviceName == r.mDeviceName) && (this->m_eIndexedState == r.m_eIndexedState)  && (this->m_eDeviceType == r.m_eDeviceType) && (this->m_eConnectionState == r.m_eConnectionState) && (this->mNumberOfFiles == r.mNumberOfFiles) && (this->mNumberOfVideoFiles == r.mNumberOfVideoFiles) && (this->mNumberOfImageFiles == r.mNumberOfImageFiles));
   }
   bool operator!=(dia_tDeviceInfoItem const & r) {return !(*this == r);}

   //! class constructor
   dia_tDeviceInfoItem (
         tU8 DeviceTag,
         tString DeviceName,
         dia_eMediaPlayerDeviceIndexedState IndexedState,
         dia_eMediaPlayerDeviceType DeviceType,
         dia_eMediaPlayerConnectionState ConnectionState,
         tU32 NumberOfFiles,
         tU32 NumberOfVideoFiles,
         tU32 NumberOfImageFiles
      )
      : mDeviceTag(DeviceTag),
        mDeviceName(DeviceName),
        m_eIndexedState(IndexedState),
        m_eDeviceType(DeviceType),
        m_eConnectionState(ConnectionState),
        mNumberOfFiles(NumberOfFiles),
        mNumberOfVideoFiles(NumberOfVideoFiles),
        mNumberOfImageFiles(NumberOfImageFiles)
   {}

public:
   //! device tag
   tU8 mDeviceTag;
   //! device name
   tString mDeviceName;
   //! indexed state
   dia_eMediaPlayerDeviceIndexedState m_eIndexedState;
   //! device type
   dia_eMediaPlayerDeviceType m_eDeviceType;
   //! connection state
   dia_eMediaPlayerConnectionState m_eConnectionState;
   //! no.of playable files
   tU32 mNumberOfFiles;
   //! no.of playable video files
   tU32 mNumberOfVideoFiles;
   //! no.of playable image files
   tU32 mNumberOfImageFiles;
};

//------------------------------------------------------------------------------


class dia_IMediaFileCounter
{
   DIA_DECL_INTERFACE_IID(IID_MEDIA_FILE_COUNTER_PRJ)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! returns the Counter for no.of mediaFiles encountered in a lifetime
   virtual tDiaResult mediaFile_noOfFilesCounter_Get ( void  ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IMediaFileCounter ( void ) {}
};

#endif /* -__INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER__ */

