/*****************************************************************************************
*
* \file       dia_IInputHandlingPrj.h
*
* \brief      interface of dia_IInputHandlingPrj
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     mky6kor (generated with dia_igen tool)
*
* \date       09 July 2018
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
* 09/07/2018	| bma9kor	| Modified the file name
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ__
#define __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eInputHandlingTouchInfoPrj
{
   DIA_EN_PRJ_TOUCH_INFO_UNKNOWN = 0,
   DIA_EN_PRJ_TOUCH_INFO_TOUCHED,
   DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED,
   DIA_EN_PRJ_TOUCH_INFO_MOVE,
   DIA_EN_PRJ_TOUCH_INFO_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingKeyInfoPrj
{
   DIA_EN_PRJ_KEY_INFO_UNKNOWN = 0,
   DIA_EN_PRJ_KEY_INFO_PRESSED,
   DIA_EN_PRJ_KEY_INFO_RELEASED,
   DIA_EN_PRJ_KEY_INFO_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingKeyCodePrj
{
   DIA_EN_PRJ_KEY_CODE_UNKNOWN = 0,
   DIA_EN_PRJ_KEY_CODE_RADIO,
   DIA_EN_PRJ_KEY_CODE_AM_FM,
   DIA_EN_PRJ_KEY_CODE_MEDIA,
   DIA_EN_PRJ_KEY_CODE_CAR,
   DIA_EN_PRJ_KEY_CODE_SETUP,
   DIA_EN_PRJ_KEY_CODE_PHONE,
   DIA_EN_PRJ_KEY_CODE_SOUND,
   DIA_EN_PRJ_KEY_CODE_MUTE,
   DIA_EN_PRJ_KEY_CODE_TP,
   DIA_EN_PRJ_KEY_CODE_MENU,
   DIA_EN_PRJ_KEY_CODE_LEFT_ENCODER,
   DIA_EN_PRJ_KEY_CODE_RIGHT_ENCODER,
   DIA_EN_PRJ_KEY_CODE_EJECT,
   DIA_EN_PRJ_KEY_CODE_CD,
   DIA_EN_PRJ_KEY_CODE_CAMERA,
   DIA_EN_PRJ_KEY_CODE_AUX,
   DIA_EN_PRJ_KEY_CODE_PREV,
   DIA_EN_PRJ_KEY_CODE_NEXT,
   DIA_EN_PRJ_KEY_CODE_INFO,
   DIA_EN_PRJ_KEY_CODE_MAP,
   DIA_EN_PRJ_KEY_CODE_BACK,
   DIA_EN_PRJ_KEY_CODE_DAY_NIGHT,
   DIA_EN_PRJ_KEY_CODE_NAV,
   DIA_EN_PRJ_KEY_CODE_XM,
   DIA_EN_PRJ_KEY_CODE_APP,
   DIA_EN_PRJ_KEY_CODE_COUNT
};

//------------------------------------------------------------------------------

enum dia_eVdInuptHandlingKeyCodePrj
{
   DIA_PRJ_KEY_CODE_UNKNOWN = 0,
   DIA_PRJ_KEY_CODE_PHONE,
   DIA_PRJ_KEY_CODE_CD,
   DIA_PRJ_KEY_CODE_CAMERA,
   DIA_PRJ_KEY_CODE_AUX,
   DIA_PRJ_KEY_CODE_PREV,
   DIA_PRJ_KEY_CODE_NEXT,
   DIA_PRJ_KEY_CODE_RADIO,
   DIA_PRJ_KEY_CODE_INFO,
   DIA_PRJ_KEY_CODE_SETUP,
   DIA_PRJ_KEY_CODE_MAP,
   DIA_PRJ_KEY_CODE_BACK,
   DIA_PRJ_KEY_CODE_DAY_NIGHT,
   DIA_PRJ_KEY_CODE_NAV,
   DIA_PRJ_KEY_CODE_ENTER,
   DIA_PRJ_KEY_CODE_XM,
   DIA_PRJ_KEY_CODE_AM_FM,
   DIA_PRJ_KEY_CODE_MENU,
   DIA_PRJ_KEY_CODE_APP,
   DIA_PRJ_KEY_CODE_AUDIO,
   DIA_PRJ_KEY_CODE_DISP,
   DIA_PRJ_KEY_CODE_HOME,
   DIA_PRJ_KEY_CODE_MEX,
   DIA_PRJ_KEY_CODE_MUTE,
   DIA_PRJ_KEY_CODE_POWER,
   DIA_PRJ_KEY_CODE_EJECT,
   DIA_PRJ_KEY_VIRTUAL_STM,
   DIA_PRJ_KEY_CODE_FOLDER_NEXT,
   DIA_PRJ_KEY_CODE_FOLDER_PREV,
   DIA_PRJ_KEY_CODE_PIVI_CLIMATE,
   DIA_PRJ_SWC_KEY_CODE_MODE,
   DIA_PRJ_SWC_KEY_CODE_OK,
   DIA_PRJ_SWC_KEY_CODE_SEEK_UP,
   DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN,
   DIA_PRJ_SWC_KEY_CODE_TEL_VR,
   DIA_PRJ_SWC_KEY_CODE_VOL_DOWN,
   DIA_PRJ_SWC_KEY_CODE_VOL_UP,
   DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP,
   DIA_PRJ_SWC_KEY_CODE_BACK,
   DIA_PRJ_SWC_KEY_CODE_UP,
   DIA_PRJ_SWC_KEY_CODE_DOWN,
   DIA_PRJ_SWC_KEY_CODE_MUTE,
   DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_UP,
   DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_DOWN,
   DIA_PRJ_SWC_KEY_CODE_RADIO,
   DIA_PRJ_SWC_KEY_CODE_ENTER,
   DIA_PRJ_JOYSTICK_KEY_CODE_UP,
   DIA_PRJ_JOYSTICK_KEY_CODE_DOWN,
   DIA_PRJ_JOYSTICK_KEY_CODE_LEFT,
   DIA_PRJ_JOYSTICK_KEY_CODE_RIGHT,
   DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_LEFT,
   DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_RIGHT,
   DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_LEFT,
   DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_RIGHT,
   DIA_PRJ_JOYSTICK_KEY_CODE_ENTER,
   DIA_PRJ_JOYSTICK_KEY_CODE_MAP,
   DIA_PRJ_JOYSTICK_KEY_CODE_HOME,
   DIA_PRJ_JOYSTICK_KEY_CODE_BACK,
   DIA_PRJ_JOYSTICK_KEY_CODE_DAY_NIGHT,
   DIA_PRJ_JOYSTICK_KEY_CODE_DISP,
   DIA_PRJ_JOYSTICK_KEY_CODE_OPTION_LONGPRESS,
   DIA_PRJ_JOYSTICK_KEY_CODE_HOME_LONGPRESS,
   DIA_PRJ_JOYSTICK_KEY_CODE_BACK_LONGPRESS,
   DIA_PRJ_JOYSTICK_KEY_CODE_ENTER_LONGPRESS,
   DIA_PRJ_KEY_CODE_REL_JOYSTICK_WHEEL,
   DIA_PRJ_KEY_CODE_MENU_LONGPRESS,
   DIA_PRJ_KEY_CODE_SETUP_LONGPRESS,
   DIA_PRJ_KEY_CODE_POWER_LONGPRESS,
   DIA_PRJ_KEY_CODE_HOME_LONGPRESS,
   DIA_PRJ_KEY_CODE_DAY_NIGHT_LONGPRESS,
   DIA_PRJ_KEY_CODE_VOL_UP,
   DIA_PRJ_KEY_CODE_VOL_DOWN,
   DIA_PRJ_KEY_CODE_VOLUME,
   DIA_PRJ_KEY_CODE_RSC_ON_OFF,
   DIA_PRJ_KEY_CODE_EV,
   DIA_PRJ_KEY_CODE_TRAFFIC_INFO,
   DIA_PRJ_KEY_CODE_VIRT_ENG_TESTMODE,
   DIA_PRJ_KEY_CODE_VIRT_SCREENSHOT,
   DIA_PRJ_KEY_CODE_HVAC_MEX,
   DIA_PRJ_KEY_CODE_HVAC_SEAT,
   DIA_PRJ_KEY_CODE_VIRT_VOL_COMBI,
   DIA_PRJ_SWC_KEY_CODE_LEFT,
   DIA_PRJ_SWC_KEY_CODE_RIGHT,
   DIA_PRJ_SWC_KEY_CODE_TEL_ON,
   DIA_PRJ_SWC_KEY_CODE_TEL_OFF,
   DIA_PRJ_JOYSTICK_KEY_CODE_OPTION,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_HOME_COCKPIT,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SRC_COCKPIT,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_NAV,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_MAP,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SRC_CABIN,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_HOME_CABIN,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SET_COCKPIT,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_CAM,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_PHONE_ACCEPT,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_PHONE_REJECT,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_MON,
   DIA_PRJ_KEY_CODE_INPUT_INF4CV_MCP_SET_CABIN,
   DIA_PRJ_KEY_CODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT,
   DIA_PRJ_KEY_CODE_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN,
   DIA_PRJ_KEY_CODE_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingSWCKeyCodePrj
{
   DIA_EN_PRJ_SWC_KEY_CODE_UNKNOWN = 0,
   DIA_EN_PRJ_SWC_KEY_CODE_OK,
   DIA_EN_PRJ_SWC_KEY_CODE_SEEK_UP,
   DIA_EN_PRJ_SWC_KEY_CODE_SEEK_DOWN,
   DIA_EN_PRJ_SWC_KEY_CODE_TEL_VR,
   DIA_EN_PRJ_SWC_KEY_CODE_VOL_DOWN,
   DIA_EN_PRJ_SWC_KEY_CODE_VOL_UP,
   DIA_EN_PRJ_SWC_KEY_CODE_TEL_HANG_UP,
   DIA_EN_PRJ_SWC_KEY_CODE_BACK,
   DIA_EN_PRJ_SWC_KEY_CODE_UP,
   DIA_EN_PRJ_SWC_KEY_CODE_DOWN,
   DIA_EN_PRJ_SWC_KEY_CODE_MUTE,
   DIA_EN_PRJ_SWC_KEY_CODE_AUDIO_SRC_UP,
   DIA_EN_PRJ_SWC_KEY_CODE_AUDIO_SRC_DOWN,
   DIA_EN_PRJ_SWC_KEY_CODE_RADIO,
   DIA_EN_PRJ_SWC_KEY_CODE_ENTER,
   DIA_EN_PRJ_SWC_KEY_CODE_LEFT,
   DIA_EN_PRJ_SWC_KEY_CODE_RIGHT,
   DIA_EN_PRJ_SWC_KEY_CODE_TEL_ON,
   DIA_EN_PRJ_SWC_KEY_CODE_TEL_OFF,
   DIA_EN_PRJ_SWC_KEY_CODE_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingEncoderPrj
{
   DIA_EN_PRJ_ENCODER_UNKNOWN = 0,
   DIA_EN_PRJ_ENCODER_1,
   DIA_EN_PRJ_ENCODER_2,
   DIA_EN_PRJ_ENCODER_3,
   DIA_EN_PRJ_ENCODER_4,
   DIA_EN_PRJ_ENCODER_5,
   DIA_EN_PRJ_ENCODER_SWC_VOLUME,
   DIA_EN_PRJ_ENCODER_SWC_UP_DOWN,
   DIA_EN_PRJ_ENCODER_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingLockInfoControlPrj
{
   DIA_EN_PRJ_INFO_CONTROL_UNKNOWN = 0,
   DIA_EN_PRJ_INFO_CONTROL_LOCK,
   DIA_EN_PRJ_INFO_CONTROL_UNLOCK,
   DIA_EN_PRJ_INFO_CONTROL_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingGestureRecordPrj
{
   DIA_EN_PRJ_GESTURE_RECORD_UNKNOWN = 0,
   DIA_EN_PRJ_GESTURE_RECORD_START,
   DIA_EN_PRJ_GESTURE_RECORD_STOP,
   DIA_EN_PRJ_GESTURE_RECORD_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingGestureReplayPrj
{
   DIA_EN_PRJ_GESTURE_REPLAY_UNKNOWN = 0,
   DIA_EN_PRJ_GESTURE_REPLAY_START,
   DIA_EN_PRJ_GESTURE_REPLAY_STOP,
   DIA_EN_PRJ_GESTURE_REPLAY_COUNT
};

//------------------------------------------------------------------------------

enum dia_eInputHandlingTouchPressInfoPrj
{
   DIA_EN_PRJ_TOUCH_UNKNOWN = 0,
   DIA_EN_PRJ_TOUCH_RELEASED,
   DIA_EN_PRJ_TOUCH_PRESSED,
   DIA_EN_PRJ_TOUCH_INVALID,
   DIA_EN_PRJ_TOUCH_COUNT
};

//------------------------------------------------------------------------------

class dia_IInputHandlingPrj
{
   DIA_DECL_INTERFACE_IID(IID_INPUT_HANDLING_PRJ)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! returns the list of pressed keys
   virtual tDiaResult getPressedKeys ( void  ) = 0;
   //! returns status of encoders
   virtual tDiaResult getEncoderStatus ( void  ) = 0;
   //! returns direction status of encoders
   virtual tDiaResult getEncoderDirStatus ( void  ) { return DIA_E_NOT_IMPLEMENTED; }
   //! returns touch position and touch status
   virtual tDiaResult getTouchInfo ( void  ) = 0;
   //! simulate key press or key release by passing diagnose defined key code
   virtual tDiaResult setKeyDia ( const dia_eInputHandlingKeyCodePrj eKeyCode, const dia_eInputHandlingKeyInfoPrj eKeyInfo ) = 0;
   //! simulate key press or key release by passing internally defined key code
   virtual tDiaResult setKeyIntern ( const tU16 u16KeyCode, const dia_eInputHandlingKeyInfoPrj eKeyInfo ) = 0;
   //! simulate key press or key release by passing internally defined key code
   virtual tDiaResult setKeyInternalCode ( const dia_eVdInuptHandlingKeyCodePrj KeyID, const dia_eInputHandlingKeyInfoPrj eKeyInfo ) = 0;
   //! lock the operating unit 1
   virtual tDiaResult lockControlUnit ( const dia_eInputHandlingLockInfoControlPrj eLock ) = 0;
   //! set simulated encoder (control knob) value on the operating unit
   virtual tDiaResult setEncoder ( const dia_eInputHandlingEncoderPrj eEncoder, const tS8 s8ControlValue ) = 0;
   //! start the touch panel calibration
   virtual tDiaResult startTouchPanelAlignment ( void  ) = 0;
   //! start the input event simulation (requirement from VD_Input)
   virtual tDiaResult enableInputEvents ( void  ) { return DIA_E_NOT_IMPLEMENTED; }
    //! simulate touch press or release by passing x:y coordinates
   virtual tDiaResult setTouchIntern ( const tU16 /*u16X*/, const tU16 /*u16Y*/, const dia_eInputHandlingTouchInfoPrj /*eTouchInfo*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! simulate touch slide by passing duration [ms], start and end x:y coordinates
   virtual tDiaResult setTouchSlideIntern ( const tU16 /*u16XStart*/, const tU16 /*u16YStart*/, const tU16 /*u16XEnd*/, const tU16 /*u16YEnd*/, const tU16 /*u16Duration*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Record sequence of User Inputs, Touch, Key, Encoder and store them in some file (e.g. /tmp/GuestureName) on target.
   virtual tDiaResult recordGesture ( const dia_eInputHandlingGestureRecordPrj /*eStartStop*/, const std::string& /*filePath*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Replay series of touch events from file stored in Target File system (e.g. /tmp/GuestureName)
   virtual tDiaResult replayGesture ( const dia_eInputHandlingGestureReplayPrj /*eStartStop*/, const std::string& /*filePath*/ ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_IInputHandlingPrj ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ__ */

