/*****************************************************************************************
*
* \file       dia_IHMINavigation.h
*
* \brief      interface of dia_IHMINavigation
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       17 May 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
/*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 09.02.2017		| 1.1	| NLK1KOR (RBEI)	|  AIVI-28703 Worker class for the Sensor simulation via sensor log file

*******************************************************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION__
#define __INCLUDED_DIA_INTERFACE_HMINAVIGATION__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

//------------------------------------------------------------------------------

class dia_IHMINavigation
{
   DIA_DECL_INTERFACE_IID(IID_HMI_NAVIGATION)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! retrieve the actual value of RouteCalculationDuration property
   virtual tDiaResult getRouteCalculationDuration ( void ) = 0;
   //! register for the RouteCalculationDuration property update
   virtual tDiaResult registerToRouteCalculationDuration ( void ) = 0;
   //! Send StartTripReplay to HMI Navigation
   virtual tDiaResult StartTripReplay( std::string tripfileName) = 0;
   //! Send StopTripReplay to HMI Navigation
   virtual tDiaResult StopTripReplay() = 0;
   //! register for the TripReplayStatusInfo property update
   virtual tDiaResult  registerToTripReplayStatusInfo( void ) = 0;
   //! retrieve the actual value of DataSetVersion property
   virtual tDiaResult getDatasetVersion ( void ) = 0;
   //! register for the DataSetVersion property update
   virtual tDiaResult registerToDatasetVersion ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHMINavigation ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_HMINAVIGATION__ */

