/*****************************************************************************************
*
* \file       dia_IHMIMonitorListener.h
*
* \brief      listener of dia_IHMIMonitorListener
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       12 April 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HMIMONITOR_LISTENER__
#define __INCLUDED_DIA_INTERFACE_HMIMONITOR_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_HMIMONITOR__
#include "dia_IHMIMonitor.h"
#endif

/**
 *
 *  \class dia_IHMIMonitorListener
 *
 */

class dia_IHMIMonitorListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_HMI_MONITOR_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response to getHMIActiveForegroundScene
   virtual void vOnHMIActiveForegroundSceneStatus ( std::string activeSceneName ) = 0;
   //! response to getActiveForegroundSceneUpper
   virtual void vOnHMIActiveForegroundSceneUpperStatus ( std::string activeUpperSceneName ) = 0;
   //! response to getHMIStartUpTimeInterval
   virtual void vOnHMIStartupTimeIntervalStatus ( tU32 startupTimeInterval ) = 0;
   //! response to getNextActiveForegroundSceneUpper
   virtual void vOnHMINextActiveForegroundSceneUpperStatus ( std::string nextActiveUpperSceneName ) = 0;
   //! response to getNextActiveForegroundSceneLower
   virtual void vOnHMINextActiveForegroundSceneLowerStatus ( std::string nextActiveLowerSceneName ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHMIMonitorListener ( void ) {}
};

/**
 *
 *  \class dia_IHMIMonitorListenerImpl
 *
 */

class dia_IHMIMonitorListenerImpl
   : public dia_IHMIMonitorListener
{
public:
   //! response to getHMIActiveForegroundScene
   virtual void vOnHMIActiveForegroundSceneStatus ( std::string /*activeSceneName*/ ) {}
   //! response to getActiveForegroundSceneUpper
   virtual void vOnHMIActiveForegroundSceneUpperStatus ( std::string /*activeUpperSceneName*/ ) {}
   //! response to getHMIStartUpTimeInterval
   virtual void vOnHMIStartupTimeIntervalStatus ( tU32 /*startupTimeInterval*/ ) {}
   //! response to getNextActiveForegroundSceneUpper
   virtual void vOnHMINextActiveForegroundSceneUpperStatus ( std::string /*nextActiveUpperSceneName*/ ) {}
   //! response to getNextActiveForegroundSceneLower
   virtual void vOnHMINextActiveForegroundSceneLowerStatus ( std::string /*nextActiveLowerSceneName*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IHMIMonitorListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IHMIMonitorNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IHMIMonitorNotifier
   : public dia_IHMIMonitorListener,
     public dia_Notifier<dia_IHMIMonitorListener>
{
public:
   //! response to getHMIActiveForegroundScene
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnHMIActiveForegroundSceneStatus,std::string)
   //! response to getActiveForegroundSceneUpper
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnHMIActiveForegroundSceneUpperStatus,std::string)
   //! response to getHMIStartUpTimeInterval
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnHMIStartupTimeIntervalStatus,tU32)
   //! response to getNextActiveForegroundSceneUpper
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnHMINextActiveForegroundSceneUpperStatus,std::string)
   //! response to getNextActiveForegroundSceneLower
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnHMINextActiveForegroundSceneLowerStatus,std::string)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_HMIMONITOR_LISTENER__ */

