/*
 * dia_IFanStatisticsListener.h
 *
 *  Created on: 15.12.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_FAN_STATISTICS_LISTENER__
#define __INCLUDED_DIA_INTERFACE_FAN_STATISTICS_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_FAN_STATISTICS__
#include "dia_IFanStatistics.h"
#endif

//-----------------------------------------------------------------------------

class dia_IFanStatisticsListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_FAN_STATISTICS_LISTENER)

public:
    //! notify the Fan Activation Counter 
    virtual void vOnFanActivationCounter ( tU16 u16Counter ) = 0;
    //! notify the Fan Activation Duration 
    virtual void vOnFanActivationDuration ( tU16 u16Duration ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_IFanStatisticsListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_IFanStatisticsListenerImpl
    : public dia_IFanStatisticsListener
{
public:
    //! notify the Fan Activation Counter 
    virtual void vOnFanActivationCounter ( tU16 u16Counter ) {}
    //! notify the Fan Activation Duration 
    virtual void vOnFanActivationDuration ( tU16 u16Duration ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_IFanStatisticsListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_IFanStatisticsNotifier
    : public dia_IFanStatisticsListener,
      public dia_Notifier<dia_IFanStatisticsListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnFanActivationCounter,tU16)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnFanActivationDuration,tU16)
};


#endif /* __INCLUDED_DIA_INTERFACE_FAN_STATISTICS_LISTENER__ */
