/*****************************************************************************************
*
* \file       dia_IErrorLogNotificationListener.h
*
* \brief      Listener interface for the ErrorLog (diaglog) component ASF interface
*
* This interface is used to deliver results for asynchronous services requested via the dia_IErrorLogNotification interface
*
* \author     gpu2kor (generated with dia_igen tool)
*
* \date       07 December 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_NOTIFICATION_LISTENER__
#define __INCLUDED_DIA_INTERFACE_ERRORLOG_NOTIFICATION_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_NOTIFICATION__
#include "dia_IErrorLogNotification.h"
#endif

/**
 *
 *  \class dia_IErrorLogNotificationListener
 *
 */

class dia_IErrorLogNotificationListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_ERRORLOG_NOTIFICATION_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! notification for a status change of specific DTC (only one DTC)
   virtual void vOnDtcStatusChanged ( const tU32 DTCNumber, const tU8 DTCStatus ) = 0; 
   
protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLogNotificationListener ( void ) {}
};

/**
 *
 *  \class dia_IErrorLogNotificationListenerImpl
 *
 */

class dia_IErrorLogNotificationListenerImpl
   : public dia_IErrorLogNotificationListener
{
public:
   //! notification for a status change of specific DTC (only one DTC)
   virtual void vOnDtcStatusChanged ( const tU32 /*DTCNumber*/, const tU8 /*DTCStatus*/ ) {} 
   
protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLogNotificationListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IErrorLogNotificationNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IErrorLogNotificationNotifier
   : public dia_IErrorLogNotificationListener,
     public dia_Notifier<dia_IErrorLogNotificationListener>
{
public:
   //! notification for a status change of specific DTC (only one DTC)
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnDtcStatusChanged,const tU32,const tU8) 
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_ERRORLOG_NOTIFICATION_LISTENER__ */

