/*
 * dia_IDtvListener.h
 *
 *  Created on: 18.10.2017
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_DTV_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DTV_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_DTV__
#include "dia_IDtv.h"
#endif

//-----------------------------------------------------------------------------

class dia_IDtvListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_DTV_LISTENER)

public:
    //! notify about the HW Version
    virtual void onHwVersion ( const std::string& strHwVersion ) = 0;
    //! notify about the SW Version
    virtual void onSwVersion ( const std::string& strSwVersion ) = 0;
    //! notify about the Boot Version
    virtual void onBootVersion ( const std::string& strBootVersion ) = 0;
    //! notify about the FW Version
    virtual void onFwVersion ( const std::string& strFwVersion ) = 0;
    //! notify about the FPGA Version
    virtual void onFpgaVersion ( const std::string& strFpgaVersion ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_IDtvListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_IDtvListenerImpl
    : public dia_IDtvListener
{
public:
   virtual void onHwVersion ( const std::string& /*strHwVersion*/ ) {}
   virtual void onSwVersion ( const std::string& /*strSwVersion*/ ) {}
   virtual void onBootVersion ( const std::string& /*strBootVersion*/ ) {}
   virtual void onFwVersion ( const std::string& /*strFwVersion*/ ) {}
   virtual void onFpgaVersion ( const std::string& /*strFpgaVersion*/ ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_IDtvListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_IDtvNotifier
    : public dia_IDtvListener,
      public dia_Notifier<dia_IDtvListener>
{
public:
   DIA_M_ADD_NOTIFIER_ONE_ARG(onHwVersion, const std::string&)
   DIA_M_ADD_NOTIFIER_ONE_ARG(onSwVersion, const std::string&)
   DIA_M_ADD_NOTIFIER_ONE_ARG(onBootVersion, const std::string&)
   DIA_M_ADD_NOTIFIER_ONE_ARG(onFwVersion, const std::string&)
   DIA_M_ADD_NOTIFIER_ONE_ARG(onFpgaVersion, const std::string&)
};


#endif /* __INCLUDED_DIA_INTERFACE_DTV_LISTENER__ */
