/*****************************************************************************************
 *
 * \file    dia_IDisplayPatternAIVIListener.h
 *
 * \brief   Definition of the listener interface to the display test feature
 *
 * The listener-class covers methods with requested diagnosis responses from SAFeature to service handler. The reception and processing on service handler side is not verified with a return value.
 * For details about the available methods see the list below.
 *
 * \author  bhs1hi (generated with dia_igen tool)
 *
 * \date    07 April 2016
 *
 * (c) 2016 Robert Bosch Car Multimedia GmbH
 *
 ****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI__
#include "dia_IDisplayPatternAIVI.h"
#endif

/**
 *
 *  \class dia_IDisplayPatternAIVIListener
 *
 */

class dia_IDisplayPatternAIVIListener
: public virtual dia_Listener
  {
	DIA_DECL_INTERFACE_IID(IID_DISPLAY_PATTERN_AIVI_LISTENER)

  public:
	//! Set display procedure is finished
	virtual void vOnSetDisplayTestPatternDone ( tDiaResult result ) = 0;

	virtual void  vOnCISswUpdateProcessResult (tBool result) = 0;
	virtual void  vOnCISswUpdateProcessStage2Result (tBool stage2result) = 0;

  protected:
	//! virtual base class destructor
	virtual ~dia_IDisplayPatternAIVIListener ( void ) {}
  };

/**
 *
 *  \class dia_IDisplayPatternAIVIListenerImpl
 *
 */

class dia_IDisplayPatternAIVIListenerImpl
: public dia_IDisplayPatternAIVIListener
  {
public:
	//! Set display procedure is finished
	virtual void vOnSetDisplayTestPatternDone ( tDiaResult /*result*/ ) {}

	virtual void  vOnCISswUpdateProcessResult (tBool /*result*/) {}
	virtual void  vOnCISswUpdateProcessStage2Result (tBool /*stage2result*/) {}

protected:
	//! virtual base class destructor
	virtual ~dia_IDisplayPatternAIVIListenerImpl ( void ) {}
  };

/**
 *
 *  \class dia_IDisplayPatternAIVINotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IDisplayPatternAIVINotifier
: public dia_IDisplayPatternAIVIListener,
public dia_Notifier<dia_IDisplayPatternAIVIListener>
{
public:
	//! Set display procedure is finished
	DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetDisplayTestPatternDone,tDiaResult)
	DIA_M_ADD_NOTIFIER_ONE_ARG(vOnCISswUpdateProcessResult,tBool)
	DIA_M_ADD_NOTIFIER_ONE_ARG(vOnCISswUpdateProcessStage2Result,tBool)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__ */

