/*****************************************************************************************
 *
 * \file    dia_IDisplayPatternAIVI.h
 *
 * \brief   interface of dia_IDisplayPatternAIVI
 *
 * The interface-class covers methods for sending requests and data to SAFeature. The reception and processing is replied with a tDiaResult value.
 * For details about the available methods see the list below.
 *
 * \author  bhs1hi (generated with dia_igen tool)
 *
 * \date    07 April 2016
 *
 * (c) 2016 Robert Bosch Car Multimedia GmbH
 *
 ****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI__
#define __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eDisplayPatternAIVIID
{
	DIA_EN_DISPLAY_PATTERN_AIVI_UNKNOWN = 0,
	DIA_EN_DISPLAY_PATTERN_AIVI_NONE,
	DIA_EN_DISPLAY_PATTERN_AIVI_WHITE,
	DIA_EN_DISPLAY_PATTERN_AIVI_BLACK,
	DIA_EN_DISPLAY_PATTERN_AIVI_RED,
	DIA_EN_DISPLAY_PATTERN_AIVI_GREEN,
	DIA_EN_DISPLAY_PATTERN_AIVI_BLUE,
	DIA_EN_DISPLAY_PATTERN_AIVI_COLOURED,
	DIA_EN_DISPLAY_PATTERN_AIVI_COLOURED_GRADIATION,
	DIA_EN_DISPLAY_PATTERN_AIVI_DIAGNOSIS_MASK,
	DIA_EN_DISPLAY_PATTERN_AIVI_LATTICE,
	DIA_EN_DISPLAY_PATTERN_AIVI_WHITE_BLACK,
	DIA_EN_DISPLAY_PATTERN_AIVI_BLACK_WHITE,
	DIA_EN_DISPLAY_PATTERN_AIVI_CHESSBOARD,
	DIA_EN_DISPLAY_PATTERN_AIVI_CHESSBOARD_INVERT,
	DIA_EN_DISPLAY_PATTERN_AIVI_STRIPES,
	DIA_EN_DISPLAY_PATTERN_AIVI_GRAY64,
	DIA_EN_DISPLAY_PATTERN_AIVI_FLICKER_TEST,
	DIA_EN_DISPLAY_PATTERN_AIVI_TEST_MARK,
	DIA_EN_DISPLAY_PATTERN_AIVI_TEF_SPECIAL,
	DIA_EN_DISPLAY_PATTERN_AIVI_TEF_SPECIAL1,
	DIA_EN_DISPLAY_PATTERN_AIVI_TEF_SPECIAL2,
	DIA_EN_DISPLAY_PATTERN_AIVI_RGB_NOK,
	DIA_EN_DISPLAY_PATTERN_AIVI_RGB_OK,
	DIA_EN_DISPLAY_PATTERN_AIVI_RGB_REPDARK,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET01,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET02,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET03,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET04,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET05,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET06,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET07,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET08,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET09,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET10,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET11,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET12,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET13,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET14,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET15,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET16,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET17,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET18,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET19,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET20,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET21,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET22,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET23,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET24,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET25,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET26,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET27,
	DIA_EN_DISPLAY_PATTERN_AIVI_DOTDET28,
	DIA_EN_DISPLAY_PATTERN_AIVI_FI_EN_FLIP_UDHV,
	DIA_EN_DISPLAY_PATTERN_AIVI_POINT_1,
	DIA_EN_DISPLAY_PATTERN_AIVI_POINT_2,
	DIA_EN_DISPLAY_PATTERN_AIVI_POINT_3,
	DIA_EN_DISPLAY_PATTERN_AIVI_POINT_4,
	DIA_EN_DISPLAY_PATTERN_AIVI_POINT_5,
	DIA_EN_DISPLAY_PATTERN_AIVI_0_STEP_GRAY_SCALE_SIGNAL,
	DIA_EN_DISPLAY_PATTERN_AIVI_75_SMPTE_COLOR_BAR_SIGNAL,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA0,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA16,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA32,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA48,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA64,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA80,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA96,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA112,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA128,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA144,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA160,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA176,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA192,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA208,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA224,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA240,
	DIA_EN_DISPLAY_PATTERN_AIVI_GAMMA255,
	DIA_EN_DISPLAY_PATTERN_AIVI_COUNT

};

enum dia_eConfigUpdateStatus
{
   DIA_EN_CONFIG_UPDATE_STATUS_UNKNWON = -1,
   DIA_EN_CONFIG_UPDATE_STATUS_INPROGRESS = 0,
   DIA_EN_CONFIG_UPDATE_STATUS_SUCCESS,
   DIA_EN_CONFIG_UPDATE_STATUS_FAILED,
   DIA_EN_CONFIG_UPDATE_STATUS_COUNT
};


//------------------------------------------------------------------------------

class dia_IDisplayPatternAIVI
{
	DIA_DECL_INTERFACE_IID(IID_DISPLAY_PATTERN_AIVI)

public:
	//! start manual calibration procedure for touch panel alignment
	virtual tDiaResult setDisplayPatternID ( dia_eDisplayPatternAIVIID ePatternID ) = 0;
	//! update HMI block status
	virtual void setHMIBlockStatus ( void ) = 0;
	//! update Hash comparison status to HMI
	virtual void setHashComparisonStatus ( tBool hashCompStatus ) = 0;

	virtual void setCISswUpdateProcessStatus ( tBool bResult ) = 0;
	virtual void setCISswUpdateStage2ProcessStatus ( tBool bStage2Result ) = 0;

protected:
	//! virtual base class destructor
	virtual ~dia_IDisplayPatternAIVI ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI__ */

