/*****************************************************************************************
*
* \file       dia_ICVBSConnection.h
*
* \brief      interface of dia_ICVBSConnection
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     ama8kor (generated with dia_igen tool)
*
* \date       12 June 2020
*
* \copyright  (c) 2020 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_CVBSCONNECTION__
#define __INCLUDED_DIA_INTERFACE_CVBSCONNECTION__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eCVBSConnectionInfo
{
   DIA_EN_CVBS_CONNECTION_INFO_UNKNOWN = 0,
   DIA_EN_CVBS_CONNECTION_INFO_CONNECTED,
   DIA_EN_CVBS_CONNECTION_INFO_NOT_CONNECTED,
   DIA_EN_CVBS_CONNECTION_INFO_COUNT
};

//------------------------------------------------------------------------------

class dia_ICVBSConnection
{
   DIA_DECL_INTERFACE_IID(IID_CVBS_CONNECTION)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! returns the Current CVBS Connection Status
   virtual tDiaResult getCVBSConnectionStatus ( void  ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ICVBSConnection ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_CVBSCONNECTION__ */

