/*****************************************************************************************
*
* \file    dia_IBluetoothMostListener.h
*
* \brief   Listener interface for the bluetooth - most component
*
* This interface is used to deliver results for services requested via the dia_IBluetoothMost interface
*
* \author  nce5kor	
*
* \date    02.12.2015
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
* -------------------------------------------------------
* Date           | Author             | Modification
* 28-12-2015     | nce5kor			  | Added the interfaces for BTSignalQuality
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST_LISTENER__
#define __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST__
#include "dia_IBluetoothMost.h"
#endif

/**
 *
 *  \class dia_IBluetoothMostListener
 *
 */

class dia_IBluetoothMostListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_SYSADAPTER_BLUETOOTH_MOST_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! delivers information about the connected BT devices
   virtual void vOnBTConnectedDeviceList(tU8 numOfPairedDev , const dia_tBTExtendedDeviceInfo* devInf) = 0;
   //! Signal to inform requester about success of the "BT link quality" request
   virtual void vOnCustBTLinkQualityResult ( tU8 signalQuality, tU8 linkQuality ) = 0;
   //! Signal to inform requester about failure of the "BT link quality" request
   virtual void vOnCustBTLinkQualityError ( tDiaResult result ) = 0;


protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothMostListener ( void ) {}
};

/**
 *
 *  \class dia_IBluetoothMostListenerImpl
 *
 */

class dia_IBluetoothMostListenerImpl
   : public dia_IBluetoothMostListener
{
public:
   //! delivers information about the connected BT devices
   virtual void vOnBTConnectedDeviceList(tU8 /*numOfPairedDev*/, const dia_tBTExtendedDeviceInfo* /*devInf*/){}
   //! Signal to inform requester about success of the "BT link quality" request
   virtual void vOnCustBTLinkQualityResult ( tU8 /* signalQuality */, tU8 /* linkQuality */ ) {}
   //! Signal to inform requester about failure of the "BT link quality" request
   virtual void vOnCustBTLinkQualityError ( tDiaResult /* result */ ) {}
protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothMostListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IBluetoothMostNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IBluetoothMostNotifier
   : public dia_IBluetoothMostListener,
     public dia_Notifier<dia_IBluetoothMostListener>
{
public:
    //! delivers information about the connected BT devices
     DIA_M_ADD_NOTIFIER_TWO_ARG(vOnBTConnectedDeviceList,tU8, const dia_tBTExtendedDeviceInfo*)
   //! Signal to inform requester about success of the "BT link quality" request
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnCustBTLinkQualityResult,tU8,tU8)
   //! Signal to inform requester about failure of the "BT link quality" request
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnCustBTLinkQualityError,tDiaResult)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__ */

