/*****************************************************************************************
*
* \file    dia_IBluetooth.h
*
* \author  shw2abt (generated with dia_igen tool)
*
* \date    05 September 2014
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
* -------------------------------------------------------
* Date           | Author             | Modification
* 28-12-2015     | nce5kor			  | Commented the code for customer bt signal quality.
										New CCA implementation will be provided with next release.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH__
#define __INCLUDED_DIA_INTERFACE_BLUETOOTH__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif


#ifndef IID_SYSADAPTER_BLUETOOTH
#define IID_SYSADAPTER_BLUETOOTH ((dia::IID) 0xc65c06d1)
#endif

//------------------------------------------------------------------------------

enum dia_eBTMode
{
   DIA_EN_BT_MODE_UNKNOWN = 0,
   DIA_EN_BT_MODE_NORMAL,
   DIA_EN_BT_MODE_PRODUCTION,
   DIA_EN_BT_MODE_DUT,
   DIA_EN_BT_MODE_COUNT
};

//------------------------------------------------------------------------------

enum dia_eBTAction
{
   DIA_EN_BT_ACTION_UNKNOWN = 0,
   DIA_EN_BT_ACTION_TESTTONESTART,
   DIA_EN_BT_ACTION_TESTTONESTOP,
   DIA_EN_BT_ACTION_LOCALLOOPBACKSTART,
   DIA_EN_BT_ACTION_LOCALLOOPBACKSTOP,
   DIA_EN_BT_ACTION_COUNT
};

//------------------------------------------------------------------------------

enum dia_eBTNotification
{
   DIA_EN_BT_NOTIFICATION_UNKNOWN = 0,
   DIA_EN_BT_NOTIFICATION_TESTMODE,
   DIA_EN_BT_NOTIFICATION_TESTACTION,
   DIA_EN_BT_NOTIFICATION_CONNECTIONSTATUS,
   DIA_EN_BT_NOTIFICATION_LINKQUALITYSTATUS,
   DIA_EN_BT_NOTIFICATION_DISCONNECTIONSTATUS,
   DIA_EN_BT_NOTIFICATION_COUNT
};

//------------------------------------------------------------------------------

enum dia_eDiaBTMuteIndication
{
   DIA_EN_BT_MUTE_PIN_STATE_UNKNOWN = 0,
   DIA_EN_BT_MUTE_PIN_STATE_OPEN,
   DIA_EN_BT_MUTE_PIN_STATE_GROUND,
   DIA_EN_BT_MUTE_PIN_STATE_COUNT
};

//------------------------------------------------------------------------------

struct dia_BTDeviceInfo
{
public:
   //! default constructor
   dia_BTDeviceInfo ( void )
      : btStr(0),
        btStrLen(0)
   {}

   //! copy constructor
   dia_BTDeviceInfo ( const dia_BTDeviceInfo& obj )
      : btStr(obj.btStr),
        btStrLen(obj.btStrLen)
   {}

   //! assignment operator
   dia_BTDeviceInfo& operator = ( const dia_BTDeviceInfo& obj )
   {
      if ( this != &obj ) {
         btStr = obj.btStr;
         btStrLen = obj.btStrLen;
      }
      return *this;
   }

   //! class constructor
   dia_BTDeviceInfo (
         tString /*str*/, 
         tU16 /*len*/
      )
      : btStr(0),
        btStrLen(0)
   {}

public:
   tString btStr;
   tU16 btStrLen;
};

#define DIA_BT_SERVICE_NOT_SUPPORTED					0xFFFF

//------------------------------------------------------------------------------

class dia_IBluetooth
{
   DIA_DECL_INTERFACE_IID(IID_SYSADAPTER_BLUETOOTH)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! register for status notifications
   virtual tDiaResult attachNotification ( dia_eBTNotification id ) = 0;
   //! unregister for status notifications
   virtual tDiaResult detachNotification ( dia_eBTNotification id ) = 0;
   //! set mode of BT module
   virtual tDiaResult setMode ( dia_eBTMode mode ) = 0;
   //! request the given action to be executed in the BT module
   virtual tDiaResult executeAction ( dia_eBTAction actionID ) = 0;
   //! get the Bluetooth MAC-Address
   virtual tDiaResult vGetBluetoothMacAddress ( void  ) = 0;
   //! get the Bluetooth MAC-Address
   virtual tDiaResult vGetWifiMacAddress ( void  ) = 0;
   //! get the Bluetooth device Address
   virtual tDiaResult vGetBluetoothDeviceAddress ( void  ) = 0;
   //! unknown
   virtual tDiaResult vGetBluetoothFieldstrength ( const tU8* const pabBDAddress ) = 0;
   //! unknown
   virtual tDiaResult vGetBluetoothWifiFieldstrength ( const tU8* const pabBDAddress ) = 0;
   //! unknown
   virtual tDiaResult vStartConnectBluetoothDeviceAddress ( const tBool bType, const tU8* const pabBDAddress ) = 0;
   //! unknown
   virtual tDiaResult vGetStatusConnectBluetoothDeviceAddress ( void  ) = 0;
   //! unknown
   virtual tDiaResult vGetConnectedDeviceStatus ( const tU8 u8Device ) = 0;
   //! unknown
   virtual tDiaResult vGetDeviceLinkQuality ( const tU8 u8Device ) = 0;
   //! unknown
   virtual tDiaResult vGetAuthenticatedDevicesPresent ( void  ) = 0;
   //! Get the link quality of the current connection
   //virtual tDiaResult vGetBTLinkQuality ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IBluetooth ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_BLUETOOTH__ */

