/*
 * dia_IAIVISecurityListener.h
 *
 *  Created on: 24.08.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY_LISTENER__
#define __INCLUDED_DIA_INTERFACE_AIVI_SECURITY_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY__
#include "dia_IAIVISecurity.h"
#endif

//-----------------------------------------------------------------------------

class dia_IAIVISecurityListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_AIVI_SECURITY_LISTENER)

public:
    //! notify the ECU Serial Number
    virtual void vOnEcuSerialNumber ( const std::vector<tU8>& ) = 0;
    //! notify the StaticKey
    virtual void vOnStaticKey ( const std::vector<tU8>& ) = 0;
    //! notify the IndexSrvData
    virtual void vOnIndexSrvData ( const std::vector<tU8>& ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_IAIVISecurityListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_IAIVISecurityListenerImpl
    : public dia_IAIVISecurityListener
{
public:
    virtual void vOnEcuSerialNumber ( const std::vector<tU8>& ) {}
    virtual void vOnStaticKey ( const std::vector<tU8>& ) {}
    virtual void vOnIndexSrvData ( const std::vector<tU8>& ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_IAIVISecurityListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_IAIVISecurityNotifier
    : public dia_IAIVISecurityListener,
      public dia_Notifier<dia_IAIVISecurityListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnEcuSerialNumber,const std::vector<tU8>&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnStaticKey,const std::vector<tU8>&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnIndexSrvData,const std::vector<tU8>&)
};


#endif /* __INCLUDED_DIA_INTERFACE_AIVI_SECURITY_LISTENER__ */
