/*
***********************************************************************
* FILE:           dia_defsVinConfig.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    configuration file for VIN module.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 04.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
***********************************************************************/
#ifndef __INCLUDED_DIA_DEFS_CONFIG_VIN__
#define __INCLUDED_DIA_DEFS_CONFIG_VIN__


#define DIA_M_MAKE_ODOMETER_VALUE_RAW(A, B, C, D) (tU32)(((A<<24) | (B<<16)| (C<<8) | D))
#define DIA_M_MAKE_ODOMETER_VALUE_U32(A, B, C, D) (tU32)(((A<<24) | (B<<16)| (C<<8) | D))
#define DIA_M_MAKE_ODOMETER_VALUE_PHY(A) (tU32)(A / 8)

static tCString strVINThreadName 		 = "DIA_VIN_THREAD";
static tCString strVINQueueName  		 = "DIA_VINQ";
static tCString strVINOdometerThreadName = "DIA_VIN_ODOMETER_THREAD";
static tCString strVINOdometerQueueName  = "DIA_VINODOQ";

#ifndef ODOMETER_LOCKED
#define ODOMETER_LOCKED 		TRUE
#endif

#ifndef ODOMETER_NOT_LOCKED
#define ODOMETER_NOT_LOCKED		FALSE 
#endif

#ifndef ODOMETER_LIMIT_LOCKED
#define ODOMETER_LIMIT_LOCKED 		TRUE
#endif

#ifndef ODOMETER_LIMIT_NOT_LOCKED
#define ODOMETER_LIMIT_NOT_LOCKED		FALSE 
#endif

#ifndef VIN_LOCKED
#define VIN_LOCKED 		TRUE
#endif

#ifndef VIN_NOT_LOCKED
#define VIN_NOT_LOCKED		FALSE 
#endif

#define VIN_QUEUE_SIZE       100
#define VIN_STR_BUFF_SIZE    200

#define ODOMETER_QUEUE_SIZE       100
#define ODOMETER_STR_BUFF_SIZE    200

#define ODOMETER_CAN_SIGNAL_PROCESSING_INTERVAL		8000 // * SECONDS BASED ON THE RESOLUTION & FACTOR OF THE CAN SIGNAL

#define VIN_ODOMETER_LOCKED				(tU8)1
#define VIN_FINAL_SEGMENT 				(tU8)2
#define VIN_MAX_NUM_OF_SEGMENTS  		(tU8)3
#define VIN_MAX_CAN_FRAME_LENGTH		(tU8)8
#define VIN_LENGTH_MAX  		   		(tU8)17
#define VIN_ODOMETER_CAN_SIGNAL_LENGTH	(tU8)4
#define VIN_ODOMETER_LIMIT 		   		(tU8)0xFA
#define VIN_ODOMETER_LIMIT_DEFAULT 		(tU8)0xFA
#define VIN_ODOMETER_DEFAULT 		    (tU8)0x00
#define VIN_ODOMETER_NO_DATA		VIN_ODOMETER_DEFAULT
#define VIN_DEFAULT_VALUE 				     0x41
#define VIN_VALID_RANGE_NUMBER_LOW			 0x30
#define VIN_VALID_RANGE_NUMBER_HIGH			 0x39
#define VIN_VALID_RANGE_CHAR_LOW			 0x41
#define VIN_VALID_RANGE_CHAR_HIGH			 0x5A
#define VIN_INVALID_SPECIAL_CHAR_0x49		 0x49
#define VIN_INVALID_SPECIAL_CHAR_0x4F		 0x4F
#define VIN_INVALID_SPECIAL_CHAR_0x51		 0x51






















#endif