/************************************************************************
* FILE:           dia_VINStateMachineHandler.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implements VIN handling for the VIN Slave ECU.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 08.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/
#ifndef __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__
#define __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include <common/framework/application/dia_LockScope.h>
#endif

class dia_VINStateMachineHandler
{
	//! Implement Singleton class with default constructor & destructor 
		DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR_WITH_SETUP_AND_TEARDOWN(dia_VINStateMachineHandler);
		
	public:
		//! class constructor
		dia_VINStateMachineHandler ( void );
		//! class destructor
		~dia_VINStateMachineHandler ( void );
		//!
		tDiaResult processVINRequest( const std::vector<tU8>& rcvdVin );
		//!
		tDiaResult resetAllVINParameters(void);
		//!
		tDiaResult setVINtoDefaultState(void);
		//!
		tBool isVINlocked( void );
		
	private:

		//!
		enum dia_enVINCompareType
		{
			DIA_EN_VIN_COMPARE_TYPE_UNKNOWN = 0,
			DIA_EN_VIN_COMPARE_TYPE_CURRENT_RCVD_AND_DEFAULT,
			DIA_EN_VIN_COMPARE_TYPE_CURRENT_RCVD_AND_STORED,
			DIA_EN_VIN_COMPARE_TYPE_CURRENT_STORED_AND_ORIGINAL,
			DIA_EN_VIN_COMPARE_TYPE_ORIGINAL_STORED_AND_DEFAULT,
			DIA_EN_VIN_COMPARE_TYPE_COUNT,
		};
		//!
		tDiaResult processVINCommon(void);
		//!
		tDiaResult writeProperty( const std::vector<tU8>& /*vecVINPropertyin */, const tU32 /* u32VinPropertyType */ );
		//!
		tDiaResult readProperty( const tU32 /* u32VinPropertyType */, std::vector<tU8>& /* vecVINPropertyout */ );
		//!
		// tDiaResult writeVINCurrent(void);
		//!
		// tDiaResult readVINCurrent(void);
		//!
		// tDiaResult writeVINOriginal(void);
		//!
		// tDiaResult readVINOriginal(void);
		//!
		tDiaResult compareVIN( const dia_enVINCompareType /* mType */);
		//!
		tDiaResult compareVINOdometer(void);
		//!
		tU8 readVINOdometer(const tU32 /* u32VinPropertyType */);
		//!
		tDiaResult resetVIN(const tU32 /* u32VinPropertyType */);
		//!
		tDiaResult validateRcvdVIN( const std::vector<tU8>& /* vecRcvdVIN */);
		//!
		static std::vector<tU8> vecVINDefault;
		//!
		static std::vector<tU8> vecVINOriginal;
		//!
		static std::vector<tU8> vecVINCurrent;
		//!
		static std::vector<tU8> vecVINReceived;
		//!
		tU8 u8Odometer;
		
protected:
   //! synchronization object used to synchronize concurrent access from multiple threads
   mutable dia::Lock mSyncObj;
		
};

#endif /* __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__ */