/************************************************************************
* FILE:           dia_VIN.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    Interface between CAN Signal handler & VIN Handling State Machine.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 08.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
************************************************************************/

#ifndef __INCLUDED_DIA_VIN__
#define __INCLUDED_DIA_VIN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_QUEUE__
#include "common/framework/application/dia_Queue.h"
#endif

class dia_VIN : public dia_ActiveObject
{
	/* Implement Singleton class with default constructor & destructor */
	DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_VIN);
	
	enum dia_enVINHandlingType
	{
		DIA_EN_VIN_HANDLING_TYPE_UNKNOWN = 0,
		DIA_EN_VIN_HANDLING_TYPE_EXTERNAL_REQUEST,
		DIA_EN_VIN_HANDLING_TYPE_TERMINATE,
		DIA_EN_VIN_HANDLING_TYPE_COUNT,
	};
	
	struct dia_VINMessage
    {
       dia_VINMessage ( dia_enVINHandlingType type, void* msgData = 0 ) : mType(type), mpMsgData(msgData) {}
       ~dia_VINMessage ( void ) {}
       dia_enVINHandlingType mType;
       void* mpMsgData;
    };
	
	struct dia_VINSignal
	{
		std::vector<tU8> mVINData;
	};
		
public:
	//! class constructor
   dia_VIN ( void );
   //! class destructor
   virtual ~dia_VIN ( void );	
   
    //! we use a two level construction process
   virtual tDiaResult setup ( void );
   virtual tDiaResult tearDown ( void );
   
   //! post a trigger event to the state machine
   virtual void postEvent (dia_enVINHandlingType type, void* msgData);
	
protected:
   //! deprecated class constructor
   //dia_VIN ( void );
   //! thread entry method inherited from dia_ActiveObject
   virtual void vThreadEntrypointObject ( void );
   //! Already part of constructor
   //static dia_VIN* mpInstance;
   //! message queue used for communication with the server engine
   dia_Queue<dia_VINMessage>* mpMsgQueue;
   //! flag used to indicate if setup of the engine was done
   tBool mIsSetupDone;
   
};

#endif /* __INCLUDED_DIA_VIN__ */
