/*
***********************************************************************
* FILE:           dia_Odometer.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    VIN Odometer Handling.
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 04.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
***********************************************************************
*/

#ifndef __INCLUDED_DIA_VINODOMETERHANDLER__
#define __INCLUDED_DIA_VINODOMETERHANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT 

class dia_Odometer
{

  /* Implement Singleton class with default constructor & destructor */
  DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR_WITH_SETUP_AND_TEARDOWN(dia_Odometer);

public:
  //! class constructor
  dia_Odometer( void );
  //! class constructor
  virtual ~dia_Odometer( void );
  //! process received
  tDiaResult vProcessOdometer( void );
  //!
  tBool isOdometerLocked( void );
  //!
  //tBool isOdometerLimitLocked ( void );
  //! 
  tDiaResult getOdometerLimit ( tU8* );
  //! 
  tDiaResult getOdometerCounter( tU8* );
  //!
  tDiaResult lockOdometer( void );

protected:
  //!
  tDiaResult getOdometerReference( tU32* );
  //!
  tBool getOdometerLockStatus( void );
  //!
  tDiaResult storeOdometerCounter( tU8 );
  //!
  tBool _mOdometerLockStatus;
  //!
  //tBool _mOdometerLimitLockStatus;
  
};

dia_Odometer* getInstanceOfOdometerHandler ( void );
void releaseInstanceOfOdometerHandler ( void );

#else /* VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT */

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_QUEUE__
#include "common/framework/application/dia_Queue.h"
#endif

class dia_VINOdometerHandler : public dia_ActiveObject
{
	/* Implement Singleton class with default constructor & destructor */
	DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_VINOdometerHandler);
	
	enum dia_enVINOdometerHandlingType
	{
		DIA_EN_VIN_ODOMETER_HANDLING_TYPE_UNKNOWN = 0,
		DIA_EN_VIN_ODOMETER_HANDLING_TYPE_EXTERNAL_REQUEST,
		DIA_EN_VIN_ODOMETER_HANDLING_TYPE_TERMINATE,
		DIA_EN_VIN_ODOMETER_HANDLING_TYPE_COUNT,
	};
	
	struct dia_VINOdometerMessage
    {
       dia_VINOdometerMessage ( dia_enVINOdometerHandlingType type, void* msgData = 0 ) : mType(type), mpMsgData(msgData) {}
       ~dia_VINOdometerMessage ( void ) {}
       dia_enVINOdometerHandlingType mType;
       void* mpMsgData;
    };

	struct dia_VINOdometerSignal
	{
		tU8 Odometer_Seg1 : 8;
		tU8 Odometer_Seg2 : 8;
		tU8 Odometer_Seg3 : 8;
		tU8 Odometer_Seg4 : 8;
	};

public:
   //! class constructor
   dia_VINOdometerHandler ( void );
   //! class destructor
   virtual ~dia_VINOdometerHandler ( void );

   //! we use a two level construction process
   virtual tDiaResult setup ( void );
   virtual tDiaResult tearDown ( void );

   //! post a trigger event to the state machine
   virtual void postEvent (dia_enVINOdometerHandlingType type, void* msgData);
   // Already part of contructor
   //static dia_VINOdometerHandler* getInstance();

protected:
   //! deprecated class constructor
   //dia_VINOdometerHandler ( void );
   //! thread entry method inherited from dia_ActiveObject
   virtual void vThreadEntrypointObject ( void );
   //! Already part of constructor
   //static dia_VINOdometerHandler* mpInstance;
   //! message queue used for communication with the server engine
   dia_Queue<dia_VINOdometerMessage>* mpMsgQueue;
   //! flag used to indicate if setup of the engine was done
   tBool mIsSetupDone;
};

#endif /* VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT  */





























































































































































#endif /* __INCLUDED_DIA_VINODOMETERHANDLER__ */