/***********************************************************************
* FILE:           dia_EngineVIN.h
* PROJECT:        COACH MEDIA CENTER - DAIMLER EVOBUS
* SW-COMPONENT:   DIAGNOSIS
*----------------------------------------------------------------------
*
* DESCRIPTION:    Engine for VIN module. Creates/destroys instances of CAN Signal Handler,
*                 Odometer Handler, VIN Handler & VIN State Machine
*
*----------------------------------------------------------------------
* HISTORY:
* Date           | Author                            | Modification
*----------------------------------------------------------------------
* 12.03.2019     | Arjun Manjunath Sanu (RBEI/ECA2)  | Initial
***********************************************************************/

#ifndef __INCLUDED_DIA_VIN_ENGINE__
#include "project/framework/vin/dia_EngineVIN.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_VIN__
#include "project/framework/vin/dia_defsVinConfig.h"
#endif

#ifndef __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__
#include "project/framework/vin/dia_VINStateMachineHandler.h"
#endif 

#ifndef __INCLUDED_DIA_VIN__
#include "project/framework/vin/dia_VIN.h"
#endif

#ifndef __INCLUDED_DIA_VINODOMETERHANDLER__
#include "project/framework/vin/dia_Odometer.h"
#endif

#ifndef __INCLUDED_DIA_CANSIGNALHANDLER__
#include "project/framework/vin/dia_CANSignalHandler.h"
#endif

DIA_IMPL_SINGLETON_WITH_SETUP_AND_TEARDOWN(dia_EngineVIN);

/************************************************************************
*FUNCTION: 		dia_EngineVIN
*DESCRIPTION: 	Constructor
*PARAMETER:		None
*RETURNVALUE: 	None
*
************************************************************************/
dia_EngineVIN::dia_EngineVIN()
{
	dia_tclFnctTrace oTrace("dia_EngineVIN::dia_EngineVIN(...)");
}
/************************************************************************
*FUNCTION: 		~dia_EngineVIN
*DESCRIPTION: 	Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*
************************************************************************/
dia_EngineVIN::~dia_EngineVIN()
{
	DIA_TR_INF("dia_EngineVIN::~dia_EngineVIN(...)");
}
/************************************************************************
*FUNCTION: 		setup
*DESCRIPTION: 	Method to create VIN related class instances
*PARAMETER:		void
*RETURNVALUE: 	tDiaResult - DIA_SUCCESS/DIA_FAILED
*
************************************************************************/
tDiaResult 
dia_EngineVIN::setup( void )
{
	dia_tclFnctTrace oTrace("dia_EngineVIN::setup(...)");
	
//-----------------------------------------------------------------------------------------------
    //! Create instance of VIN State Machine Handler
	dia_VINStateMachineHandler* _poVinSM = dia_VINStateMachineHandler::getInstance();
	if( _poVinSM ){}
	else
	{
		DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_VINStateMachineHandler object");
		return DIA_FAILED;
	}
//-----------------------------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT 
	//! Create instance of VIN Handler
	dia_VIN* _poVin = OSAL_NEW dia_VIN();
	if( _poVin )
	{
		if(DIA_SUCCESS == _poVin->setup()){}
		else
		{
			DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_VIN object");
			return DIA_FAILED;
		}
	}else{ DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_VIN object");  return DIA_FAILED; }
//-----------------------------------------------------------------------------------------------
	//! Create instance of VIN Odometer Handler 
	dia_VINOdometerHandler* _poVinOdoHdl = OSAL_NEW dia_VINOdometerHandler();
	if( _poVinOdoHdl )
	{
		if(DIA_SUCCESS == _poVinOdoHdl->setup()) {}
		else
		{
			DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_VINOdometerHandler object");
			return DIA_FAILED;
		}
	}else{ DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_VINOdometerHandler object"); return DIA_FAILED; }
//-----------------------------------------------------------------------------------------------
#endif

	dia_Odometer* _poVinOdoHdl = getInstanceOfOdometerHandler();
	if( NULL == _poVinOdoHdl )
	{
		DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_Odometer object"); return DIA_FAILED;
	}else{}
//-----------------------------------------------------------------------------------------------
	//! Create instance of CAN Signal Handler
	dia_CANSignalHandler* _poCSMSigHdl = dia_CANSignalHandler::getInstance();
	if( _poCSMSigHdl ){}
	else
	{
		DIA_TR_ERR("ERROR - dia_EngineVIN::setup: Cannot create dia_CANSignalHandler object");
		return DIA_FAILED;
	}


	
	return DIA_SUCCESS;
//-----------------------------------------------------------------------------------------------
}
/************************************************************************
*FUNCTION: 		setup
*DESCRIPTION: 	Method to destroy/delete VIN related class instances
*PARAMETER:		void
*RETURNVALUE: 	tDiaResult - DIA_SUCCESS/DIA_FAILED
*
************************************************************************/
tDiaResult 
dia_EngineVIN::tearDown( void )
{
	dia_tclFnctTrace oTrace("dia_EngineVIN::tearDown(...)");
//-----------------------------------------------------------------------------------------------
	//!	
	dia_VINStateMachineHandler* _poVinSM = dia_VINStateMachineHandler::getInstance();
	if( _poVinSM )
	{
		dia_VINStateMachineHandler::deleteInstance();
		_poVinSM = 0;
		DIA_TR_INF("Deleted Instance - dia_VINStateMachineHandler"); 
	}
//-----------------------------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_CMC19_EVOBUS_VIN_THREAD_CONCEPT 
	//!	
	dia_VIN* _poVin = dia_VIN::getInstance();
	if( _poVin )
	{
		dia_VIN::deleteInstance();
		_poVin = 0;
		DIA_TR_INF("Deleted Instance - dia_VIN"); 
	}
//-----------------------------------------------------------------------------------------------
	//!	
	dia_VINOdometerHandler * _poVinOdoHdl = dia_VINOdometerHandler::getInstance();
	if ( _poVinOdoHdl )
	{
		dia_VINOdometerHandler::deleteInstance();
		_poVinOdoHdl = 0;
		DIA_TR_INF("Deleted Instance - dia_VINOdometerHandler");
	}
//-----------------------------------------------------------------------------------------------
#endif
		(void) releaseInstanceOfOdometerHandler();
//-----------------------------------------------------------------------------------------------
	//!	
	dia_CANSignalHandler* _poCSMSigHdl = dia_CANSignalHandler::getInstance();
	if (_poCSMSigHdl)
	{
		dia_CANSignalHandler::deleteInstance();
		_poCSMSigHdl = 0;
		DIA_TR_INF("Deleted Instance - dia_CANSignalHandler");
	} 
	
	
	return DIA_SUCCESS;
}
