/*!
 * \file       dia_TraceCmdFactoryProject.cpp
 *
 * \brief      project specific TTFIs trace command factory
 *
 * \details    project specific TTFIs trace command factory
 *
 * \component  Diagnosis
 *
 * \ingroup    diaTraceCmdFactory
 *
 * \copyright  (c) 2011-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
#ifndef DIA_TRACECMDLOGCANSIGNAL_H_
#include "project/framework/trace/dia_TraceCmdLogCANSignal.h"
#endif
#endif

#ifndef DIA_TRACECMDCLEARDTCS_H_
#include "project/framework/trace/dia_TraceCmdClearDTCs.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_CMD_EXECUTE_XTRA_DATA__
#include "project/framework/trace/dia_TraceCmdExecuteXtraData.h"
#endif

#include "dia_TraceCmdFactoryProject.h"

using namespace dia;



dia_TraceCmdFactoryProject::dia_TraceCmdFactoryProject()
{
}

dia_TraceCmdFactoryProject::~dia_TraceCmdFactoryProject()
{
}

tDiaResult dia_TraceCmdFactoryProject::init()
{
   dia_TraceCmdFactory::registerProjectTraceCommandFactory(this);

   return DIA_SUCCESS;
}

tDiaResult dia_TraceCmdFactoryProject::deinit()
{
   dia_TraceCmdFactory::unregisterProjectTraceCommandFactory(this);

   return DIA_SUCCESS;
}

dia_TraceCmd* dia_TraceCmdFactoryProject::createTraceCmdProject(tU16 traceCmdId)
{
   switch (traceCmdId)
   {
    case dia_TraceCmdFactory::ProjectCmd01: // First project specific TTFis command
    {
      DIA_TR_INF("dia_TraceCmdFactoryProject::createTraceCmd. Trying ProjectCmd01");
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
      DIA_TR_INF("dia_TraceCmdFactoryProject::createTraceCmd Creating instance of dia_TraceCmdLogCANSignal");
      return new dia_TraceCmdLogCANSignal();
#endif
    }
    break;

    case dia_TraceCmdFactory::ProjectCmd02: // Project specific TTFis command to clear DTCs
    {
      DIA_TR_INF("dia_TraceCmdFactoryProject::createTraceCmd. Trying ProjectCmd02");
      DIA_TR_INF("dia_TraceCmdFactoryProject::createTraceCmd Creating instance of dia_TraceCmdClearDTCs");
      return new dia_TraceCmdClearDTCs();
    }
    break;

    case dia_TraceCmdFactory::ProjectCmd03: // Project specific TTFis command to start Xtra Data
    {
      DIA_TR_INF("dia_TraceCmdFactoryProject::createTraceCmd. Trying ProjectCmd03");
      DIA_TR_INF("dia_TraceCmdFactoryProject::createTraceCmd Creating instance of TraceCmdExecuteXtraData");
      return new dia::TraceCmdExecuteXtraData();
    }
    break;

    default:
    {
    }
    break;
   }

   DIA_TR_ERR("dia_TraceCmdFactoryProject::createTraceCmd Not supported cmd! traceCmdId=0x%04x", traceCmdId);
   return NULL;
}
