/*
 * dia_TraceCmdExecuteXtraData.cpp
 *
 *  Created on: 06.11.2017
 *      Author: kaa1hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_CMD_EXECUTE_XTRA_DATA__
#include <project/framework/trace/dia_TraceCmdExecuteXtraData.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include <common/framework/test/dia_TestController.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif


#define DIA_MESSAGE_LEN (4)

namespace dia {

// p = pMessage
//               p0 p1 p2 p3 p4 p5
//                        |   |  |
// (2 bytes) cmdID      --|-+-|  |
// (1 byte)  sessionID  ---------|

void
TraceCmdExecuteXtraData::execute ( const tU8* pMessage ) const
{
   ScopeTrace oTrace("dia::TraceCmdExecuteXtraData::execute");

   if (DIA_MESSAGE_LEN != pMessage[0])
   {
      DIA_TR_ERR("dia::TraceCmdExecuteXtraData::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      DIA_TR_ERR("dia::TraceCmdExecuteXtraData::execute Expected message length is 4.");
      DIA_TR_INF("dia::TraceCmdExecuteXtraData::execute Usage #2: DIA_CMD 34");
      return;
   }

   DIA_TR_INF("############################################################");
   DIA_TR_INF("#");
   DIA_TR_INF("# START CALIBRATION (XTRA DATA)");
   DIA_TR_INF("#");
   DIA_TR_INF("############################################################");

   (void) getInstanceOfTestController()->runTests(DIA_EN_TESTCONDITION_XTRA_DATA);
}

}
