/*
 * dia_TestXtraData.cpp
 *
 *  Created on: 05.12.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_TEST_XTRA_DATA__
#include <project/framework/test/dia_TestXtraData.h>
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include <common/framework/test/dia_TestController.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include <common/framework/config/dia_ConfigManager.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_XTRA_DATA__
#include <project/framework/factory/dia_FactoryPluginXtraData.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include <common/depricated/dia_main.h>
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__
#include <common/framework/factory/dia_FactoryPluginPDXFlashing.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__
#include <common/framework/engine/dia_EngineFlashConfiguration.h>
#endif

namespace dia {

//-----------------------------------------------------------------------------

TestXtraData::TestXtraData ( void )
   : dia_TestService("dia::TestXtraData", DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_XTRA_DATA)
{
   ScopeTrace oTrace("dia::TestXtraData::TestXtraData()");
}

//-----------------------------------------------------------------------------

TestXtraData::~TestXtraData ( void )
{
}

//-----------------------------------------------------------------------------

void
TestXtraData::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   ScopeTrace oTrace("dia::TestXtraData::vProcessRequest()");

#if 0 /* kaa1hi AIVI-59871 to be finished */
   FactoryPluginXtraData* pdxXtraData = getInstanceOfFactoryPluginXtraData();
   if ( pdxXtraData )
   {
      const std::list<std::string>& pdxFiles = pdxXtraData->getPDXContainers();

      if ( pdxFiles.size() == 0 )
      {
         DIA_TR_INF("dia::TestXtraData::vProcessRequest(): NO PDX FILES FOUND FOR CALIBRATION !!!");
      }
      else
      {
         DIA_TR_INF("############################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# START XTRA_DATA-ENGINE");
         DIA_TR_INF("#");
         DIA_TR_INF("############################################################");

         // run-in was not deactivated, so we have to start the run-in
         tDiaResult retCode = pdxXtraData->setup();
         if ( retCode == DIA_SUCCESS )
         {
            DIA_TR_INF("### XTRA_DATA-ENGINE STARTED SUCCESSFULLY ###");

            //adapt configuration
            dia::EngineFlashConfiguration* pEngCfg = pdxXtraData->getEngineConfiguration();
            if (NULL!=pEngCfg)
            {
               pEngCfg->setLoadPDXContainersOnce(false);
               DIA_TR_INF("Xtra Data Flash Engine can be triggered several times.");
            }
            else
            {
               DIA_TR_ERR("### Cannot change default engine configuration. ###");
            }
         }
         else if ( retCode == DIA_E_ALREADY_STARTED )
         {
            DIA_TR_ERR("### XTRA_DATA-ENGINE ALREADY STARTED. TRIGGER START OF FLASHING !!");
            pdxXtraData->startFlashing();
         }
         else
         {
            DIA_TR_ERR("### FAILED TO START XTRA_DATA-ENGINE (ERRCODE = 0x%08X", retCode);
         }
      }
   }
#endif

   testTerminate();
}

}

