/**
 * \file      dia_TestVIN.cpp
 *
 * \brief     {Test object to interact with dia_VINStateMachineHandler to process VIN data}
 *
 * \details   {insert file description here}
 *
 * \author    ama8kor
 * \date      Mar 26, 2019
 *
 * \copyright Robert Bosch Car Multimedia 2019
 */

#ifndef __DIA_INCLUDED_TEST_VIN__
#include "dia_TestVIN.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__
#include "project/framework/vin/dia_VINStateMachineHandler.h"
#endif 

#ifndef __INCLUDED_DIA_DEFS_CONFIG_VIN__
#include "project/framework/vin/dia_defsVinConfig.h"
#endif

#ifndef __INCLUDED_DIA_CANSIGNALHANDLER__
#include "project/framework/vin/dia_CANSignalHandler.h"
#endif

#include <iostream>

/*******************************************************************************
 * FUNCTION   : dia_TestVIN ()
 * DESCRIPTION: constructor
 * PARAMETER  : None
 * RETURNVALUE: None
 *******************************************************************************/
dia_TestVIN::dia_TestVIN ( void )
   : dia_TestService("dia_TestVIN",DIA_C_U8_UDS_SID_DIAG_COMMAND,DIA_C_U16_INT_TEST_DID_CENTER_CMC_19_VIN_CURRENT)
{
   dia_tclFnctTrace oTrace("dia_TestVIN::dia_TestVIN ");
}

/*******************************************************************************
 * FUNCTION   :~dia_TestVIN ( )
 * DESCRIPTION: Destructor
 * PARAMETER  : None
 * RETURNVALUE: None
 *******************************************************************************/
dia_TestVIN::~dia_TestVIN ( void )
{
   DIA_TR_INF("dia_TestVIN::~dia_TestVIN");
}


/*******************************************************************************
 * FUNCTION   : vProcessRequest ( const std::vector<void*>& vecArgs )
 * DESCRIPTION: Process the request to Update VIN Value into KDS
 * PARAMETER  : const std::vector<void*>
 * RETURNVALUE: None
 *******************************************************************************/
void
dia_TestVIN::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestVIN::vProcessRequest");

   std::vector<tU8> vecVin;
   //tString strVin;
   
   vecVin.reserve(17);
   //vecVin.resize(17);

   if(DIA_SUCCESS == getReceivedVIN(vecVin))
   {

      for(tU8 i=0; i<VIN_LENGTH_MAX; ++i)
      {
         DIA_TR_INF("dia_TestVIN::vProcessRequest -> hex[%d] = 0x%X ( %c )", i, vecVin[i], vecVin[i]);        
      }
      

      //DIA_TR_INF("dia_TestVIN::STRING -> ( %s )", strVin);

      dia_VINStateMachineHandler* pVinSM = dia_VINStateMachineHandler::getInstance();
      if( pVinSM )
      {
         if (DIA_SUCCESS == pVinSM->processVINRequest(vecVin))
         {
            DIA_TR_INF("dia_TestVIN::vProcessRequest - Processing done !!");
         }
      }
      
   }

   testTerminate();
}

/*******************************************************************************
 * FUNCTION   : vOnTimeout ()
 * DESCRIPTION: handle timeout while processing the service
 * PARAMETER  : None
 * RETURNVALUE: None
 *******************************************************************************/
void
dia_TestVIN::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_TestVIN::vOnTimeout()");
   testTerminate();
}