/**
 * \file      dia_TestOdometer.h
 *
 * \brief     {Test object to interact with dia_Odometer to process odometer data}
 *
 * \details   {insert file description here}
 *
 * \author    ama8kor
 * \date      Mar 26, 2019
 *
 * \copyright Robert Bosch Car Multimedia 2019
 */

#ifndef __DIA_INCLUDED_TEST_ODOMETER__
#include "dia_TestOdometer.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_VINODOMETERHANDLER__
#include "project/framework/vin/dia_Odometer.h"
#endif


/*******************************************************************************
 * FUNCTION   : dia_TestOdometer ()
 * DESCRIPTION: constructor
 * PARAMETER  : None
 * RETURNVALUE: None
 *******************************************************************************/
dia_TestOdometer::dia_TestOdometer ( void )
   : dia_TestService("dia_TestOdometer",DIA_C_U8_UDS_SID_DIAG_COMMAND,DIA_C_U16_INT_TEST_DID_CENTER_CMC_19_VIN_ODOMETER)
{
   dia_tclFnctTrace oTrace("dia_TestOdometer::dia_TestOdometer ");
}

/*******************************************************************************
 * FUNCTION   :~dia_TestOdometer ( )
 * DESCRIPTION: Destructor
 * PARAMETER  : None
 * RETURNVALUE: None
 *******************************************************************************/
dia_TestOdometer::~dia_TestOdometer ( void )
{
   DIA_TR_INF("dia_TestOdometer::~dia_TestOdometer");
}


/*******************************************************************************
 * FUNCTION   : vProcessRequest ( const std::vector<void*>& vecArgs )
 * DESCRIPTION: Process the request to Update Odometer Value into KDS
 * PARAMETER  : const std::vector<void*>
 * RETURNVALUE: None
 *******************************************************************************/
void
dia_TestOdometer::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestOdometer::vProcessRequest");

   dia_Odometer* pOdometerHandler = getInstanceOfOdometerHandler();
   if(pOdometerHandler)
   {
   	if (DIA_SUCCESS == pOdometerHandler->vProcessOdometer())
   	{
   		DIA_TR_INF("dia_TestOdometer::vProcessRequest - Processing done !!");
   	}
   }

   testTerminate();
}

/*******************************************************************************
 * FUNCTION   : vOnTimeout ()
 * DESCRIPTION: handle timeout while processing the service
 * PARAMETER  : None
 * RETURNVALUE: None
 *******************************************************************************/
void
dia_TestOdometer::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_TestOdometer::vOnTimeout()");
   testTerminate();
}