/*!
 * \file       dia_TestFactoryMode.cpp
 *
 * \brief      Internal Test for Factory Mode
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_TEST_FACTORY_MODE_H_
#define __INCLUDED_DIA_TEST_FACTORY_MODE_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

class dia_TestFactoryMode
    : public dia_TestService,
      public dia_IErrorLogListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_TestFactoryMode);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_TestFactoryMode);

public:

   dia_TestFactoryMode(tU16 itc);

   virtual ~dia_TestFactoryMode(void);

   //
   // overloaded methods from dia_IErrorLogListenerImpl
   //

   //! positive response on clearing the fault memory
   virtual void vOnClearResult();
   //! negative response on clearing the fault memory
   virtual void vOnClearError(tU32 u32Error);


   //
   // overloaded methods from dia_TestService
   //

   //! @brief   
   virtual void vProcessRequest ( const std::vector<void*>& vecArgs );

   virtual void vOnTimeout ( void );

protected:

   //! @brief     Set itc (see mITC) according to input result:
   //! @param[in] result
   virtual void setITC(bool result);

   //! ITC to be set/unset
   tU16 mITC;

};

#endif /*__INCLUDED_DIA_TEST_FACTORY_MODE_H_*/
