
#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEMSET_LOCK_DEVICE__
#include "dia_SystemSetPluginLockDevice.h"
#endif

#define FINGERPRINT_LEN 16
#define VIN_LEN 17

//-----------------------------------------------------------------------------

dia_SystemSetPluginLockDevice::dia_SystemSetPluginLockDevice ( tVoid )
   : dia_SystemSettingsPlugin("dia_SystemSetPluginLockDevice",DIA_EN_SYSSET_PLUGIN_ID_LOCK_DEVICE)
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginLockDevice::dia_SystemSetPluginLockDevice()");

   addSupportedSysSetType(DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION);
}

//-----------------------------------------------------------------------------

dia_SystemSetPluginLockDevice::~dia_SystemSetPluginLockDevice ( tVoid )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginLockDevice::execute ( dia_UID sysSetTypeUID )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginLockDevice::execute()");

   tDiaResult retCode = DIA_SUCCESS;

   // NCG3D-25368: Security fingerprint not changed to default value (16x 0x20) after setSystemToDeliveryState
   std::vector<tU8> fingerPrint;
   for (int j = 0; j < FINGERPRINT_LEN; j++)
   {
      fingerPrint.push_back(0x20);
   }

   retCode = dia_setProperty(DIA_PROP_AIVI_SECURITY_FINGERPRINT, fingerPrint);
   if (retCode == DIA_SUCCESS)
   {
      DIA_TR_INF("# dia_SystemSetPluginLockDevice::execute: Stored Default Fingerprint");
   }
   else
   {
      DIA_TR_ERR("!!! dia_SystemSetPluginLockDevice::execute: Storing of Fingerprint FAILED with %d", retCode);
   }

   // NCG3D-30351: VIN is not set to default value after Set System to Delivery state
   std::vector<tU8> VIN;
   for (int j = 0; j < VIN_LEN; j++)
   {
      VIN.push_back(0x30);
   }

   retCode = dia_setProperty(DIA_PROP_AIVI_VIN, VIN);
   if (retCode == DIA_SUCCESS)
   {
      DIA_TR_INF("# dia_SystemSetPluginLockDevice::execute: Stored Default VIN");
   }
   else
   {
      DIA_TR_ERR("!!! dia_SystemSetPluginLockDevice::execute: Storing of VIN FAILED with %d", retCode);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginLockDevice::finalize ( dia_UID /*sysSetTypeUID*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginLockDevice::finalize()");

   return DIA_SUCCESS;
}

