/*
 * dia_SystemSetPluginDefaultConfigVin.cpp
 *
 *  Created on: 20.03.2019
 *      Author: ama8kor
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_DEFAULT_CONFIG_VIN__
#include "project/framework/sysset/dia_SystemSetPluginDefaultConfigVin.h"
#endif

#ifndef __INCLUDED_DIA_VIN_STATE_MACHINE_HANDLER__
#include "project/framework/vin/dia_VINStateMachineHandler.h"
#endif 

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SystemSetPluginDefaultConfigVin (Class constructor)
*
* DESCRIPTION: Specifies the Plugin ID.
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SystemSetPluginDefaultConfigVin::dia_SystemSetPluginDefaultConfigVin ( void )
   : dia_SystemSettingsPlugin("dia_SystemSetPluginDefaultConfigVin")
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigVin::dia_SystemSetPluginDefaultConfigVin()");

   addSupportedSysSetType(DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION);
}

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SystemSetPluginDefaultConfigVin (Class destructor)
*
* DESCRIPTION: -
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SystemSetPluginDefaultConfigVin::~dia_SystemSetPluginDefaultConfigVin ( void )
{
	DIA_TR_INF("dia_SystemSetPluginDefaultConfigVin::~dia_SystemSetPluginDefaultConfigVin()");
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    prepare
*
* DESCRIPTION: prepare for the upcoming system setting
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success
*
******************************************************************************/
#if 0
tDiaResult
dia_SystemSetPluginDefaultConfigVin::prepare (  dia_UID /*sysSetTypeUID*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigVin::prepare()");
   return DIA_SUCCESS;
}
#endif
//------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    prepare
*
* DESCRIPTION:  perform the system set operation
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success - if file exists and deletion is successful
* 			   failure - if file deletion is not successful
*
******************************************************************************/
tDiaResult
dia_SystemSetPluginDefaultConfigVin::execute (  dia_UID sysSetTypeUID )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigVin::execute()");
   DIA_TR_INF("dia_SystemSetPluginDefaultConfigVin::execute() sysSetTypeUID = 0x%08x", sysSetTypeUID);

   tDiaResult retCode = DIA_FAILED;

    dia_VINStateMachineHandler* poVINsm = dia_VINStateMachineHandler::getInstance();
	if(poVINsm)
	{			   
		if(DIA_SUCCESS == poVINsm->setVINtoDefaultState())
		{
			DIA_TR_INF("dia_SystemSetPluginDefaultConfigVin::execute -> Done !!!");
			retCode = DIA_SUCCESS;
		}
		else
		{
			DIA_TR_ERR("dia_SystemSetPluginDefaultConfigVin::execute -> Failed  !!!");
		}
	}
	else
	{
		DIA_TR_ERR("dia_SystemSetPluginDefaultConfigVin::execute -> Failed !!!");
	}

	return retCode;

}
//------------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    finalize
*
* DESCRIPTION: finalize the system set operation
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success
*
******************************************************************************/
#if 0
tDiaResult
dia_SystemSetPluginDefaultConfigVin::finalize (  dia_UID /*sysSetTypeUID*/ )
{
	   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigVin::finalize()");
	   return DIA_SUCCESS;
}
#endif
//--------------------------------------------------------------------------------------
