/*
 * dia_SystemSetPluginDefaultConfigCustomer.cpp
 *
 *  Created on: 16.11.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_DEFAULT_CONFIGURATION__
#include "project/framework/config/dia_DefaultConfiguration.cpp"
#endif

#include "dia_SystemSetPluginDefaultConfigCustomer.h"

//-----------------------------------------------------------------------------

dia_SystemSetPluginDefaultConfigCustomer::dia_SystemSetPluginDefaultConfigCustomer ( void )
   : dia_SystemSettingsPlugin("dia_SystemSetPluginDefaultConfigCustomer",DIA_EN_SYSSET_PLUGIN_ID_DEFAULT_CONFIG_CUSTOMER)
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigCustomer::dia_SystemSetPluginDefaultConfigCustomer()");

   addSupportedSysSetType(DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION);
   addSupportedSysSetType(DIA_C_UID_SYSTEM_SETTING_TYPE_DIAGNOSTICS_INTERNAL);
}

//-----------------------------------------------------------------------------

dia_SystemSetPluginDefaultConfigCustomer::~dia_SystemSetPluginDefaultConfigCustomer ( void )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginDefaultConfigCustomer::execute (  dia_UID sysSetTypeUID )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginDefaultConfigCustomer::execute()");

   tDiaResult retCode = DIA_FAILED;

   dia_IKDS* pKDS = 0;

   if ( queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS )
   {

      (void) pKDS->setFlushMode(dia_IKDS::DIA_EN_KDS_FLUSH_DISABLE);

      tU32 u32ConfigSize = dia_DefaultConfiguration::getConfigToDeliveryRepSize();
      const dia_ConfigToDeliveryInfo *pDeliveryRep = dia_DefaultConfiguration::getConfigToDeliveryRep();

      for (tU32 i = 0; i < u32ConfigSize; i++ )
      {
         /* ANTITHEF_MAP_SELECTION is not protected here */
         retCode = resetConfigItemToDeliveryState(pDeliveryRep[i].mCurrentProp, pDeliveryRep[i].mDefaultProp);
         (void) pKDS->setFlushMode(dia_IKDS::DIA_EN_KDS_FLUSH_DISABLE);

         if (retCode == DIA_FAILED)
         {
            DIA_TR_ERR( "dia_SystemSetPluginDefaultConfigCustomer::execute: item %d (decimal) FAILED", i);
            (void) pKDS->setFlushMode(dia_IKDS::DIA_EN_KDS_FLUSH_ENABLE);
            break;
         }
      }

      if (retCode == DIA_SUCCESS)
      {
         DIA_TR_INF("RESTORE CONIGURATION DEFAULTS: FLUSHING KDS ...");
         (void) pKDS->setFlushMode(dia_IKDS::DIA_EN_KDS_FLUSH_ENABLE);
         retCode = pKDS->flushKDS();
         getInstanceOfConfigManager()->forceFlush();
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginDefaultConfigCustomer::resetConfigItemToDeliveryState ( tU32 propID, tU32 propDefaultID ) const
{
   std::vector<tU8> data;

   // read the default data
   //if ( DIA_SUCCESS != dia_getProperty(propDefaultID, &data[0], dia_getPropertySize(propDefaultID)))
   if ( DIA_SUCCESS != dia_getProperty(propDefaultID, data))
   {
      DIA_TR_ERR("resetConfigItemToDeliveryState: Reading Config Item Default 0x%08x Failed !!", propDefaultID);
      return DIA_FAILED;
   }

   // write the default data
   if ( DIA_SUCCESS != dia_setProperty(propID, data) )
   {
      DIA_TR_ERR("resetConfigItemToDeliveryState: Writing Config Item 0x%08x Failed !!", propID);
      return DIA_FAILED;
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
