/*!
 * \file       dia_SAFeatureWifiConnman.h
 *
 * \brief      header file for dia_ASFComponentWifiBL
 *
 * \details    ASF component for Wifi BL ConflictManagement
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponents
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_WIFI_CONNMAN__
#define __INCLUDED_DIA_SAFEATURE_WIFI_CONNMAN__

#ifndef NET_CONNMAN_MANAGERPROXY_H
#include <net/connman/ManagerProxy.h>
#endif

#ifndef NET_CONNMAN_MANAGERCLIENTBASE_H
#include "net/connman/ManagerClientBase.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__
#include <project/interfaces/dia_IWifiConnmanListener.h>
#endif


using namespace net::connman::Manager;



class dia_SAFeatureWifiConnman
  : public dia_SystemAdapterFeatureASF<ManagerProxy>,
	public ManagerClientBase,
	public dia_IWifiConnman
{
public:
	//! constructor
	dia_SAFeatureWifiConnman (dia_SystemAdapterServicePluginASF<ManagerProxy>& pSrvPlugin );

	//! destructor
	virtual ~dia_SAFeatureWifiConnman();

	//! start monitoring of properties
	virtual tDiaResult startMonitoring();
	//! stop monitoring of properties
	virtual tDiaResult stopMonitoring();

	//-------------------------------------------------------------------------
	//
	// Overloaded dia_IWifiConnman methods
	//
	//-------------------------------------------------------------------------
   virtual tDiaResult GetWifiStations ( void );

	//-------------------------------------------------------------------------
	//
	// Overloaded ManagerClientBase methods
	//
	//-------------------------------------------------------------------------

   virtual void onGetServicesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< net::connman::Manager::GetServicesError >& error);
   virtual void onGetServicesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesResponse >& response);

protected:
   //! deprecated default constructor
	dia_SAFeatureWifiConnman ();

   void onWifiStationsUpdate( const std::vector<dia_tWifiStation>& stationList );

   void* getDbusIterValue(DBusMessageIter* iter);
};

#endif /* __INCLUDED_DIA_SAFEATURE_WIFI_CONNMAN__ */
