/*
 * dia_SAFeatureTunerMasterControl.cpp
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SAFeatureTunerMasterControl.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"


#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#include "common/diaglib/diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureTunerMasterControl.cpp.trc.h"
#endif

#define DIA_TUNERMASTERCONTROL_POWER_INVALID  0xFF

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerMasterControl,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, vHandleRoutineControl )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureTunerMasterControl::dia_SAFeatureTunerMasterControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMasterControl::dia_SAFeatureTunerMasterControl");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTunerMasterControl::~dia_SAFeatureTunerMasterControl ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMasterControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(ROUTINEID_ANTENNA_FEED_SELE);
   results.push_back(ROUTINEID_ANTENNA_2_FEED_SELE);
   results.push_back(ROUTINEID_DAB_ANTENNA_MODE);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMasterControl::tunerAMFM_TunerPowerSupply_Set ( dia_eTunerMasterControlPowerSupply powerSupply )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMasterControl::tunerAMFM_TunerPowerSupply_Set()");
   tDiaResult retCode = DIA_FAILED;

   static tU8 modeMapping[DIA_EN_TUNERMASTERCONTROL_POWER_COUNT] = {
         DIA_TUNERMASTERCONTROL_POWER_INVALID,
         0x00, // DIA_EN_TUNERMASTERCONTROL_POWER_PASSIV
         0x02, // DIA_EN_TUNERMASTERCONTROL_POWER_PHANTOM
         0x01  // DIA_EN_TUNERMASTERCONTROL_POWER_EXTERNAL_PLUG
   };

   tDiaglibParamVector vecRequest;
   trParameter paramMode;

   paramMode.enType = static_cast<tenParameterType>(ROUTINEID_ANTENNA_FEED_SELE_START_PARAM1);
   paramMode.u8Value = modeMapping[powerSupply];

   vecRequest.push_back(paramMode);
   DIA_TR_INF( "dia_SAFeatureTunerMasterControl::tunerAMFM_TunerPowerSupply_Set - PowerSupplyMode: 0x%02x .", paramMode.u8Value );
   DIA_TR_INF( "dia_SAFeatureTunerMasterControl:: (0x00-DISABLEPWR) (0x01-ENABLEPWR) (0x02-ENABLEPWRPHANTOM)");

   if ( dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_ANTENNA_FEED_SELE, 0, vecRequest, mpSrvPlugin /*this*/) == TRUE )
   {
      DIA_TR_INF( "dia_SAFeatureTunerMasterControl::tunerAMFM_TunerPowerSupply_Set-bRoutineControlStart SUCCESSFUL.");
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR( "dia_SAFeatureTunerMasterControl::tunerAMFM_TunerPowerSupply_Set - bRoutineControlStart FAILED");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMasterControl::tunerAMFM_TunerAntenna2PowerSupply_Set ( dia_eTunerMasterControlPowerSupply powerSupply )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMasterControl::tunerAMFM_TunerAntenna2PowerSupply_Set()");
   tDiaResult retCode = DIA_FAILED;

   static tU8 modeMapping[DIA_EN_TUNERMASTERCONTROL_POWER_COUNT] = {
         DIA_TUNERMASTERCONTROL_POWER_INVALID,
         0x00, // DIA_EN_TUNERMASTERCONTROL_POWER_PASSIV
         0x02, // DIA_EN_TUNERMASTERCONTROL_POWER_PHANTOM
         0x01  // DIA_EN_TUNERMASTERCONTROL_POWER_EXTERNAL_PLUG
   };

   tDiaglibParamVector vecRequest;
   trParameter paramMode;

   paramMode.enType = static_cast<tenParameterType>(ROUTINEID_ANTENNA_2_FEED_SELE_START_PARAM1);
   paramMode.u8Value = modeMapping[powerSupply];

   vecRequest.push_back(paramMode);
   DIA_TR_INF( "dia_SAFeatureTunerMasterControl::tunerAMFM_TunerAntenna2PowerSupply_Set - PowerSupplyMode: 0x%02X.", paramMode.u8Value );
   DIA_TR_INF( "dia_SAFeatureTunerMasterControl:: (0x00-DISABLEPWR) (0x01-ENABLEPWR) (0x02-ENABLEPWRPHANTOM)");

   /*
    * On 2017-09-05 Priya Prabhuswamy (from Tuner team) wrote:
    * In fc_tunermaster tunerAMFMAntenna2PowerSupply set feature is implemented as
    * Diaglib Routine Control as similar to tunerAMFMAntennaPowerSupply and tunerDABAntennaPowerSupply set feature.
    * kaa1hi: So diagnosis component shall use bRoutineControlStart instead of bIOControlStart
   */
   if ( dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_ANTENNA_2_FEED_SELE, 0, vecRequest, mpSrvPlugin /*this*/) == TRUE )
   {
      DIA_TR_INF("dia_SAFeatureTunerMasterControl::tunerAMFM_TunerAntenna2PowerSupply_Set-bRoutineControlStart SUCCESSFUL.");
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureTunerMasterControl::tunerAMFM_TunerAntenna2PowerSupply_Set - bRoutineControlStart FAILED");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMasterControl::tunerDAB_TunerPowerSupply_Set ( dia_eTunerMasterControlEnableMode powerMode )
{
   dia_tclFnctTrace trc("tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set()");
   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   trParameter paramMode;

   paramMode.enType = static_cast<tenParameterType>(ROUTINEID_DAB_ANTENNA_MODE_START_PARAM1);
   if(powerMode == DIA_EN_TUNERMASTERCONTROL_MODE_DISABLED)
   {
      paramMode.u8Value = 0x00;
      DIA_TR_INF( "tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set - MODE_DISABLED" );
   }
   else if (powerMode == DIA_EN_TUNERMASTERCONTROL_MODE_ENABLED)
   {
      paramMode.u8Value = 0x01;
      DIA_TR_INF( "tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set - MODE_ENABLED" );
   }
   else
   {
      DIA_TR_ERR( "tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set - WRONG POWER MODE 0x%02x.", powerMode);
      return retCode;
   }

   vecRequest.push_back(paramMode);
   DIA_TR_INF( "tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set - Mode: 0x%02x", paramMode.u8Value );

   if ( dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_DAB_ANTENNA_MODE, 0, vecRequest, mpSrvPlugin /*this*/) == TRUE ) {
      DIA_TR_INF( "tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set-bRoutineControlStart SUCCESSFUL.");
      retCode = DIA_SUCCESS;
   } else {
      DIA_TR_ERR( "tunerDAB_TunerPowerSupply_Set::tunerDAB_TunerPowerSupply_Set - bRoutineControlStart FAILED");
   }

   return retCode;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerMasterControl::vHandleRoutineControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc( ("dia_SAFeatureTunerMasterControl::vHandleRoutineControl") );

   dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage( poMessage, this );
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerMasterControl::vOnRoutineCtrlResult (
                                                    tU32 u32RoutineId,
                                                    tenRoutineCtrlResult enRoutineStatus,
                                                    const tDiaglibParamVector& oStartResult
                                                 )
{
   dia_tclFnctTrace trc( ("dia_SAFeatureTunerMasterControl::vOnRoutineCtrlResult") );

   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32RoutineId);

   dia_ITunerMasterControlListener* pVideoListener = OSAL_NULL;
   querySysAdapterListener<dia_ITunerMasterControlListener>(&pVideoListener);

   if ( pVideoListener )
   {
      DIA_TR_INF ("dia_SAFeatureTunerMasterControl::vOnRoutineCtrlResult - Information forwarded to listener");

      dia_eTunerMasterControlPowerSupply ePwrSupply = DIA_EN_TUNERMASTERCONTROL_POWER_UNKNOWN;
      dia_eTunerMasterControlEnableMode  ePwrMode = DIA_EN_TUNERMASTERCONTROL_MODE_UNKNOWN;
      if ( EN_ROUTINE_CONTROL_OK == enRoutineStatus )
      {
         DIA_TR_INF("dia_SAFeatureTunerMasterControl::vOnRoutineCtrlResult - EN_ROUTINE_CONTROL_OK !");

         ePwrSupply = static_cast<dia_eTunerMasterControlPowerSupply>(oStartResult[0].u8Value+1);
         ePwrMode   = static_cast<dia_eTunerMasterControlEnableMode> (oStartResult[0].u8Value+1);
         pVideoListener->vOnTunerAMFMPowerSupply_Set(ePwrSupply);
         pVideoListener->vOnTunerDABPowerSupply_Set(ePwrMode);
      }
      else     //if ( EN_ROUTINE_CONTROL_OK == enRoutineStatus )
      {
         DIA_TR_ERR("dia_SAFeatureTunerMasterControl::vOnRoutineCtrlResult - EN_ROUTINE_CONTROL_NOK !!");
         pVideoListener->vOnTunerAMFMPowerSupply_Set(ePwrSupply);
         pVideoListener->vOnTunerDABPowerSupply_Set(ePwrMode);
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureTunerMasterControl::vOnRoutineCtrlResult - No listener registered");
   }
}
