/*
 * dia_SAFeatureTunerMaster.h
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURETUNERMASTER_H_
#define DIA_SAFEATURETUNERMASTER_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERMASTER_LISTENER__
#include "common/interfaces/dia_ITunerMasterListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTunerMaster
   : public dia_SystemAdapterFeature,
     public dia_ITunerMaster
{
public:
   //! constructor
   dia_SAFeatureTunerMaster ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTunerMaster ( void );

   //! OPCODE UPREG request
   virtual tDiaResult tunerMaster_attachNotification ( dia_eTunerMasterNotification id );
   //! OPCODE RELREG answer
   virtual tDiaResult tunerMaster_detachNotification ( dia_eTunerMasterNotification id );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ITunerAMFM methods
   //
   //-------------------------------------------------------------------------

   //! request the currently active tuner
   virtual tDiaResult tunerAMFM_ActiveTuner_Get ( );
   //! set a tuner to active
   virtual tDiaResult tunerAMFM_ActiveTuner_Set (dia_eTuner setTunerToActive);
   //! set the tuner band (AM/FM).
   virtual tDiaResult tunerAMFM_TunerBand_Set ( dia_eBand setBand );
   //! Read the tuner antenna status.
   virtual tDiaResult tunerAMFM_AntennaStatus_Get ( );
   //! Reads the phantom current of AM/FM1 antenna.
   virtual tDiaResult tunerAMFM_Antenna1Current_Get ( );
   //! Reads the phantom current of AM/FM1 antenna.
   virtual tDiaResult tunerAMFM_Antenna2Current_Get ( );
   //! Function from SH to SA to read the DAB tuner antenna status.
   virtual tDiaResult tunerDAB_AntennaStatus_Get ( );
   //! Function from SH to SA to reads the phantom current of DAB antenna.
   virtual tDiaResult tunerDAB_Antenna1Current_Get ( );
   //! Function from SH to SA to read the AM/FM tuner antenna2 status.
   virtual tDiaResult tunerAMFM_Antenna2Status_Get (  );
   ////! Function from SH to SA to read the traffic program condition status.
   //virtual tDiaResult tuner_TrafficProgramStatus_Get (  );

   virtual tDiaResult getGNSSAntennaCurrent( void );
   virtual tDiaResult getGNSSExtendedData ( void );

protected:
   //! deprecated default constructor
   dia_SAFeatureTunerMaster ( void );

   ////! small helper function to minimize source code
   //tDiaResult dia_sendOPCODE_GET(tU16 fktID);

   void vHandleTunerAMFMSelectActiveTuner_Get   ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerAMFMSelectActiveTuner_Set   ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerAMFMTunerBand_Set           ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerAMFM_OnAntennaStatusTest    ( amt_tclServiceData* poMessage ) const;
   void vHandleTunerAMFM_OnTrafficPgmStatus_Get ( amt_tclServiceData* poMessage ) const;
   void vHandleGNSSAntennaCurrent ( amt_tclServiceData* poMessage ) const;
   void vHandleGNSSExtendedData ( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTunerMaster)
};

#endif /* DIA_SAFEATURETUNERMASTER_H_ */
