/*
 * dia_SAFeatureTunerMaster.cpp
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SAFeatureTunerMaster.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"


//#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
//#include "diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
//#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
//#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureTunerMaster.cpp.trc.h"
#endif

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerMaster,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_ACTIVETUNER_INFO,vHandleTunerAMFMSelectActiveTuner_Get)
   ON_MESSAGE(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SRCCHG_TESTMODE,     vHandleTunerAMFMSelectActiveTuner_Set)
   ON_MESSAGE(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_BAND_CHANGE,         vHandleTunerAMFMTunerBand_Set)
   ON_MESSAGE(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST,     vHandleTunerAMFM_OnAntennaStatusTest )
   ON_MESSAGE(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS,           vHandleTunerAMFM_OnTrafficPgmStatus_Get )

END_MSG_MAP()

// Link enum and Function ID
static tU16 arTunMasterFIDMapping[DIA_EN_TUNERMASTER_NOTIFICATION_COUNT] = {
        0xFFFF,
        MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS  // DIA_EN_TUNERMASTER_NOTIFICATION_TRAFFIC_PROGRAM_STATUS
};

//------------------------------------------------------------------------------

dia_SAFeatureTunerMaster::dia_SAFeatureTunerMaster (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::dia_SAFeatureTunerMaster");
}

//-----------------------------------------------------------------------------

dia_SAFeatureTunerMaster::~dia_SAFeatureTunerMaster ( tVoid )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerMaster_attachNotification ( dia_eTunerMasterNotification id )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerMaster_attachNotification()");
   tDiaResult retCode = DIA_FAILED;

   tU16 fid = arTunMasterFIDMapping[id];
   if ( fid != 0xFFFF )
   {
      if ( mpSrvPlugin->bRegisterForFID(fid) ) retCode = DIA_SUCCESS;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerMaster_detachNotification ( dia_eTunerMasterNotification id )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerMaster_detachNotification()");
   tDiaResult retCode = DIA_FAILED;

   tU16 fid = arTunMasterFIDMapping[id];
   if ( fid != 0xFFFF )
   {
      if ( mpSrvPlugin->bUnregisterForFID(fid) ) retCode = DIA_SUCCESS;
   }

   return retCode;
}

////-----------------------------------------------------------------------------
//tDiaResult dia_SAFeatureTunerMaster::dia_sendOPCODE_GET(tU16 fktID)
//{
//   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::dia_sendOPCODE_GET");
//   tDiaResult retCode = DIA_FAILED;
//
//   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
//      gm_tclU32Message oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), fktID, CCA_C_U8_OPCODE_GET);
//
//      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE
//         )
//         retCode = DIA_SUCCESS;
//   }
//
//   return retCode;
//}
////-----------------------------------------------------------------------------
//
//tDiaResult dia_SAFeatureTunerMaster::tuner_TrafficProgramStatus_Get()
//{
//   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tuner_TrafficProgramStatus_Get");
//
//   tDiaResult retCode = dia_sendOPCODE_GET(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS);
//
//   return retCode;
//}



//----------------------------------------------------------------------------- 

tDiaResult
dia_SAFeatureTunerMaster::getGNSSAntennaCurrent ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::getGNSSAntennaCurrent()");
	tDiaResult retCode = DIA_FAILED;
	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
      DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSAntennaCurrent - send message.");
      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;

	  oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_GPS_ANTENNA;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSAntennaCurrent - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSAntennaCurrent - transmitMessage failed.");
      }
    } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSAntennaCurrent - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSAntennaCurrent - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//----------------------------------------------------------------------------- 

tDiaResult
dia_SAFeatureTunerMaster::getGNSSExtendedData ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::getGNSSExtendedData()");
	tDiaResult retCode = DIA_FAILED;
	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
      DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSExtendedData - send message.");
      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;

	  oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_GPS_ANTENNA;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSExtendedData - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSExtendedData - transmitMessage failed.");
      }
    } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSExtendedData - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::getGNSSExtendedData - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get ( )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get - send message.");

      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart oData; //lint !e1502 Warning: defined object nonstatic data members
//      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA1;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_ACTIVETUNER_INFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set (dia_eTuner setTunerToActive)
{
    dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set()");
    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart oData;
       switch (setTunerToActive) {
         case DIA_EN_TUNERMASTER_1:
            DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set e8_WhichTuner = TUN_MSTR_TUNER_0.");
            oData.WhichTuner.enType = midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_0;
            break;
         case DIA_EN_TUNERMASTER_2:
            DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set e8_WhichTuner = TUN_MSTR_TUNER_1.");
            oData.WhichTuner.enType = midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_1;
            break;
         case DIA_EN_TUNERMASTER_3:
            DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set e8_WhichTuner = TUN_MSTR_TUNER_2.");
            oData.WhichTuner.enType = midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_2;
            break;
         case DIA_EN_TUNERMASTER_4:
            DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set e8_WhichTuner = TUN_MSTR_TUNER_3.");
            oData.WhichTuner.enType = midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_3;
            break;
         default:
            DIA_TR_ERR("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set == NOT DEFINED!");
            return DIA_FAILED;
      }

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SRCCHG_TESTMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set - transmitMessage failed.");
      }
    } else {
       DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_ActiveTuner_Set - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set ( dia_eBand setBand )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set - send message.");

      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart oData;
      oData.Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB; // DAB as false value
      switch(setBand){
      case DIA_EN_TUNERMASTER_BAND_UNKNOWN:
         DIA_TR_ERR("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set == DIA_EN_TUNERMASTER_UNKNOWN.");
         break;
      case DIA_EN_TUNERMASTER_BAND_AM:
         oData.Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW; /* At the Nissan project AM == MW */
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set == FI_EN_TUN_MSTR_BAND_MW.");
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set == At the Nissan project AM == MW.");
         break;
      case DIA_EN_TUNERMASTER_BAND_FM:
         oData.Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set == FI_EN_TUN_MSTR_BAND_FM.");
         break;
      default:
         DIA_TR_ERR("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set == NOT DEFINED.");
         break;
      }

      if(oData.Band.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW || oData.Band.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM ){
         //put the data in message
         fi_tclVisitorMessage oMessage(oData);
         mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_BAND_CHANGE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

         if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
            retCode = DIA_SUCCESS;
         }
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_TunerBand_Set - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get ( ) {
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get - send message.");

      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;
      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA1;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

//      gm_tclEmptyMessage oMessage (
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST,
//         CCA_C_U8_OPCODE_UPREG
//      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_AntennaStatus_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get ( ) {
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get - send message.");

      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;
      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA2;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

//      gm_tclEmptyMessage oMessage (
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST,
//         CCA_C_U8_OPCODE_UPREG
//      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Status_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get ( ){
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get - send message.");
      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;
      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA1;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

//      gm_tclEmptyMessage oMessage (
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST,
//         CCA_C_U8_OPCODE_UPREG
//      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Current_Get ( ){
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Current_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna1Current_Get - send message.");
      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;
      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA2; 

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

//      gm_tclEmptyMessage oMessage (
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST,
//         CCA_C_U8_OPCODE_UPREG
//      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Current_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Current_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Current_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerAMFM_Antenna2Current_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get ( ) {
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get - send message.");

      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;
      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_DAB_ANTENNA1;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_AntennaStatus_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get ( ){
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get - send message.");
      midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oData;
      oData.Antenna_Test.enType = midw_fi_tcl_e8_AntennaTest::FI_EN_DAB_ANTENNA1;

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);


      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureTunerMaster::tunerDAB_Antenna1Current_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Get ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Get ..................................");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            if(oCompResp.TunerMaster_StatusResponse.u8TunermasterStatus.enType == midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED){
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Get - FI_EN_TUN_MSTR_RES_REQ_SUCCEED.");
               dia_eTuner activeTuner = DIA_EN_TUNERMASTER_UNKNOWN;
               switch(oCompResp.WhichTuner.enType){
                  case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_0:
                     activeTuner = DIA_EN_TUNERMASTER_1;
                     break;
                  case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_1:
                     activeTuner = DIA_EN_TUNERMASTER_2;
                     break;
                  case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_2:
                     activeTuner = DIA_EN_TUNERMASTER_3;
                     break;
                  case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_3:
                     activeTuner = DIA_EN_TUNERMASTER_4;
                     break;
                  default:
                     DIA_TR_ERR("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Get - WHICHTUNER (0x%02x) UNKNOWN.",oCompResp.WhichTuner.enType);
                     break;
               }
               pListener->vOnTunerAMFMActiveTuner_Get(activeTuner);
            } else {
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Get - FI_EN_TUN_MSTR_RES_REQ_FAIL !!!");
            }
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "---opcode error recievd with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Set ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Set");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);
            tU8 result = oCompResp.TunerMaster_StatusResponse.u8TunermasterStatus.enType;

            if( result == midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED ){
               pListener->vOnTunerAMFMActiveTuner_Set(DIA_SUCCESS);
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Set SUCCESSFUL.");
            } else {
               DIA_TR_ERR("dia_SAFeatureTunerMaster::vHandleTunerAMFMSelectActiveTuner_Set negative result.");
            }

         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "---opcode error recievd with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerMaster::vHandleTunerAMFMTunerBand_Set ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleTunerAMFMTunerBand_Set");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            tU8 result = oCompResp.TunerMaster_StatusResponse.u8TunermasterStatus.enType;

            if(result == midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED ){
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMTunerBand_Set SUCCESSFUL.");
               pListener->vOnTunerAMFMTunerBand_Set(DIA_SUCCESS);
            } else {
               DIA_TR_ERR("dia_SAFeatureTunerMaster::vHandleTunerAMFMTunerBand_Set FAILED.");
            }

         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "---opcode error recievd with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

/*
 * Handles the response for all MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST requests
 * It sends the results to all possible Service Handler and only the active ones will work on this message
 * Implemented for:
 * - tunerAMFM_AntennaStatus_Get
 * - tunerAMFM_Antenna1Current_Get
 * - tunerDAB_AntennaStatus_Get
 * - tunerDAB_Antenna1Current_Get
 */
tVoid
dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      /*****************************************************************************/
      /******** STATUS *************************************************************/
      /*****************************************************************************/
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMAntennaStatus_Get AMT_C_U8_CCAMSG_OPCODE_STATUS!");
         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if ( pListener )
         {
            DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMAntennaStatus_Get STATUS not checked!");
         }

      /*****************************************************************************/
      /* METHOD RESULT *************************************************************/
      /*****************************************************************************/
      } else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest AMT_C_U8_CCAMSG_OPCODE_METHODRESULT!");

         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);

            midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            if ( (oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA1) ||
                 (oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA2) ||
                 (oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_DAB_ANTENNA1)  ||
				 (oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_GPS_ANTENNA)	 ){
               midw_fi_tcl_e8_RFAntenna antennaStatus = oCompResp.Tunmstr_RF_Antenna.RFAntennaStatus;
               dia_eAntennaStatus antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN;

               // Answer for tunerAMFM_AntennaStatus_Get & tunerDAB_AntennaStatus_Get
               switch (antennaStatus.enType) {
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_OK:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_OK;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_OK.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_OPEN:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_SHORT:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_LOW_VG:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_BATTERY;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_BATTERY.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_HIGH_VG:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_GROUND;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_GROUND.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_OPEN_AMPLIFIER:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN_AMPLIFIER;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN_AMPLIFIER.");
                  break;
               case midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_NUMBER_OF_ITEM:
                  antStatus = DIA_EN_TUNERMASTER_ANTENNASTATUS_COUNT;
                  DIA_TR_INF("vHandleTunerAMFM_OnAntennaStatusTest DIA_EN_TUNERMASTER_ANTENNASTATUS_COUNT.");
                  break;
               default:
                  DIA_TR_ERR("vHandleTunerAMFM_OnAntennaStatusTest UNKNOWN ANTENNA STATUS.");
                  break;
               }


               //===================================================//
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest antStatus=0x%02x",        antStatus);
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest ConnectionCurrent=0x%02x",oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent);
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest AntennaTest=0x%02x"      ,oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType);
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnAntennaStatusTest RFAntennaStatus=0x%02x"  ,oCompResp.Tunmstr_RF_Antenna.RFAntennaStatus.enType);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA1)
			   pListener->vOnTunerAMFMAntennaStatus_Get(antStatus);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA2)
			   pListener->vOnTunerAMFMAntenna2Status_Get(antStatus);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_DAB_ANTENNA1)
			   pListener->vOnTunerDABAntennaStatus_Get (antStatus);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_GPS_ANTENNA) 	
			   pListener->vOnGNSSAntennaStatus(antStatus);

               // Answer for tunerAMFM_Antenna1Current_Get & tunerDAB_Antenna1Current_Get

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA1)
			   pListener->vOnTunerAMFMAntenna1Current_Get((tU16) oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_AMFM_ANTENNA2)
			   pListener->vOnTunerAMFMAntenna2Current_Get((tU16) oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_DAB_ANTENNA1)
               pListener->vOnTunerDABAntenna1Current_Get ((tU16) oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent);

			   //if ( oCompResp.Tunmstr_RF_Antenna.AntennaTest.enType == midw_fi_tcl_e8_AntennaTest::FI_EN_GPS_ANTENNA) 	
			   pListener->vOnGNSSAntennaCurrent ((tU16) oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent);


               //===================================================//
               pListener->vOnGetTunMstrRFAntennaTestInfo ( antStatus, (oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent) );
               pListener->vOnGetTunerAerialRadio1Status  ( antStatus, (oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent) );
               pListener->vOnGetTunerAerialRadio2Status  ( antStatus, (oCompResp.Tunmstr_RF_Antenna.ConnectionCurrent) );

               //===================================================//

               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMAntennaStatus_Get SUCCESS!");
            } else {
               // pListener->vOnTunerAMFMAntennaStatus_Get no answer, because we can't read antenna 1 => it will run into the timeout
               DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFMAntennaStatus_Get FAILED!");

            }
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF("dia_SAFeatureTunerMaster --- opcode error received with error code:%u",u16ErrorCode);
      }
      (tVoid) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------
/*
 * Handles the response for all MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS requests
 * It sends the results to all possible Service Handler and only the active ones will work on this message
 * Implemented for:
 * - tuner_TrafficProgramStatus_Get
 */
tVoid dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnTrafficPgmStatus_Get(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnTrafficPgmStatus_Get");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnTrafficPgmStatus_Get %d TP_STATE:",oCompResp.TP_STATE);
            DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnTrafficPgmStatus_Get %d TP_Source:",oCompResp.TP_Source.enType);
            DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnTrafficPgmStatus_Get =================");

            midw_fi_tcl_e8_Source tPSource = oCompResp.TP_Source;
            dia_eTunerMasterSource tunMstrSource = DIA_EN_TUN_MSTR_SOURCE_UNKNOWN;

            // Answer for tunerAMFM_AntennaStatus_Get & tunerDAB_AntennaStatus_Get
            switch (tPSource.enType)
            {
               case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1:
                  tunMstrSource = DIA_EN_TUN_MSTR_SOURCE_FM1;
                  break;
               case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM:
                  tunMstrSource = DIA_EN_TUN_MSTR_SOURCE_AM;
                  break;
               case midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB:
                  tunMstrSource = DIA_EN_TUN_MSTR_SOURCE_DAB;
                  break;
               default:
                  DIA_TR_ERR("vHandleTunerAMFM_OnTrafficPgmStatus_Get UNKNOWN TP SOURCE.");
                  break;
            }

            pListener->vOnGetTrafficprogramStatus((oCompResp.TP_STATE), tunMstrSource);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureTunerMaster::vHandleTunerAMFM_OnTrafficPgmStatus_Get --- opcode error received: %d",u16ErrorCode);
      }
      (tVoid) poMessage->bDelete();
   }
}


//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerMaster::vHandleGNSSAntennaCurrent ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleGNSSAntennaCurrent");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
			#if 0
			fi_tclVisitorMessage oStatusMessage(poMessage);
            cmb_sensorfi_tclMsgAntennaCurrentStatus oStatusMsgData;
            (tVoid) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleGNSSAntennaCurrent - Received GNSS Antenna current");

            dia_ITunerMasterListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
            if ( pListener )
            {
                pListener->vOnGNSSAntennaCurrent(oStatusMsgData.AntennaCurrent);
                DIA_TR_INF("Current(A) = %f",oStatusMsgData.AntennaCurrent);
                DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleGNSSAntennaCurrent - current forwarded to listener");
            }
			#endif
        }
        break;

    default:
        {
           DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleGNSSAntennaCurrent - OpCode not ok");
        }
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();

}

//----------------------------------------------------------------------------- 

tVoid
dia_SAFeatureTunerMaster::vHandleGNSSExtendedData ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerMaster::vHandleGNSSExtendedData");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {
		 #if 0
		 fi_tclVisitorMessage oStatusMessage(poMessage);
         cmb_sensorfi_tclMsgGpsExtDataStatus oStatusMsgData;
         (tVoid) oStatusMessage.s32GetData(oStatusMsgData);

         // GNSS receiver status
         dia_tGNSSReceiverState info;
         info.m_u8FixStatus          = oStatusMsgData.GpsData.GpsExtBigConstData.FixStatus.u8Value;
         info.m_u8SatellitesHealthy  = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesHealthy;
         info.m_u8SatellitesReceived = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesReceived;
         info.m_u8SatellitesVisible  = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesVisible;
         info.m_u8SatellitesUsed     = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesUsed;

         std::vector<cmb_fi_tcl_GpsBigVarData> oDataVector;
         oDataVector.assign(oStatusMsgData.GpsData.GpsBigVarData.begin(), oStatusMsgData.GpsData.GpsBigVarData.end());
         std::sort(oDataVector.begin(), oDataVector.end(), dia_gps_compare_snr); //lint !e864 Info: Expression possibly depends on order of evaluation

         std::vector<dia_tGNSSBestSattelletes> oBestSattelletes;
         std::vector<cmb_fi_tcl_GpsBigVarData>::const_iterator it = oDataVector.begin();
         for ( ; it != oDataVector.end(); ++it )
         {
            dia_tGNSSBestSattelletes temp;
            temp.m_u8SatellitesNumber = it->SatId;
            temp.m_u8SignalQuality = (tU8)it->CarrierToNoiseRatio;
            oBestSattelletes.push_back(temp);
         }
         oDataVector.clear();

         // GNSS antenna status
         DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleGNSSExtendedData - Received GNSS extended data");

         dia_ITunerMasterListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ITunerMasterListener>(&pListener);
         if ( pListener )
         {
            pListener->vOnGNSSAntennaStatus(oStatusMsgData.GpsData.GpsExtBigConstData.AntennaStatus.enType);
            //pListener->vOnGNSSReceiverStatus(info);
            //pListener->vOnGNSSBestSattelites(oBestSattelletes);

            DIA_TR_INF("Antenna State = %d",oStatusMsgData.GpsData.GpsExtBigConstData.AntennaStatus.enType);
            DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleGNSSExtendedData - antenna state forwarded to listener");
         }
		 #endif
      }
      break;

   default:
      {
         DIA_TR_INF("dia_SAFeatureTunerMaster::vHandleGNSSExtendedData - OpCode not ok");
      }
      break;
   }

   // Delete the message we are unable process it at this time
   (tVoid) poMessage->bDelete();
}
