/*
 * dia_SAFeatureTunerDABControl.cpp
 *
 *  Created on: 10.07.2013
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "dia_SAFeatureTunerDABControl.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"


/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureTunerDABControl,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureTunerDABControl::dia_SAFeatureTunerDABControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDABControl::dia_SAFeatureTunerDABControl");
}


//-----------------------------------------------------------------------------

dia_SAFeatureTunerDABControl::~dia_SAFeatureTunerDABControl ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDABControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_DAB_TUNER_FREQUENCY_SET);
   results.push_back(IOCONTROLID_DAB_TUNER_SERVICEID_SET);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDABControl::tunerDAB_EnsembleFrequency_Set ( tU32 frequency )
{
   dia_tclFnctTrace trc("dia_SAFeatureTunerDABControl::tunerDAB_EnsembleFrequency_Set()");
   DIA_TR_INF("tunerDAB_EnsembleFrequency_Set frequency[Hz] = 0x%08x (decimal %d).", frequency, frequency);

   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   trParameter paramFreq;

   paramFreq.enType  = static_cast<tenParameterType>(IOCONTROLID_DAB_TUNER_FREQUENCY_SET_SET_PARAM1);
   paramFreq.u32Value = (frequency/1000);  //conversion Hz to kHz.

   DIA_TR_INF("tunerDAB_EnsembleFrequency_Set frequency[kHz] = 0x%08x (decimal %d).", paramFreq.u32Value, paramFreq.u32Value);

   vecRequest.push_back(paramFreq);

   if ( dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_DAB_TUNER_FREQUENCY_SET, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE ) {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureTunerDABControl::tunerDAB_EnsembleFrequency_Set - bIOControlStart - SUCCESS.");
   } else {
      DIA_TR_INF("dia_SAFeatureTunerDABControl::tunerDAB_EnsembleFrequency_Set - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureTunerDABControl::tunerDAB_ServiceID_Set  ( tU32 serviceID )
{
    dia_tclFnctTrace trc("dia_SAFeatureTunerDABControl::tunerDAB_ServiceID_Set()");
    tDiaResult retCode = DIA_FAILED;

    tDiaglibParamVector vecRequest;
    trParameter paramSID;

    paramSID.enType = static_cast<tenParameterType>(IOCONTROLID_DAB_TUNER_SERVICEID_SET_SET_PARAM1);
    paramSID.u32Value = serviceID;

    DIA_TR_INF("dia_SAFeatureTunerDABControl::tunerDAB_EnsembleFrequency_Set - new serviceID= 0x%04x (decimal %d).", paramSID.u32Value, paramSID.u32Value);

    vecRequest.push_back(paramSID);

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_DAB_TUNER_SERVICEID_SET, EN_ACTION_SET, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureTunerDABControl::tunerDAB_ServiceID_Set - bIOControlStart - SUCCESS.");
    } else {
       DIA_TR_INF("dia_SAFeatureTunerDABControl::tunerDAB_ServiceID_Set - bIOControlStart - FAILED.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerDABControl::vHandleIOControl ( amt_tclServiceData* poMessage ){
   dia_tclFnctTrace trc("dia_SAFeatureTunerDABControl::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureTunerDABControl::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction /*enActionId*/, const tDiaglibParamVector& /*oStartResult*/){
   dia_tclFnctTrace trc("dia_SAFeatureTunerDABControl::vOnIoCtrlResult()");
   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32IoCtrlId);

   dia_ITunerDABControlListener* pTunerDABListener = OSAL_NULL;
   querySysAdapterListener<dia_ITunerDABControlListener>(&pTunerDABListener);

   if (pTunerDABListener) {
      switch (u32IoCtrlId) {
         case IOCONTROLID_DAB_TUNER_FREQUENCY_SET:
            DIA_TR_INF("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_DAB_TUNER_FREQUENCY_SET.");
            if (enResult == EN_IO_CONTROL_OK) {
               DIA_TR_INF("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
               pTunerDABListener->vOnTunerDABEnsembleFrequency_Set(DIA_SUCCESS);
            } else {
               DIA_TR_ERR("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
               pTunerDABListener->vOnTunerDABEnsembleFrequency_Set(DIA_FAILED);
            }
            break;
         case IOCONTROLID_DAB_TUNER_SERVICEID_SET:
            DIA_TR_INF("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_DAB_TUNER_SERVICEID_SET.");
            if (enResult == EN_IO_CONTROL_OK) {
               DIA_TR_INF("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
               pTunerDABListener->vOnTunerDABServiceID_Set(DIA_SUCCESS);
            } else {
               DIA_TR_ERR("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
               pTunerDABListener->vOnTunerDABServiceID_Set(DIA_FAILED);
            }
            break;
         default:
            DIA_TR_ERR("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - u32IoCtrlId = u32IoCtrlId UNKNOWN.");
            break;
      }

   } else {
      DIA_TR_ERR("dia_SAFeatureTunerDABControl::vOnIoCtrlResult - No listener registered");
   }
}
