/*
 * dia_SAFeatureTunerAMFM.h
 * 
 *  Created on: 11.10.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURETUNERAMFM_H_
#define DIA_SAFEATURETUNERAMFM_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#include "common/interfaces/dia_ITunerAMFMListener.h"
#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ_LISTENER__
#include "project/interfaces/dia_ITunerAMFMPrjListener.h"
#endif
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTunerAMFM
   : public dia_SystemAdapterFeature,
     public dia_ITunerAMFM,
     public dia_ITunerAMFMPrj
{
public:
   //! constructor
   dia_SAFeatureTunerAMFM ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTunerAMFM ( void );

   //! OPCODE UPREG request
   virtual tDiaResult tunerAMFM_attachNotification ( dia_eTunerAMFMNotification id );
   //! OPCODE RELREG answer
   virtual tDiaResult tunerAMFM_detachNotification ( dia_eTunerAMFMNotification id );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ITunerAMFM methods
   //
   //-------------------------------------------------------------------------

   //! reads the current tuner frequency
   virtual tDiaResult tunerAMFM_Frequency_Get ( );

   //! set the new tuner frequency
   virtual tDiaResult tunerAMFM_Frequency_Set ( tU32 newFrequency );

   //! read the tuner band (AM/FM).
   virtual tDiaResult tunerAMFM_TunerBand_Get ( );

   //! Function from SH to SA to read the RDS ProgramInformation of the current tuner station on tuner FM1.
   virtual tDiaResult tunerAMFM_TunerFMRDSProgramInformation_Get ( );

   //! reads the current tuner fieldstrength
   virtual tDiaResult tunerAMFM_TunerFieldStrength_Get ( );

   //! seek stations towards higher or lower frequency
   virtual tDiaResult tunerAMFM_Frequency_Seek ( dia_eTunerAMFMModulation /*modulation*/, dia_eTunerAMFMSeekDirection /*direction*/, dia_eTunerAMFMAction /*action*/){ return DIA_E_NOT_IMPLEMENTED; }

   //! Function from SH to SA to set the EnsembleFrequency of DRM tuner.
   virtual tDiaResult tunerDRM_EnsembleFrequency_Set ( tU32 frequency );
   //! Function from SH to SA to set the Service ID of DRM tuner.
   virtual tDiaResult tunerDRM_ServiceID_Set ( tU32 serviceID );
   //! reads the current tuner band and fieldstrength for AM/FM/WB
   virtual tDiaResult tunerAMFMWB_TunerBandFieldStrength_Get (  );

protected:

   //! true if UpReg for ATSEEK has been activated
   bool mbUpRegATSEEKActive;

   //! type of last sent message for seeking FM (stop or start)
   dia_eTunerAMFMAction mLastActionFreqSeekFM;

   //! start notification for frequency seek
   tDiaResult tunerAMFM_FreqSeekStartNotification() const { return DIA_E_NOT_IMPLEMENTED; }

   //! stop notification for frequency seek
   tDiaResult tunerAMFM_FreqSeekStopNotification();

   //! deprecated default constructor
   dia_SAFeatureTunerAMFM ( void );

   void vHandleTunerAMFM_ATSEEKWITHTUNERHEADER_Results ( amt_tclServiceData* poMessage ) const;

   void vHandleTunerAMFM_ATSTATIONINFO_Results    ( amt_tclServiceData* poMessage ) const;

   void vHandleTunerAMFM_ATSEEK_Results    ( amt_tclServiceData* poMessage );

   void vHandleTunerAMFMFrequency_Set    ( amt_tclServiceData* poMessage ) const;

   void vHandleTunerAMFMFieldStrength_Get    ( amt_tclServiceData* poMessage ) const;

   tVoid vHandleTunerDRM_Staus    ( amt_tclServiceData* poMessage ) const;
   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTunerAMFM)
};

#endif /* DIA_SAFEATURETUNERAMFM_H_ */
