/*
 * dia_SAFeatureTouchCntrlReset.h
 *
 *  Created on: 22.01.2013
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_SAFEATURE_TOUCHCNTRL_RESET__H_
#define __INCLUDED_DIA_SAFEATURE_TOUCHCNTRL_RESET__H_

#ifndef __INCLUDED_DIA_INTERFACE_RESET_TOUCHCNTL_EXT_DISPLAY_LISTENER__
#include "project/interfaces/dia_IResetTouchCntlExtDisplayListener.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "common/framework/sysadapters/dia_SystemAdapterFeatureDiaglib.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTouchCntrlReset
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IResetTouchCntlExtDisplay,
     public dia_IDiaglibIoControlListener
{
public:
   //! constructor
   dia_SAFeatureTouchCntrlReset ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureTouchCntrlReset ( tVoid );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual tVoid vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult);

   
   //! set the reset control line value
   virtual tDiaResult setResetTouchCntlExtDisplay ( tU8 extDisplay, dia_eResetTouchCntlExtDisplay mode );

protected:
   //! deprecated default constructor
   dia_SAFeatureTouchCntrlReset ( tVoid );

   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureTouchCntrlReset)
};

#endif /* __INCLUDED_DIA_SAFEATURE_TOUCHCNTRL_RESET__H_ */
