/**
 * \file      dia_SAFeatureTestPatternAIVI.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    abe6kor
 * \date      June 12, 2017
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef dia_SAFeatureTestPatternAIVI_H_
#define dia_SAFeatureTestPatternAIVI_H_


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI__
#include "project/interfaces/dia_IDisplayPatternAIVI.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY__
#include "project/interfaces/dia_ISubsystemDiagnosisProxy.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY_LISTENER__
#include <project/interfaces/dia_ISubsystemDiagnosisProxyListener.h>
#endif

#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#define DIAGNOSTICS_S_IMPORT_INTERFACE_MSG
#include "fc_diagnosis_if.h"

#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"

#define FI_EN_DOTDET01		(tU8)32 	//decimal values of corresponding Hex values
#define FI_EN_DOTDET02		(tU8)33
#define FI_EN_DOTDET03		(tU8)34
#define FI_EN_DOTDET04		(tU8)35
#define FI_EN_DOTDET05		(tU8)36
#define FI_EN_DOTDET06		(tU8)37
#define FI_EN_DOTDET07		(tU8)38
#define FI_EN_DOTDET08		(tU8)39
#define FI_EN_DOTDET09		(tU8)40
#define FI_EN_DOTDET10		(tU8)41
#define FI_EN_DOTDET11		(tU8)42
#define FI_EN_DOTDET12		(tU8)43
#define FI_EN_DOTDET13		(tU8)44
#define FI_EN_DOTDET14		(tU8)45
#define FI_EN_DOTDET15		(tU8)46
#define FI_EN_DOTDET16		(tU8)47
#define FI_EN_DOTDET17		(tU8)48
#define FI_EN_DOTDET18		(tU8)49
#define FI_EN_DOTDET19		(tU8)50
#define FI_EN_DOTDET20		(tU8)51
#define FI_EN_DOTDET21		(tU8)52
#define FI_EN_DOTDET22		(tU8)53
#define FI_EN_DOTDET23		(tU8)54
#define FI_EN_DOTDET24		(tU8)55
#define FI_EN_DOTDET25		(tU8)56
#define FI_EN_DOTDET26		(tU8)57
#define FI_EN_DOTDET27		(tU8)58
#define FI_EN_DOTDET28		(tU8)59
#define FI_EN_FLIP_UDHV 	(tU8)64
#define FI_EN_POINT1        (tU8)93
#define FI_EN_POINT2        (tU8)94
#define FI_EN_POINT3        (tU8)95
#define FI_EN_POINT4        (tU8)96
#define FI_EN_POINT5        (tU8)97
#define FI_EN_10_STEP_GRAY_SCALE_SIGNAL        (tU8)112
#define FI_EN_75_SMPTE_COLOR_BAR_SIGNAL        (tU8)113
#define FI_EN_GAMMA0		(tU8)114
#define FI_EN_GAMMA16		(tU8)115
#define FI_EN_GAMMA32		(tU8)116
#define FI_EN_GAMMA48		(tU8)117
#define FI_EN_GAMMA64		(tU8)118
#define FI_EN_GAMMA80		(tU8)119
#define FI_EN_GAMMA96		(tU8)120
#define FI_EN_GAMMA112		(tU8)121
#define FI_EN_GAMMA128		(tU8)122
#define FI_EN_GAMMA144		(tU8)123
#define FI_EN_GAMMA160		(tU8)124
#define FI_EN_GAMMA176		(tU8)125
#define FI_EN_GAMMA192		(tU8)126
#define FI_EN_GAMMA208		(tU8)127
#define FI_EN_GAMMA224		(tU8)128
#define FI_EN_GAMMA240		(tU8)129
#define FI_EN_GAMMA255		(tU8)130

struct tNotification
{
   tU16  u16AppID;
   tU16  u16CmdCounter;
   tU16   u16RegisterID;
   tU16  u16FunctionID;
   tU16  u16SubID;
};

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTestPatternAIVI
   : public dia_SystemAdapterFeature,
     public dia_IDisplayPatternAIVI,
	 public dia_ISubsystemDiagnosisProxyListenerImpl

{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureTestPatternAIVI);
public:
	//! default class constructor
	dia_SAFeatureTestPatternAIVI( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
	//! destructor
	virtual ~dia_SAFeatureTestPatternAIVI ( void );

	//! Set Test Pattern
	virtual tDiaResult setDisplayPatternID (dia_eDisplayPatternAIVIID ePatternID );
	virtual void setHMIBlockStatus ( void );
	virtual void setHashComparisonStatus ( tBool hashCompStatus );
	virtual void setCISswUpdateProcessStatus ( tBool bResult );
	virtual void setCISswUpdateStage2ProcessStatus ( tBool bStage2Result );

	virtual void onStartAvdeccFilesDelete ( tDiaResult /*result*/ ) override;

protected:
	//! handle the result of a message
	void vConfigUpdateViaUSB(amt_tclServiceData* poMessage);
	void vSetDisplay       ( amt_tclServiceData* poMessage );
	void vSetHMISWupdateResult( amt_tclServiceData* poMessage );
	void vSetHMISWupdateStage2Result( amt_tclServiceData* poMessage );
	void vResetToSupplierDefautConfig(amt_tclServiceData* poMessage);
	void vRuntimeSourceAppDataHandler(amt_tclServiceData* poMessage);
	bool  bUpreg(amt_tclServiceData const* poMessage);
	bool  bRelUpreg(amt_tclServiceData const* poMessage);
	bool bSendvResetToSupplierDefautConfigResult(tBool bResult);
	bool ResetToSupplierDefautConfig ( void );
	bool resetSupplierConfigItemToDeliveryState ( tU32 propID, tU32 propDefaultID ) const;

	DECLARE_MSG_MAP(dia_SAFeatureTestPatternAIVI)

private:
	diagnostics_tclApp* m_poGWMain;
	// dia_tclService* potclService;
	tVoid vNotifyAllClients(fi_tclTypeBase const&, tU16);

	tVoid vSendStatusMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
	tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8) const;
	// declare message map data structures
	dia_eConfigUpdateStatus m_eUpdateStatus;
	tBool m_eConfigUpregReceived;
	tNotification m_oDefSetMessage;
	void setConfigUpdateStatus(dia_eConfigUpdateStatus updateStatus){ m_eUpdateStatus = updateStatus;}
	dia_eConfigUpdateStatus getConfigUpdateStatus ( void ) { return m_eUpdateStatus; }
	void setUpregReceiveStatus(tBool upregStatus){ m_eConfigUpregReceived = upregStatus;}
	tBool getUpregReceiveStatus ( void ) { return m_eConfigUpregReceived; }


};

#endif /* dia_SAFeatureTestPatternAIVI_H_ */
