 /*
 * dia_SAFeatureTestPatternAIVI.cpp
 *
 *  Created on: 12.06.2017
 *      Author: abe6kor
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef dia_SAFeatureTestPatternAIVI_H_
#include "project/framework/sysadapters/dia_SAFeatureTestPatternAIVI.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_DEFAULT_CONFIGURATION__
#include "project/framework/config/dia_DefaultConfiguration.cpp"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

BEGIN_MSG_MAP( dia_SAFeatureTestPatternAIVI, dia_SystemAdapterFeature )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY,vSetDisplay )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB,vConfigUpdateViaUSB )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_SETRESETTOSUPPLIERDEFAULTCONFIG, vResetToSupplierDefautConfig )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_SETRUNTIMESOURCEDATA,vRuntimeSourceAppDataHandler)
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_CISSWUPDATEPROCESS,vSetHMISWupdateResult)
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_CISSWUPDATESTAGE2PROCESS,vSetHMISWupdateStage2Result)
END_MSG_MAP()


#define  RUNTIME_U16_APP_SXM   			(tU16)0x008C
#define  RUNTIME_U16_APP_FM    			(tU16)0x0000
#define  RUNTIME_U16_APP_AM    			(tU16)0x0001
#define  RUNTIME_U16_APP_DAB   			(tU16)0x0002
#define  RUNTIME_U16_APP_WX    			(tU16)0x0009
#define  RUNTIME_U16_APP_NAVI_RG      	(tU16)0x000A
#define  RUNTIME_U16_APP_NAVI_MAPOUT  	(tU16)0x000B
#define  RUNTIME_U16_APP_SPEECH_CONT_COUNTER  	(tU16)0x000C

#define DIA_M_MAKE_RUNSOURCE_VALUE_U32(A, B, C, D) (tU32)(((A<<24) | (B<<16)| (C<<8) | D))

dia_SAFeatureTestPatternAIVI::dia_SAFeatureTestPatternAIVI (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin),
	  m_eUpdateStatus(DIA_EN_CONFIG_UPDATE_STATUS_UNKNWON),
	  m_eConfigUpregReceived(FALSE)

{
   dia_tclFnctTrace trc("dia_SAFeatureTestPatternAIVI::dia_SAFeatureTestPatternAIVI");
   m_poGWMain = diagnostics_tclApp::getInstance();
   m_oDefSetMessage.u16AppID = 0;
   m_oDefSetMessage.u16CmdCounter = 0;
   m_oDefSetMessage.u16RegisterID = 0;
   m_oDefSetMessage.u16FunctionID = 0;
   m_oDefSetMessage.u16SubID = 0;
}

dia_SAFeatureTestPatternAIVI::~dia_SAFeatureTestPatternAIVI()
{}

tDiaResult
dia_SAFeatureTestPatternAIVI::setDisplayPatternID ( dia_eDisplayPatternAIVIID ePatternID )
{
	dia_tclFnctTrace trc("dia_SAFeatureTestPatternAIVI::setDisplayPatternID");

	static midw_fi_tcl_e8_TestScreens::tenType displayTestPatternMapping[DIA_EN_DISPLAY_PATTERN_AIVI_COUNT] = {
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_UNKNOWN
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_NONE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINWHITE,          // DIA_EN_DISPLAY_PATTERN_WHITE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINBLACK,          // DIA_EN_DISPLAY_PATTERN_BLACK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINRED,            // DIA_EN_DISPLAY_PATTERN_RED
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINGREEN,          // DIA_EN_DISPLAY_PATTERN_GREEN
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINBLUE,           // DIA_EN_DISPLAY_PATTERN_BLUE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_COLOURED,            // DIA_EN_DISPLAY_PATTERN_COLOURED
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_COLOURGRADIATION,    // DIA_EN_DISPLAY_PATTERN_COLOURED_GRADIATION
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_DIAGNOSISMASK,       // DIA_EN_DISPLAY_PATTERN_DIAGNOSIS_MASK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_LATTICE,             // DIA_EN_DISPLAY_PATTERN_LATTICE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_LEFTWHITERIGHTBLACK, // DIA_EN_DISPLAY_PATTERN_WHITE_BLACK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_LEFTBLACKRIGHTWHITE, // DIA_EN_DISPLAY_PATTERN_BLACK_WHITE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PIXELWISECHESSBOARD, // DIA_EN_DISPLAY_PATTERN_CHESSBOARD
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_CHESSBOARD_INVERT
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_STRIPS
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_GRAY64
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_SCREEN_7,            // DIA_EN_DISPLAY_PATTERN_FLICKER_TEST,
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_SCREEN_8,            // DIA_EN_DISPLAY_PATTERN_TEST_MARK,
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_TEFSPECIAL1,         // DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL1
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_TEFSPECIAL2,         // DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL2
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_RGB_NOK,             //DIA_EN_DISPLAY_PATTERN_RGB_NOK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_RGB_OK,              //DIA_EN_DISPLAY_PATTERN_RGB_OK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_RGB_REPDARK,         //DIA_EN_DISPLAY_PATTERN_RGB_REPDARK
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET01,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_01		(Not mapped to midw_fi, instead defined above in same file)
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET02,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_02
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET03,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_03
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET04,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_04
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET05,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_05
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET06,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_06
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET07,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_07
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET08,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_08
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET09,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_09
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET10,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_10
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET11,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_11
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET12,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_12
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET13,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_13
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET14,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_14
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET15,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_15
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET16,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_16
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET17,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_17
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET18,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_18
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET19,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_19
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET20,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_20
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET21,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_21
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET22,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_22
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET23,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_23
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET24,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_24
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET25,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_25
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET26,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_26
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET27,		    								//DIA_EN_DISPLAY_PATTERN_DOT_DET_27
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_DOTDET28,	       							   		//DIA_EN_DISPLAY_PATTERN_DOT_DET_28
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_FLIP_UDHV,	    								//DIA_EN_DISPLAY_PATTERN_FLIP_UDHV
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_POINT1,                                 			//DIA_EN_DISPLAY_PATTERN_POINT_1
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_POINT2,                                 			//DIA_EN_DISPLAY_PATTERN_POINT_2
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_POINT3,                                 			//DIA_EN_DISPLAY_PATTERN_POINT_3
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_POINT4,                                 			//DIA_EN_DISPLAY_PATTERN_POINT_4
	      (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_POINT5,                                  			//DIA_EN_DISPLAY_PATTERN_POINT_5
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_10_STEP_GRAY_SCALE_SIGNAL,                        //DIA_EN_DISPLAY_PATTERN_10_STEP_GRAY_SCALE_SIGNAL
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_75_SMPTE_COLOR_BAR_SIGNAL,                        //DIA_EN_DISPLAY_PATTERN_75_SMPTE_COLOR_BAR_SIGNAL
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA0,                                  			//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA0
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA16,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA16
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA32,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA32
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA48,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA48
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA64,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA64
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA80,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA80
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA96,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA96
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA112,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA112
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA128,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA128
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA144,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA144
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA160,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA160
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA176,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA176
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA192,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA192
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA208,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA208
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA224,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA224
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA240,                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA240
		  (midw_fi_tcl_e8_TestScreens::tenType) FI_EN_GAMMA255                                  		//DIA_EN_DISPLAY_PATTERN_FI_EN_GAMMA255
	   };

	   tDiaResult retVal = DIA_FAILED;
	   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
	   {
	   if (ePatternID < DIA_EN_DISPLAY_PATTERN_AIVI_COUNT)
	   {
	      midw_diagnosticsfi_tclMsgSetDisplayStatus oStatusData;
	      oStatusData.DisplayData.TestScreen.enType = displayTestPatternMapping[ePatternID];

	      midw_fi_tclString oFiString;
	      oStatusData.DisplayData.DisplayStrings.StringList.resize(6);

	      if (midw_fi_tcl_e8_TestScreens::FI_EN_DIAGNOSISMASK == displayTestPatternMapping[ePatternID]) {
	         tCString szLine1 = "Best ";
	         tCString szLine2 = "Wishes ";
	         tCString szLine3 = "From ";
	         tCString szLine4 = "Dynamic ";
	         tCString szLine5 = "Diagnostics ";
	         tCString szLine6 = "Team";
	         oStatusData.DisplayData.DisplayStrings.StringList[0].bSet(szLine1, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[1].bSet(szLine2, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[2].bSet(szLine3, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[3].bSet(szLine4, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[4].bSet(szLine5, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[5].bSet(szLine6, midw_fi_tclString::FI_EN_UTF8);
	      }

	      vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY);
	      retVal = DIA_SUCCESS;

	   }
	   }
	   else {
	          DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID failed.");
	          DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	       }

	   return retVal;
}
void dia_SAFeatureTestPatternAIVI::setHashComparisonStatus(tBool hashCompStatus)
{
	dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::setHashComparisonStatus" );
	DIA_TR_INF( "updateHashComparisonStatus --> 1 !!");
	if (hashCompStatus == true)
	{
		setConfigUpdateStatus(DIA_EN_CONFIG_UPDATE_STATUS_SUCCESS);
		DIA_TR_INF( "updateHashComparisonStatus --> 2 !!");
		 DIA_TR_ERRMEM("KDS Flashing Successful");
		if(mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
		{
			if (getUpregReceiveStatus() == true)
			{
				DIA_TR_INF( "updateHashComparisonStatus --> 3 !!");
				// create status result object
				midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus oStatusData;
				oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_CONFIGUPDATESUCCESS;
				vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB);
			}
			else
			{
				DIA_TR_INF( "updateHashComparisonStatus --> 5 !!");
			}

		}
		else
		{
			DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID failed.");
			DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID == AMT_C_U16_REGID_INVALID.");
		}

	}
	else
	{
		setConfigUpdateStatus(DIA_EN_CONFIG_UPDATE_STATUS_FAILED);
		DIA_TR_INF( "updateHashComparisonStatus --> 6 !!");
		 DIA_TR_ERRMEM("KDS Flashing Failed");
		if(mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
		{
			if (getUpregReceiveStatus() == true)
			{
				DIA_TR_INF( "updateHashComparisonStatus --> 7 !!");
				// create status result object
				midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus oStatusData;
				oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_CONFIGUPDATEFAILED;
				vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB);
			}
			else
			{
				DIA_TR_INF( "updateHashComparisonStatus --> 9 !!");
			}
		}
		else
		{
			DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID failed.");
			DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID == AMT_C_U16_REGID_INVALID.");
		}
	}
}

void dia_SAFeatureTestPatternAIVI::setHMIBlockStatus(void)
{
	dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::setHMIBlockStatus" );
	setConfigUpdateStatus(DIA_EN_CONFIG_UPDATE_STATUS_INPROGRESS);
	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
	{
		if (getUpregReceiveStatus() == true)
		{
			// create status result object
			midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus oStatusData;
			oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_CONFIGUPDATEINPROGRESS;
			DIA_TR_INF( "setHMIBlockStatus --> 2 !!");
			 DIA_TR_ERRMEM("KDS Flashing In-progress");
			vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB);
		}
		else
		{
			DIA_TR_INF( "setHMIBlockStatus --> 4 !!");
		}
	}
	else
	{
		DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID failed.");
		DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	}
}

void dia_SAFeatureTestPatternAIVI::vConfigUpdateViaUSB(amt_tclServiceData* poMessage)
{
	dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::vConfigUpdateViaUSB" );
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		DIA_TR_INF( "vConfigUpdateViaUSB --> AMT_C_U8_CCAMSG_OPCODE_UPREG !!");
		if (!bUpreg(poMessage))
		{
			DIA_TR_INF( "vConfigUpdateViaUSB --> 4 !!");
			// create and send error  message
			amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
			m_poGWMain->enPostMessage(&oErrorMessage);
			DIA_ASSERT_ALWAYS();
		}
		else
		{
			// Upreg successful : send a status message.
			setUpregReceiveStatus( TRUE );
			// create status result object
			midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus oStatusData;
			oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_UNDEFINED;
			if (getConfigUpdateStatus() == DIA_EN_CONFIG_UPDATE_STATUS_INPROGRESS)
			{
				DIA_TR_INF( "vConfigUpdateViaUSB --> 6 !!");

				oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_CONFIGUPDATEINPROGRESS;
				vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB);
			}
			else if (getConfigUpdateStatus() == DIA_EN_CONFIG_UPDATE_STATUS_SUCCESS)
			{
				DIA_TR_INF( "vConfigUpdateViaUSB --> 8 !!");

				oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_CONFIGUPDATESUCCESS;
				vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB);
			}
			else if (getConfigUpdateStatus() == DIA_EN_CONFIG_UPDATE_STATUS_FAILED)
			{
				DIA_TR_INF( "vConfigUpdateViaUSB --> 10 !!");
				oStatusData.ConfigUpdateStatus.enType = midw_fi_tcl_e8_KdsViaUsbUpdateStatus::FI_EN_CONFIGUPDATEFAILED;
				DIA_TR_INF( "vConfigUpdateViaUSB --> 11 !!");
				vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_CONFIGUPDATEVIAUSB);
			}
			else
			{
				DIA_TR_INF( "vConfigUpdateViaUSB --> 12 !!");
			}
			vSendStatusMsg(poMessage, oStatusData);
		}
		break;
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		DIA_TR_INF( "vConfigUpdateViaUSB --> AMT_C_U8_CCAMSG_OPCODE_RELUPREG !!");
		if (!bRelUpreg(poMessage)) {
			// Relupreg failed: send an error message
			amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
			m_poGWMain->enPostMessage(&oErrorMessage);
			NORMAL_M_ASSERT_ALWAYS();
		} else {
			// Relupreg successful : no action
		}
		break;
	default:
		// unknown opcode: just delete message
		break;
	}
	//if ( poMessage )
	//{
		(tVoid) poMessage->bDelete();
	//}
}



void dia_SAFeatureTestPatternAIVI::vResetToSupplierDefautConfig(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureTestPatternAIVI::vResetToSupplierDefautConfig"); //lint !e1788 ok --> scoped trace

   // Msg must come from a client
   OSAL_vAssert(poMessage->bIsServerMessage() == FALSE);

   if (OSAL_NULL == m_poGWMain) return;

   // the opcode tells what we should do
   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
   case AMT_C_U8_CCAMSG_OPCODE_SET:
   case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         // create and send error  message
         amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
         m_poGWMain->enPostMessage(&oErrorMessage);
      }
      break;

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
    	 //fi_tclVisitorMessage oMsg(poMessage);
         //midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart oData;
         //(tVoid) oMsg.s32GetData(oData);
         // get pointer to the Defset object
         // save defset msg
         m_oDefSetMessage.u16AppID = poMessage->u16GetSourceAppID();
         m_oDefSetMessage.u16CmdCounter = poMessage->u16GetCmdCounter();
         m_oDefSetMessage.u16RegisterID = poMessage->u16GetRegisterID();
         m_oDefSetMessage.u16FunctionID = poMessage->u16GetFunctionID();
         m_oDefSetMessage.u16SubID = poMessage->u16GetSourceSubID();

         dia_ISubsystemDiagnosisProxy* pInterface = nullptr;
         tDiaResult retCode = queryInterface<dia_ISubsystemDiagnosisProxy>(&pInterface);

		if ((retCode == DIA_SUCCESS) && pInterface)
		{
			(void) setSysAdapterListener<dia_ISubsystemDiagnosisProxyListener>(this);

			if (DIA_SUCCESS == pInterface->vAvdeccFilesDeleteRequest())
			{
				DIA_TR_INF("dia_SAFeatureTestPatternAIVI --> Request to vAvdeccFilesDeleteRequest sent.");
			}
			else
			{
				DIA_TR_ERR("dia_SAFeatureTestPatternAIVI --> Request to vAvdeccFilesDeleteRequest failed.");

			(void) unsetSysAdapterListener<dia_ISubsystemDiagnosisProxyListener>(this);
			}
		}
      }
      break;

   default:
      // unknown opcode: just delete message
      break;
   }

   (tVoid) poMessage->bDelete();
}



void
dia_SAFeatureTestPatternAIVI::onStartAvdeccFilesDelete ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureTestPatternAIVI::onStartAvdeccFilesDelete");

   tDiaResult retCode = DIA_FAILED;

   (void) unsetSysAdapterListener<dia_ISubsystemDiagnosisProxyListener>(this);

   if (result == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_SAFeatureTestPatternAIVI::onStartAvdeccFilesDelete result DIA_SUCCESS.");

  if( ResetToSupplierDefautConfig() == DIA_SUCCESS)
	  {
		 DIA_TR_ERR( "dia_SAFeatureTestPatternAIVI::vResetToSupplierDefautConfig: SUCCESS");
		 retCode = DIA_SUCCESS;
	  }
	  else
	  {
		 DIA_TR_ERR( "dia_SAFeatureTestPatternAIVI::vResetToSupplierDefautConfig: FAILED");
		 retCode = DIA_FAILED;
	  }
	  bSendvResetToSupplierDefautConfigResult( ( retCode == DIA_SUCCESS) ? TRUE : FALSE);
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureTestPatternAIVI::onStartAvdeccFilesDelete result DIA_FAILURE.");
	  bSendvResetToSupplierDefautConfigResult( ( retCode == DIA_SUCCESS) ? TRUE : FALSE);
   }
}


///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_tclService::bSendSetFactorySettingsStatus
//
//  DESCRIPTION: sends a SetFactorySettingsStatus status message
//
//  PARAMETER:   see FI parameters
//
//  RETURNVALUE: true - success
///////////////////////////////////////////////////////////////////////////
//

bool dia_SAFeatureTestPatternAIVI::bSendvResetToSupplierDefautConfigResult(tBool bResult)
{
	dia_tclFnctTrace trc("dia_SAFeatureTestPatternAIVI::bSendvResetToSupplierDefautConfigResult"); //lint !e1788 ok --> scoped trace

   // create result object

      midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult oResultData;
      oResultData.DefResetServiceStatus = bResult;

      fi_tclVisitorMessage oResultMsg(oResultData);
      oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
            m_oDefSetMessage.u16AppID, // Target
            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
            0, // StreamCounter
            m_oDefSetMessage.u16RegisterID, // RegisterID
            m_oDefSetMessage.u16CmdCounter, // nCmdCounter,
            DIA_USED_SRV_ID, // nServiceID,
            m_oDefSetMessage.u16FunctionID, // function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, AMT_C_U16_DEFAULT_NULL, m_oDefSetMessage.u16SubID);

      NORMAL_M_ASSERT(NULL != m_poGWMain);

      // send it
      if (NULL != m_poGWMain) {
         if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR)
         {
            (tVoid) oResultMsg.bDelete();
         }
      }

   return true;
}

bool dia_SAFeatureTestPatternAIVI::ResetToSupplierDefautConfig ( void )
{
	dia_tclFnctTrace oTrace("dia_SAFeatureTestPatternAIVI::ResetToSupplierDefautConfig()");

   tDiaResult retCode = DIA_FAILED;
   DIA_TR_INF("ResetToSupplierDefautConfig --- result = 0x%08x", retCode);

	tU32 u32ConfigSize = dia_DefaultConfiguration::getConfigToDeliveryRepSize();
	const dia_ConfigToDeliveryInfo *pDeliveryRep = dia_DefaultConfiguration::getConfigToDeliveryRep();

	for (tU32 i = 0; i < u32ConfigSize; i++ )
	{

		retCode = resetSupplierConfigItemToDeliveryState(pDeliveryRep[i].mCurrentProp, pDeliveryRep[i].mDefaultProp);
		if (retCode == DIA_FAILED)
		{
		   DIA_TR_ERR( "dia_SAFeatureTestPatternAIVI::ResetToSupplierDefautConfig: item %d (decimal) FAILED", i);
			break;
		}
	}
return retCode;
}

//-----------------------------------------------------------------------------

bool dia_SAFeatureTestPatternAIVI::resetSupplierConfigItemToDeliveryState ( tU32 propID, tU32 propDefaultID ) const
{
	dia_tclFnctTrace oTrace("dia_SAFeatureTestPatternAIVI::resetSupplierConfigItemToDeliveryState()");
   std::vector<tU8> data;

   // read the default data
   if ( DIA_SUCCESS != dia_getProperty(propDefaultID, data))
   {
      DIA_TR_ERR("resetSupplierConfigItemToDeliveryState: Reading Config Item Default 0x%08x Failed !!", propDefaultID);
      return DIA_FAILED;
   }
   // write the default data
   if ( DIA_SUCCESS != dia_setProperty(propID, data) )
   {
      DIA_TR_ERR("resetSupplierConfigItemToDeliveryState: Writing Config Item 0x%08x Failed !!", propID);
      return DIA_FAILED;
   }

   return DIA_SUCCESS;
}


void dia_SAFeatureTestPatternAIVI::vRuntimeSourceAppDataHandler(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureTestPatternAIVI::vRuntimeSourceAppDataHandler"); //lint !e1788 ok --> scoped trace

   tU8 u8data[4] = {0};
   tU32 u32SourceData = 0;
   // Msg must come from a client
   OSAL_vAssert(poMessage->bIsServerMessage() == FALSE);

   if (OSAL_NULL == m_poGWMain) return;

   // the opcode tells what we should do
   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
   case AMT_C_U8_CCAMSG_OPCODE_SET:
   case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         // create and send error  message
         amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
         m_poGWMain->enPostMessage(&oErrorMessage);
      }
      break;

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
    	 //fi_tclVisitorMessage oMsg(poMessage);
         //midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart oData;
         //(tVoid) oMsg.s32GetData(oData);
         // get pointer to the Defset object
         // save defset msg
         m_oDefSetMessage.u16AppID = poMessage->u16GetSourceAppID();
         m_oDefSetMessage.u16CmdCounter = poMessage->u16GetCmdCounter();
         m_oDefSetMessage.u16RegisterID = poMessage->u16GetRegisterID();
         m_oDefSetMessage.u16FunctionID = poMessage->u16GetFunctionID();
         m_oDefSetMessage.u16SubID = poMessage->u16GetSourceSubID();

         // Get method result data into fi type
         fi_tclVisitorMessage oMsg(poMessage);
         midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart oData;
         (tVoid) oMsg.s32GetData(oData);
         /* 
         CID 12731374 (#1 of 1): Missing argument to printf format specifier (PRINTF_ARGS)
         Fix: Removed extra format specifier
         */
         DIA_TR_INF("vRuntimeSourceAppDataHandler::vProcessRequest Runtime data = 0x%02x",  oData.RunTimeSourceAppData);

         switch (oData.RunTimeSourceAppID)
         {
			 case RUNTIME_U16_APP_AM:
				 {
					 DIA_TR_INF("udpateRuntimeSourceAppData --> RUNTIME_U16_APP_AM !!");

					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing FM persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_AM_DP);
					}

				 }
				 break;
			 case RUNTIME_U16_APP_FM:
				 {
					 DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_FM !!");

					 (void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing FM persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_FM_DP);
					}
				 }
				 break;
			 case RUNTIME_U16_APP_SXM:
				 {
					DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_SXM !!");

					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing SXM persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SXM_DP);
					}
				 }
				 break;
			 case RUNTIME_U16_APP_DAB:
				 {
					DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_DAB !!");
					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing DAB persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_DAB_DP);
					}
				 }
				 break;
			 case RUNTIME_U16_APP_WX:
				 {
					DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_WX !!");
					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing WX persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_WX_DP);
					}
				 }
				 break;
			 case RUNTIME_U16_APP_NAVI_RG:
				 {
					DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_NAVI_RG !!");
					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing WX persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_ROUTE_GUIDANCE_DP);
					}
				 }
				 break;
			 case RUNTIME_U16_APP_NAVI_MAPOUT:
				 {
					DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_NAVI_MAPOUT !!");
					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing WX persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_PAS_MAP_OUT_DP);
					}
				 }
				 break;
			 case RUNTIME_U16_APP_SPEECH_CONT_COUNTER:
				 {
					DIA_TR_INF("vRuntimeSourceAppDataHandler --> RUNTIME_U16_APP_SPEECH_CONT_COUNTER !!");
					(void) ::memset(u8data, 0, 4);
					tDiaResult retCode = dia_getProperty ( DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP)) );
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [0] = 0x%02x", u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [1] = 0x%02x", u8data [1]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [2] = 0x%02x", u8data [2]);
					DIA_TR_INF("udpateRuntimeSourceAppData::read DP u8data [3] = 0x%02x", u8data [3]);

					u32SourceData =  DIA_M_MAKE_RUNSOURCE_VALUE_U32(u8data [3],u8data [2],u8data [1],u8data [0]);
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest u32SourceData = 0x%02x", u32SourceData);
					u32SourceData += oData.RunTimeSourceAppData;
					DIA_TR_INF("udpateRuntimeSourceAppData::vProcessRequest after adding u32SourceData = 0x%02x", u32SourceData);
					u8data[0] =  u32SourceData;
					u8data[1] =  u32SourceData >> 8;
					u8data[2] =  u32SourceData >> 16;
					u8data[3] =  u32SourceData >> 24;
					if ( DIA_SUCCESS != dia_setProperty(DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP, (&(u8data [0])),sizeof(u8data)))
					{
						DIA_TR_ERR("udpateRuntimeSourceAppData: Writing WX persistent data 0x%08x Failed !!", DIA_PROP_CENTER_CMC_19_RUNTIME_SOURCE_SPEECH_CONT_COUNTER_DP);
					}
				 }
				 break;
			 default:
			       // unknown appID: just delete message
			       break;
         }

      }
      break;

   default:
      // unknown opcode: just delete message
      break;
   }

   (tVoid) poMessage->bDelete();
}

void dia_SAFeatureTestPatternAIVI::vSetDisplay(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::vSetDisplay" );

   if( poMessage )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
        	       case AMT_C_U8_CCAMSG_OPCODE_UPREG:
        	        DIA_TR_INF( "vSetDisplay --> AMT_C_U8_CCAMSG_OPCODE_UPREG !!");

        	          if (!bUpreg(poMessage)) {

        	             // create and send error  message
        	             amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
        	             m_poGWMain->enPostMessage(&oErrorMessage);
        	             DIA_ASSERT_ALWAYS();
        	          } else {
        	             // Upreg successful : send a status message.
        	             midw_diagnosticsfi_tclMsgSetDisplayStatus oStatusData;
        	             // send dummy status data
        	             vSendStatusMsg(poMessage, oStatusData);
        	          }
        	          (tVoid) poMessage->bDelete();
        	          break;
        	       case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        	        DIA_TR_INF( "vSetDisplay --> AMT_C_U8_CCAMSG_OPCODE_RELUPREG !!");

        	          if (!bRelUpreg(poMessage)) {

        	             // Relupreg failed: send an error message
        	             amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
        	             m_poGWMain->enPostMessage(&oErrorMessage);
        	             DIA_ASSERT_ALWAYS();
        	          } else {
        	             // Relupreg successful : no action
        	          }
        	          (tVoid) poMessage->bDelete();
        	          break;
        	       case AMT_C_U8_CCAMSG_OPCODE_SET: {
        	          DIA_TR_INF("vSetDisplay --> AMT_C_U8_CCAMSG_OPCODE_SET !!");

        	          dia_IDisplayPatternAIVIListener* pListener = OSAL_NULL;
        	          querySysAdapterListener<dia_IDisplayPatternAIVIListener>(&pListener);
        	          if (pListener) {
        	             DIA_TR_INF(" A valid listener exists for SetDisplay");

        	             // Get method result data into fi type
        	             fi_tclVisitorMessage oMsg(poMessage);
        	             midw_diagnosticsfi_tclMsgSetDisplaySet oData;
        	             (tVoid) oMsg.s32GetData(oData);

        	             tDiaResult SetDisplayResult = (oData.DisplayTestSuccess == TRUE ) ? DIA_SUCCESS : DIA_FAILED;

        	             DIA_TR_INF("vSetDisplay --- result = 0x%08x", SetDisplayResult);

        	             // inform all interested listeners
        	             pListener->vOnSetDisplayTestPatternDone(SetDisplayResult);
        	          }
        	       }
        	          break;
        	       default:
        	          // unknown opcode: just delete message
        	          (tVoid) poMessage->bDelete();
        	          break;
        	    }
        	 }
         }

tVoid
dia_SAFeatureTestPatternAIVI::vNotifyAllClients(fi_tclTypeBase const& oFIData, tU16 u16FuncId)
{
	DIA_TR_INF(("--> dia_SAFeatureTestPatternAIVI::vNotifyAllClients"));

	if (m_poGWMain && m_poGWMain->m_poNotTable)
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		m_poGWMain->m_poNotTable->vTraceTable(TR_CLASS_DIAGNOSTICS_BASE);

		// Run through the table to find all registered clients
		ahl_tNotification* pNot = m_poGWMain->m_poNotTable->poGetNotificationList(u16FuncId);


		for (; pNot != OSAL_NULL; pNot = pNot->pNext) {
			// construct result message
			fi_tclVisitorMessage oResultMsg(oFIData);
			// initialise result message
			oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
				pNot->u16AppID, // Target
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
				0, // StreamCounter
				pNot->u16RegisterID, // RegisterID
				pNot->u16CmdCounter, // nCmdCounter,
				DIA_USED_SRV_ID, // nServiceID,
				u16FuncId, // function ID
				AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL, pNot->u16SubID);

			// send it
			if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR) {
				(tVoid) oResultMsg.bDelete();
			}
		}
		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}
	else
	{
		DIA_TR_INF(("!!! dia_SAFeatureTestPatternAIVI::vNotifyAllClients => ERROR: Null pointer - m_poGWMain or m_poNotTable"));
	}
	DIA_TR_INF(("<-- dia_SAFeatureTestPatternAIVI::vNotifyAllClients"));
}

bool
dia_SAFeatureTestPatternAIVI::bUpreg(amt_tclServiceData const* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureTestPatternAIVI::bUpreg");

   if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

   tBool bRegOpStatus = FALSE;

	if(poMessage->u16GetFunctionID())
   {

         ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

         // Add the client to notification table
            bRegOpStatus = m_poGWMain->m_poNotTable->bAddNotification (
                  poMessage->u16GetFunctionID(),
                  poMessage->u16GetSourceAppID(),
                  poMessage->u16GetRegisterID(),
                  1,
                  poMessage->u16GetCmdCounter(),
               poMessage->u16GetSourceSubID());

         ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
   }

   return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//
// FUNCTION:   dia_SAFeatureTestPatternAIVI::bRelUpreg
//
// DESCRIPTION:   Removes the sender of the message from the NotifcationTable
//
// PARAMETER:  Relupreg request message
//
// RETURNVALUE:   true  : Client dereqistration successful
//                false : Client deregistration failed
//
///////////////////////////////////////////////////////////////////////////
//
bool
dia_SAFeatureTestPatternAIVI::bRelUpreg(amt_tclServiceData const* poMessage)
{
   if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

   tBool bRegOpStatus = FALSE;

   if ( (MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY != poMessage->u16GetFunctionID()) || (MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM != poMessage->u16GetFunctionID()) )
   {
       ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

   // Delete the client from notification table
      bRegOpStatus = m_poGWMain->m_poNotTable->bRemoveNotification (
            poMessage->u16GetFunctionID(),
            poMessage->u16GetSourceAppID(),
            poMessage->u16GetRegisterID(),
            1,
            poMessage->u16GetCmdCounter(),
            poMessage->u16GetSourceSubID()
            );

   ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
   }

   return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureTestPatternAIVI::vSendStatusMsg
//
//  DESCRIPTION: sends a CCA Status message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//

tVoid
dia_SAFeatureTestPatternAIVI::vSendStatusMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData) const
{
   if (NULL == poMessage) {
      return;
   }
   // initialise result message
   vSendMsg(poMessage, oFIData, AMT_C_U8_CCAMSG_OPCODE_STATUS);
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureTestPatternAIVI::vSendMsg
//
//  DESCRIPTION: sends a CCA message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//                u8OpCode - CCA op code
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//
tVoid
dia_SAFeatureTestPatternAIVI::vSendMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData, tU8 u8OpCode) const
{
   if (NULL == poMessage) {
      return;
   }
   // construct result message
   fi_tclVisitorMessage oResultMsg(oFIData);
   // initialise result message
   oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
         poMessage->u16GetSourceAppID(), // Target
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
         0, // StreamCounter
         poMessage->u16GetRegisterID(), // RegisterID
         poMessage->u16GetCmdCounter(), // nCmdCounter,
         DIA_USED_SRV_ID, // nServiceID,
         poMessage->u16GetFunctionID(), // function ID
         u8OpCode, AMT_C_U16_DEFAULT_NULL, poMessage->u16GetSourceSubID());
   // send it
   if (NULL != m_poGWMain) {
      if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR)
      {
         (tVoid) oResultMsg.bDelete();
      }
   }
}

void dia_SAFeatureTestPatternAIVI::setCISswUpdateProcessStatus ( tBool bResult )
{
	dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::setCISswUpdateProcessStatus" );
	//setConfigUpdateStatus(DIA_EN_CONFIG_UPDATE_STATUS_INPROGRESS);
	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
	{
		if (getUpregReceiveStatus() == true)
		{
			// create status result object
			midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus oStatusData;
			oStatusData.status = bResult;
			//DIA_TR_INF( "setHMIBlockStatus --> 2 !!");
			 DIA_TR_INF("SWUpdate Flashing --Now in Diagnosis Mode");
			 DIA_TR_ERRMEM("SWUpdate Flashing --Now in Diagnosis Mode");
			vNotifyAllClients(oStatusData,MIDW_DIAGNOSTICSFI_C_U16_CISSWUPDATEPROCESS);
		}
	}
	else
	{
		DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID failed.");
		DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	}
}
void dia_SAFeatureTestPatternAIVI::vSetHMISWupdateResult(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::vSetHMISWupdateResult" );

   if( poMessage )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
        	       case AMT_C_U8_CCAMSG_OPCODE_UPREG:
        	       {
	        	        DIA_TR_INF( "vSetHMISWupdateResult --> AMT_C_U8_CCAMSG_OPCODE_UPREG !!");

	        	          if (!bUpreg(poMessage)) {

	        	             // create and send error  message
	        	             amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
	        	             m_poGWMain->enPostMessage(&oErrorMessage);
	        	             DIA_ASSERT_ALWAYS();
	        	          } else {
	        	             // Upreg successful : send a status message.
	        	             midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus oStatusData;
	        	             // send dummy status data
	        	             vSendStatusMsg(poMessage, oStatusData);
	        	          }
	        	          (tVoid) poMessage->bDelete();
	        	          break;
        	        }
        	       case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        	       {
	        	        DIA_TR_INF( "vSetHMISWupdateResult --> AMT_C_U8_CCAMSG_OPCODE_RELUPREG !!");

	        	          if (!bRelUpreg(poMessage)) {

	        	             // Relupreg failed: send an error message
	        	             amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
	        	             m_poGWMain->enPostMessage(&oErrorMessage);
	        	             DIA_ASSERT_ALWAYS();
	        	          } else {
	        	             // Relupreg successful : no action
	        	          }
	        	          (tVoid) poMessage->bDelete();
	      	          break;
        	         }
        	       case AMT_C_U8_CCAMSG_OPCODE_SET:
        	       {
        	          DIA_TR_INF("vSetHMISWupdateResult --> AMT_C_U8_CCAMSG_OPCODE_SET !!");
        	          dia_IDisplayPatternAIVIListener* pListener = OSAL_NULL;
        	          querySysAdapterListener<dia_IDisplayPatternAIVIListener>(&pListener);
        	          if (pListener)
        	          {
        	             DIA_TR_INF(" A valid listener exists for HMISWupdateResult");

        	     		// Get method result data into fi type
        	             fi_tclVisitorMessage oMsg(poMessage);
        	             midw_diagnosticsfi_tclMsgCISswUpdateProcessSet oData;
        	             (tVoid) oMsg.s32GetData(oData);

        	             tBool HMISWupdateResult = (oData.status == TRUE ) ? TRUE : FALSE;
        	             DIA_TR_INF("vSetHMISWupdateResult --- result = %d", HMISWupdateResult);

        	             // inform all interested listeners
        	            // vOnCISswUpdateProcessResult(SetDisplayResult);
        	               pListener->vOnCISswUpdateProcessResult(HMISWupdateResult);
        	          }
        	          break;
        	        }
        	       default:
        	          // unknown opcode: just delete message
        	          (tVoid) poMessage->bDelete();
        	          break;
        }
    }
}

void dia_SAFeatureTestPatternAIVI::setCISswUpdateStage2ProcessStatus ( tBool bStage2Result )
{
    dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::setCISswUpdateStage2ProcesStatus" );
    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
        if (getUpregReceiveStatus() == true)
        {
            // create status result object
            midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet oStatusData;
            oStatusData.status = bStage2Result;
            DIA_TR_INF("SWUpdate Flashing --Now in Diagnosis Mode");
            DIA_TR_ERRMEM("SWUpdate Flashing --Now in Diagnosis Mode");
            vNotifyAllClients(oStatusData,MIDW_DIAGNOSTICSFI_C_U16_CISSWUPDATESTAGE2PROCESS);
        }
    }
    else
    {
        DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID failed.");
        DIA_TR_INF("dia_SAFeatureTestPatternAIVI - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
}

void dia_SAFeatureTestPatternAIVI::vSetHMISWupdateStage2Result(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc( "dia_SAFeatureTestPatternAIVI::vSetHMISWupdateStage2Result" );

   if( poMessage )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
        case AMT_C_U8_CCAMSG_OPCODE_UPREG:
        {
            DIA_TR_INF( "vSetHMISWupdateStage2Result --> AMT_C_U8_CCAMSG_OPCODE_UPREG !!");
            if (!bUpreg(poMessage)) {
                // create and send error  message
                amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
                m_poGWMain->enPostMessage(&oErrorMessage);
                DIA_ASSERT_ALWAYS();
            } else {
                // Upreg successful : send a status message.
                midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus oStatusData;
                // send dummy status data
                vSendStatusMsg(poMessage, oStatusData);
                }
                (tVoid) poMessage->bDelete();
                break;
        }
        case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        {
            DIA_TR_INF( "vSetHMISWupdateResult --> AMT_C_U8_CCAMSG_OPCODE_RELUPREG !!");
            if (!bRelUpreg(poMessage)) {
                // Relupreg failed: send an error message
                amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
                m_poGWMain->enPostMessage(&oErrorMessage);
                DIA_ASSERT_ALWAYS();
            } else {
                // Relupreg successful : no action
                }
                (tVoid) poMessage->bDelete();
                break;
        }
        case AMT_C_U8_CCAMSG_OPCODE_SET:
        {
            DIA_TR_INF("vSetHMISWupdateStage2Result --> AMT_C_U8_CCAMSG_OPCODE_SET !!");
            dia_IDisplayPatternAIVIListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDisplayPatternAIVIListener>(&pListener);
            if (pListener)
            {
                DIA_TR_INF(" A valid listener exists for HMISWupdateStage2Result");
                // Get method result data into fi type
                fi_tclVisitorMessage oMsg(poMessage);
                midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet oData;
                (tVoid) oMsg.s32GetData(oData);

                tBool HMISWupdateStage2Result = (oData.status == TRUE ) ? TRUE : FALSE;
                DIA_TR_INF("vSetHMISWupdateStage2Result --- result = %d", HMISWupdateStage2Result);

                // inform all interested listeners
                pListener->vOnCISswUpdateProcessStage2Result(HMISWupdateStage2Result);
            }
            break;
        }
        default:
             // unknown opcode: just delete message
             (tVoid) poMessage->bDelete();
             break;
      }
    }
}