/*
 * dia_SAFeatureSwitchCtrl.h
 *
 *  Created on: 27.01.2016
 *      Author: stc2hi
 */

#ifndef DIA_SAFEATURESWITCHCTRL_H_
#define DIA_SAFEATURESWITCHCTRL_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

// implemented interfaces
#ifndef __INCLUDED_DIA_INTERFACE_IT_COMMANDER_LISTENER__
#include "project/interfaces/dia_IITCommanderListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REAR_CONTROL_SWITCH_LISTENER__
#include "project/interfaces/dia_IRearControlSwitchListener.h"
#endif

class amt_tclServiceData;

class dia_SAFeatureSwitchCtrl
    : public dia_SystemAdapterFeature,
      public dia_IITCommander,
      public dia_IRearControlSwitch
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureSwitchCtrl);

public:
    //! default class constructor
    	dia_SAFeatureSwitchCtrl ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
    //! class destructor
    virtual ~dia_SAFeatureSwitchCtrl ( void );

    //
    // implementation of the dia_IITCommander interface
    //
    virtual tDiaResult getConnectionInfo ( void );

    //
    // implementation of the dia_IRearControlSwitch interface
    //
    virtual tDiaResult getRcsConnectionInfo ( void );

protected:
    //! handle the result of a Connection status message
    tVoid vHandleConnectionState ( amt_tclServiceData* poMessage ) const;
    tVoid vHandleRcsConnectionState( amt_tclServiceData* poMessage ) const;

    // declare message map data structures
    DECLARE_MSG_MAP(dia_SAFeatureSwitchCtrl)
};

#endif /* DIA_SAFEATURESWITCHCTRL_H_ */
