/*!
 * \file       dia_SAFeatureSubsystemDiagnosis.cpp
 *
 * \brief      SystemAdapter to implement the Subsystem Diagnosis Proxy.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaSystemAdapter
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include "common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SUBSYSTEM_DIAGNOSIS__
#include "dia_SAFeatureSubsystemDiagnosis.h"
#endif


dia_SAFeatureSubsystemDiagnosis::dia_SAFeatureSubsystemDiagnosis(dia_SystemAdapterServicePluginASF<SubsystemDiagnosisProxy>& pSrvPlugin)
   : dia_SystemAdapterFeatureASF<SubsystemDiagnosisProxy>(pSrvPlugin)
{
}

//-----------------------------------------------------------------------------

dia_SAFeatureSubsystemDiagnosis::~dia_SAFeatureSubsystemDiagnosis()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSubsystemDiagnosis::vStartUdpBroadcastClient ( void )
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::vStartUdpBroadcastClient");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      SubsystemDiagnosisProxy* proxy = mpSrvPlugin->getProxy();

      if (proxy)
      {
         //DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vStartUdpBroadcastClient got proxy.");

		/* function syntax : sendSetSocketOptionsRequest(SetSocketOptionsCallbackIF& cb, 
														 uint32 mFd, 
														 uint32 level, 
														 uint32 optname, 
														 const ::std::string& optval, 
														 uint32 optlen) const; */
														 
         act_t token = proxy->sendStartUDPBroadcastClientRequest(*this);
		 //token = proxy->sendDiscoverEntitiesRequest(*this);
		 
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vStartUdpBroadcastClient proxy is NULL.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vStartUdpBroadcastClient mpSrvPlugin is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vStartUdpBroadcastClient returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& /*proxy*/, const ::boost::shared_ptr< StartUDPBroadcastClientError >& error)
{
    dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientError");

    DIA_TR_ERR( "onStartUDPBroadcastClientError. ErrorName     = \"%s\"", error->getName().c_str() );
    DIA_TR_ERR( "onStartUDPBroadcastClientError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& /*proxy*/, const ::boost::shared_ptr< StartUDPBroadcastClientResponse >& response)
{
    // dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientResponse");

   // DIA_TR_INF("Set Socket Options status = %u", response->getStatus());

   tDiaResult result = (response->getStatus() == 0)? DIA_SUCCESS: DIA_FAILED;

   getInstanceOfApplication()->postMessage (
       new dia_tclDiagSession::tclEventIntMsgRxGeneric (
             new dia_FunctorOneArgNoReturnValue<dia_SAFeatureSubsystemDiagnosis, tDiaResult>(this, &dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientResponse, result)
      )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientResponse(tDiaResult result)
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientResponse");

   dia_ISubsystemDiagnosisProxyListener* pListener = nullptr;
   if ((querySysAdapterListener<dia_ISubsystemDiagnosisProxyListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->onStartUDPComm( result );
   }
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSubsystemDiagnosis::vAvdeccFilesDeleteRequest ( void )
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::vAvdeccFilesDeleteRequest");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      SubsystemDiagnosisProxy* proxy = mpSrvPlugin->getProxy();

      if (proxy)
      {
         //DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vAvdeccFilesDeleteRequest got proxy.");

		/* function syntax : sendSetSocketOptionsRequest(SetSocketOptionsCallbackIF& cb,
														 uint32 mFd,
														 uint32 level,
														 uint32 optname,
														 const ::std::string& optval,
														 uint32 optlen) const; */

         act_t token = proxy->sendAvdeccFilesDeleteRequest(*this);
		 //token = proxy->sendDiscoverEntitiesRequest(*this);

         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vAvdeccFilesDeleteRequest proxy is NULL.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vAvdeccFilesDeleteRequest mpSrvPlugin is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vAvdeccFilesDeleteRequest returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& /*proxy*/, const ::boost::shared_ptr< AvdeccFilesDeleteError >& error)
{
    dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteError");

    DIA_TR_ERR( "onAvdeccFilesDeleteError. ErrorName     = \"%s\"", error->getName().c_str() );
    DIA_TR_ERR( "onAvdeccFilesDeleteError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& /*proxy*/, const ::boost::shared_ptr< AvdeccFilesDeleteResponse >& response)
{
    // dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteResponse");

   // DIA_TR_INF("Set Socket Options status = %u", response->getStatus());

   tDiaResult result = (response->getStatus() == 0)? DIA_SUCCESS: DIA_FAILED;

   getInstanceOfApplication()->postMessage (
       new dia_tclDiagSession::tclEventIntMsgRxGeneric (
             new dia_FunctorOneArgNoReturnValue<dia_SAFeatureSubsystemDiagnosis, tDiaResult>(this, &dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteResponse, result)
      )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteResponse(tDiaResult result)
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onAvdeccFilesDeleteResponse");

   dia_ISubsystemDiagnosisProxyListener* pListener = nullptr;
   if ((querySysAdapterListener<dia_ISubsystemDiagnosisProxyListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->onStartAvdeccFilesDelete( result );
   }
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdRequest ( void )
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdRequest");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      SubsystemDiagnosisProxy* proxy = mpSrvPlugin->getProxy();

      if (proxy)
      {
         //DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdRequest got proxy.");

		/* function syntax : sendSetSocketOptionsRequest(SetSocketOptionsCallbackIF& cb, 
														 uint32 mFd, 
														 uint32 level, 
														 uint32 optname, 
														 const ::std::string& optval, 
														 uint32 optlen) const; */
														 
         act_t token = proxy->sendDiscoverEntitiesRequest(*this);
		 
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdRequest proxy is NULL.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdRequest mpSrvPlugin is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdRequest returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

tDiaResult
dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdResults ( void )
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdResults");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      SubsystemDiagnosisProxy* proxy = mpSrvPlugin->getProxy();

      if (proxy)
      {
         //DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdResults got proxy.");

		/* function syntax : sendSetSocketOptionsRequest(SetSocketOptionsCallbackIF& cb, 
														 uint32 mFd, 
														 uint32 level, 
														 uint32 optname, 
														 const ::std::string& optval, 
														 uint32 optlen) const; */
														 
         act_t token = proxy->sendDiscoverEntitiesResultsRequest(*this);
		 
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdResults proxy is NULL.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdResults mpSrvPlugin is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSubsystemDiagnosis::vBroadcastVehIdResults returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onDiscoverEntitiesResultsError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& /*proxy*/, const ::boost::shared_ptr< DiscoverEntitiesResultsError >& error)
{
    dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onStartUDPBroadcastClientError");

    DIA_TR_ERR( "onStartUDPBroadcastClientError. ErrorName     = \"%s\"", error->getName().c_str() );
    DIA_TR_ERR( "onStartUDPBroadcastClientError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onDiscoverEntitiesResultsResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& /*proxy*/, const ::boost::shared_ptr< DiscoverEntitiesResultsResponse >& response)
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onDiscoverEntitiesResultsResponse");
	::std::vector< DiscoverEntitiesResultsResponseNodeListStruct > nodeList = response->getNodeList();
   //DIA_TR_INF("Set Socket Options status = %u", response->getStatus());

   tDiaResult result = (response->getStatus() == 0)? DIA_SUCCESS: DIA_FAILED;

   getInstanceOfApplication()->postMessage (
       new dia_tclDiagSession::tclEventIntMsgRxGeneric (
             new dia_FunctorTwoArgsNoReturnValue<dia_SAFeatureSubsystemDiagnosis, tDiaResult, ::std::vector< DiscoverEntitiesResultsResponseNodeListStruct > >(this, &dia_SAFeatureSubsystemDiagnosis::onDiscoverEntitiesResultsResponse, result, nodeList)
      )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSubsystemDiagnosis::onDiscoverEntitiesResultsResponse(tDiaResult result, ::std::vector< DiscoverEntitiesResultsResponseNodeListStruct > nodeList)
{
   //dia_tclFnctTrace trc("dia_SAFeatureSubsystemDiagnosis::onDiscoverEntitiesResultsResponse");

   dia_ISubsystemDiagnosisProxyListener* pListener = nullptr;
   
   std::vector<subsystem> list_subsystem = {};
   
   /*
   struct subsystem {
	int sin_family;
	int sin_port;
	int s_addr;
	char sin_zero[8];
	int logAdr;
	tU8 EID[6];
	tU8 GID[6];
	tU8 VIN[17];
};
   */
   
   for (auto _node : nodeList)
   {
	   subsystem _subsystem;
	   _subsystem.sin_family = _node.getElem1();
	   _subsystem.sin_port = _node.getElem2();
	   _subsystem.s_addr = _node.getElem3();
	   _subsystem.logAdr = _node.getElem5();
	   
	DiscoverEntitiesResultsResponseNodeListElem4Struct elem4 = _node.getElem4();
	::std::vector<uint8> e4 = elem4.getElem1();
	
	DiscoverEntitiesResultsResponseNodeListElem6Struct elem6 = _node.getElem6();
	::std::vector<uint8> e6 = elem6.getElem1();
	
	DiscoverEntitiesResultsResponseNodeListElem7Struct elem7 = _node.getElem7();
	::std::vector<uint8> e7 = elem7.getElem1();
	
	DiscoverEntitiesResultsResponseNodeListElem8Struct elem8 = _node.getElem8();
	::std::vector<uint8> e8 = elem8.getElem1();
	
	   
	   for(int i=0; i<8; i++)
		{
			_subsystem.sin_zero[i] = e4[i];
		}
		for(int i=0; i<6; i++)
		{
			_subsystem.EID[i] = e6[i];
		}
		for(int i=0; i<6; i++)
		{
			_subsystem.GID[i] = e7[i];
		}
		for(int i=0; i<17; i++)
		{
			_subsystem.VIN[i] = e8[i];
		}
		
	   list_subsystem.push_back(_subsystem);
	   
   }
   
   if ((querySysAdapterListener<dia_ISubsystemDiagnosisProxyListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->onBroadcastVehIdResults( result, list_subsystem );
   }
}
