/*
 * dia_SAFeatureSpmTimerIntervalls.cpp
 *
 *  Created on: 17.01.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif
#include "common/interfaces/dia_ISpmTimerIntervallListener.h"
#include "dia_SAFeatureSpmTimerIntervalls.h" 


//#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_DBGVISITORS
//#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
//#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES        // or #define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_DBGVISITORS
//#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES

//#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG
//lint -e1516
//lint -e1712
//lint -e1735
//lint -e1739
#include "cfc_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
//lint +e1516
//lint +e1712
//lint +e1735
//lint +e1739
//#endif

#include "spm_fi_if.h"

//#define SPM_S_IMPORT_INTERFACE_SYSTEMIDS
//#include "spm_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

// MESSAGE MAP: the function will be called when a message with the
// corresponding FID arrives
//BEGIN_MSG_MAP(dia_SAFeatureSpmTimerIntervalls, dia_SystemAdapterFeature)
//   ON_MESSAGE(FID_SPM_STANDBY_PERS_TIME, vHandleSpmTimerIntervall)
//   ON_MESSAGE(FID_SPM_CLOCK_DISPLAY_TIME,vHandleSpmTimerIntervall)
//   ON_MESSAGE(FID_SPM_IGNITION_OFF_TIME, vHandleSpmTimerIntervall)
//   ON_MESSAGE(FID_SPM_SUSPEND_TIME,      vHandleSpmTimerIntervall)
//END_MSG_MAP()

BEGIN_MSG_MAP(dia_SAFeatureSpmTimerIntervalls, dia_SystemAdapterFeature)
   ON_MESSAGE(SPM_COREFI_C_U16_DEVICEPOWERONTIME,vHandleSpmTimerIntervall)
   ON_MESSAGE(SPM_COREFI_C_U16_CURRENTSYSTEMRUNTIME,vHandleSpmTimerIntervall)
   ON_MESSAGE(SPM_COREFI_C_U16_LASTSYSTEMRUNTIME,vHandleSpmTimerIntervall)
END_MSG_MAP()

//#define FID_SPM_CORRIDOR_TIME  0xFFFF

//static const tU16 g_aFIDMapping[DIA_EN_SPM_TIMERINTERVALL_ID_COUNT] = {
//      0,
//      FID_SPM_CLOCK_DISPLAY_TIME,
//      FID_SPM_IGNITION_OFF_TIME,
//      FID_SPM_STANDBY_PERS_TIME,
//      FID_SPM_SUSPEND_TIME,
//      CFC_SPMFI_C_U16_DEVICEPOWERONTIME
//};

static const tU16 g_aFIDMapping[DIA_EN_SPM_TIMERINTERVALL_ID_COUNT] = {
      0,    // DIA_EN_SPM_TIMERINTERVALL_ID_UNKNOWN
      0,    // DIA_EN_SPM_TIMERINTERVALL_ID_DISPLAY_CLOCK
      0,    // DIA_EN_SPM_TIMERINTERVALL_ID_IGNITION_OFF
      0,    // DIA_EN_SPM_TIMERINTERVALL_ID_STANDBY
      0,    // DIA_EN_SPM_TIMERINTERVALL_ID_SUSPEND
      SPM_COREFI_C_U16_DEVICEPOWERONTIME,     // DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER
      SPM_COREFI_C_U16_CURRENTSYSTEMRUNTIME,  // DIA_EN_SPM_TIMERINTERVALL_ID_SYSTEM_OPERATION_TIME
      SPM_COREFI_C_U16_LASTSYSTEMRUNTIME      // DIA_EN_SPM_TIMERINTERVALL_ID_LAST_SYSTEM_OPERATION_TIME
};

//------------------------------------------------------------------------------

dia_SAFeatureSpmTimerIntervalls::dia_SAFeatureSpmTimerIntervalls (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmTimerIntervalls::dia_SAFeatureSpmTimerIntervalls");
}

//-----------------------------------------------------------------------------

dia_SAFeatureSpmTimerIntervalls::~dia_SAFeatureSpmTimerIntervalls ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSpmTimerIntervalls::getSpmTimerIntervall ( dia_eSpmTimerIntervallID id )
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmTimerIntervalls::getSpmTimerIntervall");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      if ( (id > DIA_EN_SPM_TIMERINTERVALL_ID_UNKNOWN) && (id < DIA_EN_SPM_TIMERINTERVALL_ID_COUNT) )
      {
         gm_tclU32Message oMessage (
               mAppID,  // Sender ID
               mpSrvPlugin->getClientID(),   // Empfaenger ID
               mpSrvPlugin->getRegistrationID(),   // ID des registrierten Services (der CCA-Komponente)
               0,
               mpSrvPlugin->getServiceID(), // CCA service ID
               g_aFIDMapping[id],   // CCA function ID
               CCA_C_U8_OPCODE_GET
         );

         if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSpmTimerIntervalls::setSpmTimerIntervall ( dia_eSpmTimerIntervallID id, tU32 timerIntervall )
{
    dia_tclFnctTrace trc("dia_SAFeatureSpmTimerIntervalls::setSpmTimerIntervall()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       if ( (id > DIA_EN_SPM_TIMERINTERVALL_ID_UNKNOWN) && (id < DIA_EN_SPM_TIMERINTERVALL_ID_COUNT) )
       {
          gm_tclU32Message oMessage (
                mAppID,
                mpSrvPlugin->getClientID(),
                mpSrvPlugin->getRegistrationID(),
                0,
                mpSrvPlugin->getServiceID(),
                g_aFIDMapping[id],
                CCA_C_U8_OPCODE_SET
          );
          oMessage.vSetDWord(timerIntervall);

          if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
             DIA_TR_INF("dia_SAFeatureSpmTimerIntervalls::setSpmTimerIntervall SUCCESSFUL.");
             retCode = DIA_SUCCESS;
          } else {
             DIA_TR_INF("dia_SAFeatureSpmTimerIntervalls::setSpmTimerIntervall FAILED.");
          }
       }
    }

    return retCode;
}

//-----------------------------------------------------------------------------
#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
tVoid
dia_SAFeatureSpmTimerIntervalls::vHandleSpmTimerIntervall ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmTimerIntervalls::vHandleSpmTimerIntervall");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_ISpmTimerIntervallListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmTimerIntervallListener>(&pListener);
         if ( pListener )
         {
            dia_eSpmTimerIntervallID timeID = DIA_EN_SPM_TIMERINTERVALL_ID_UNKNOWN;

            switch ( poMessage->u16GetFunctionID() )
            {
//            case FID_SPM_STANDBY_PERS_TIME:
//               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_STANDBY;
//               break;
//
//            case FID_SPM_CLOCK_DISPLAY_TIME:
//               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_DISPLAY_CLOCK;
//               break;
//
////            case FID_SPM_CORRIDOR_TIME:
////               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_NAVI_CORRIDOR;
////               break;
//
//            case FID_SPM_IGNITION_OFF_TIME:
//               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_IGNITION_OFF;
//               break; 
//
//            case FID_SPM_SUSPEND_TIME:
//               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_SUSPEND;
//               break;

            case SPM_COREFI_C_U16_DEVICEPOWERONTIME:
               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER;
               break;

            case SPM_COREFI_C_U16_CURRENTSYSTEMRUNTIME:
               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_SYSTEM_OPERATION_TIME;
               break;

            case SPM_COREFI_C_U16_LASTSYSTEMRUNTIME:
               timeID = DIA_EN_SPM_TIMERINTERVALL_ID_LAST_SYSTEM_OPERATION_TIME;
               break;

            default:
               break;
            };

            if ( timeID != DIA_EN_SPM_TIMERINTERVALL_ID_UNKNOWN )
            {
               gm_tclU32Message oCompResp(const_cast<amt_tclServiceData*>(poMessage));
               pListener->vOnSpmTimerIntervall(timeID,oCompResp.u32GetDWord());
               pListener->vOnSystemOperationTime_Reset(DIA_SUCCESS);
            } else {
               pListener->vOnSystemOperationTime_Reset(DIA_FAILED);
            }
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "---opcode error recievd with error code:%u",u16ErrorCode);
      }

      (tVoid) poMessage->bDelete();
   }
}
