/*
 * dia_SAFeatureSpmBase.h
 *
 *  Created on: 19.01.2012
 *      Author: gib2hi
 */

#ifndef DIA_SAFEATURESPMBASE_H_
#define DIA_SAFEATURESPMBASE_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPMSVP_LISTENER__
#include "common/interfaces/dia_ISpmSVPListener.h"
#endif
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

template <typename PTRCONTAINER>
void clearPtrContainer(PTRCONTAINER &ptrContainer) {
   while (!ptrContainer.empty()) {
      delete ptrContainer.back();
      ptrContainer.pop_back();
   }
}
template<class FITYPE>
struct FiMsgHandlerBase {
   FiMsgHandlerBase(int id=-1):
      mId(id) {}
   virtual ~FiMsgHandlerBase() {};
   virtual void handleFiMsg(FITYPE &fi)=0;
   int mId;
};
template <class FITYPE> 
class FiMsgHandlerList {
public:
   ~FiMsgHandlerList() {
      clearPtrContainer(handlerList);
   }
   void clear() {
      clearPtrContainer(handlerList);
   }
   FiMsgHandlerBase<FITYPE> *getHandler(uint16_t cmdCounter) {
      DIA_TR_INF("FiMsgHandlerList::getHandler(cmdCounter=%u)", cmdCounter);
      for (typename std::list<FiMsgHandlerBase<FITYPE> *>::iterator iter=handlerList.begin();
           iter!=handlerList.end();
           ++iter) {
         if ((*iter)->mId==cmdCounter) {
            DIA_TR_INF("FiMsgHandlerList::getHandler FOUND: %p", *iter);
            return *iter;
         }
      }
      return nullptr;
   }
   void addHandler(FiMsgHandlerBase<FITYPE> *handler) {
      DIA_TR_INF("FiMsgHandlerList::addHandler() cmdCounter=%i %p", handler->mId, handler);
           handlerList.push_back(handler);
   }
   void deleteHandler(uint16_t cmdCounter) {
      DIA_TR_INF("FiMsgHandlerList::deleteHandler() cmdCounter=%u", cmdCounter);
      for (typename std::list<FiMsgHandlerBase<FITYPE> *>::iterator iter=handlerList.begin();
           iter!=handlerList.end();
           ++iter) {
         if ((*iter)->mId==cmdCounter) {
            DIA_TR_INF("FiMsgHandlerList::deleteHandler() FOUND %p", *iter);
            delete *iter;
            handlerList.erase(iter);
            return;
         }
      }
   }
   static std::list<FiMsgHandlerBase<FITYPE> *> handlerList;
};
template <class FITYPE> 
std::list<FiMsgHandlerBase<FITYPE> *> FiMsgHandlerList<FITYPE>::handlerList;
class spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult;
class dia_SAFeatureSpmBase
   : public dia_SystemAdapterFeature,
     public dia_ISpm,
     public dia_ISpmSVP
{
public:
   //! constructor
   dia_SAFeatureSpmBase ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSpmBase ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_SystemAdapterFeature methods
   //
   //-------------------------------------------------------------------------

   virtual tDiaResult startMonitoring ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ISpm methods
   //
   //-------------------------------------------------------------------------

   //! synchronous method used to retrieve the current system state
   virtual tDiaResult getSystemState ( dia_eSpmSystemState& /*state */ );
   //! synchronous method used to retrieve the system state
   virtual tDiaResult getRadioState( void );
   //! synchronous method used to retrieve the current HMI state
   virtual tDiaResult getHmiState ( dia_eSpmHmiState& /*state */ );
   //! synchronous method used to retrieve the current CVM state
   virtual tDiaResult getCVMState ( dia_eSpmCvmState& /*state */ ){ return DIA_E_NOT_IMPLEMENTED; }
   //! synchronous method used to retrieve the last CVM event
   virtual tDiaResult getCVMLastEvent ( dia_eSpmCvmEvent& /*state */ ){ return DIA_E_NOT_IMPLEMENTED; }

   //! request the current value of the battery voltage
   virtual tDiaResult getBatteryVoltage ( void ); 
   //! request the current system overall power status (line in)
   virtual tDiaResult getSystemPowerMode ( void );

   //! request the number of system resets
   virtual tDiaResult getSystemResetCounter ( void );
   //! reset system reset counter
   virtual tDiaResult resetSystemResetCounter ( void );
   //! reset system reset information
   virtual tDiaResult resetSystemResetInformation ( void );
   //! get system reset information
   virtual tDiaResult getSystemResetInformation ( void );
   //! next method is deprecated/obsolete. please use method setSubState instead
//   virtual tDiaResult signalDiagnosisActivity ( dia_eSpmDiagActivityMode mode );
   //! initiate a system shutdown
   virtual tDiaResult signalSystemShutdown ( dia_eSpmShutdownMode mode );
   //! initiate a system restart
   virtual tDiaResult signalSystemRestart ( dia_eSpmRestartMode mode );
   //! initiate a system restart
   virtual tDiaResult lcmSystemRestart ( dia_eSpmRestartMode mode );
   //! initiate a system reset
   virtual tDiaResult signalSystemReset ( dia_eSpmCoreRestartMode mode );
   //! initiate a system shutdown
   virtual tDiaResult signalWatchdog ( void ){ return DIA_E_NOT_IMPLEMENTED; }

   //! request the specified substate to be set to ON (mode = 1) or OFF (mode = 0)
   virtual tDiaResult setSubState ( dia_eSpmSubState substate, tBool mode );

   //! request the reset history
   virtual tDiaResult getResetHistory();
   //! request the wake up history
   virtual tDiaResult getWakeUpHistory();
   //! request the state history
   virtual tDiaResult getStateHistory();
   //! request the error state history of the given parameter
   virtual tDiaResult getErrStateHistory( dia_eSpmErrState errState );
   //! request the switch on history
   virtual tDiaResult getSwitchOnHistory(){ return DIA_E_NOT_IMPLEMENTED; }
   //! request the current power save mode of the vehicle
   virtual tDiaResult getSystemPowerSaveMode(){ return DIA_E_NOT_IMPLEMENTED; }
   //! request the voltage terminal value
   virtual tDiaResult getVoltageSplyTerminalValue();
   //! request power supply
   virtual tDiaResult getPowerSupplyStatus();
   //! request startup status
   virtual tDiaResult getStartupStatus();
   //! Set a new OnOff reason
   virtual tDiaResult sendOnOffTrigger (dia_eSpmSubState state, tBool mode);

   /* ============== AIVI-26132 [10/26/2016] ================= */
      //! request the Degraded Mode Counter
      virtual tDiaResult getDegradedModeCounter ();
      //! request the Degraded Mode Cumulated Duration
      virtual tDiaResult getDegradedModeTime ();
   /* ============== AIVI-26134 [11/02/2016] ================= */
      //! request the Time from Engine Stopped
      virtual tDiaResult getEngineStoppedTime ();
   /* ============== AIVI-37555 [11/25/2016] ================= */
      //! request the Vehicle Identifier Value
      virtual tDiaResult getVehicleIdentifierValue ();
	  
   // SW Vitality Parameters
   virtual tDiaResult getPowerSupplyVoltageEventCounters ();
   virtual tDiaResult getPowerSupplyVoltageHistogram ();
   virtual tDiaResult getCpuUsageStatistics ();
   virtual tDiaResult getRamUsageStatistics ();
   virtual tDiaResult getStartupTimeStatistics ();
   // SW Vitality Parameters for sw version
   virtual tDiaResult handleRequest(dia_tSpmSVPReqResetInformationForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqWakeupHistoryForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqResetHistoryForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqStateHistoryForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqErrorStateHistoryForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqSystemOperationTimeForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqAverageCpuLoadForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqMaximumRamConsumptionForSWVersion *request);
   virtual tDiaResult handleRequest(dia_tSpmSVPReqStartupTimeStatisticForSWVersion *request);


protected:
   //! deprecated default constructor
   dia_SAFeatureSpmBase ( void );

   //! small helper function to minimize source code
   tDiaResult dia_sendOPCODE_GET(tU16 fktID);

   void vHandleSystemState            ( amt_tclServiceData* poMessage );
   void vHandleHmiState               ( amt_tclServiceData* poMessage );
   void vHandleSystemRestart          ( amt_tclServiceData* poMessage ) const;
   void vHandleSubState               ( amt_tclServiceData* poMessage ) const;
   void vHandleOnOffTrigger           ( amt_tclServiceData* poMessage ) const;
   void vHandleRestartSetResult       ( amt_tclServiceData* poMessage ) const;
   void vHandleCriticalVoltageMonitorEvent ( amt_tclServiceData* poMessage ) const;
   void vHandleSystemResetList        ( amt_tclServiceData* poMessage ) const;
   void vHandleBatteryVoltageADCValue ( amt_tclServiceData* poMessage ) const;
   void vHandleStatusSwitchOnHistory  ( amt_tclServiceData* /*poMessage */ ) const {  }
   void vHandleStatusWakeUpHistory    ( amt_tclServiceData* poMessage ) const;
   void vHandleStatusSystemPowerSaveMode   ( amt_tclServiceData* /*poMessage */  ) const { }
   void vHandleStatusVoltSplyTerminalValue ( amt_tclServiceData* poMessage ) const;
   void vHandlePowerSupplyStatus      ( amt_tclServiceData* poMessage ) const;

   void vHandleStatusResetHistory     ( amt_tclServiceData* poMessage ) const;
   void vHandleStatusStateHistory     ( amt_tclServiceData* poMessage ) const;
   void vHandleStatusErrStateHistory  ( amt_tclServiceData* poMessage ) ;
   void vHandleSystemResetInformation ( amt_tclServiceData* poMessage ) const;
   void vHandleSystemHardReset        ( amt_tclServiceData* poMessage ) const;
   void vHandleSystemVoltageInformation ( amt_tclServiceData* poMessage ) const;
   void vHandleSystemPowerMode        ( amt_tclServiceData* poMessage ) const;
   void vHandleStartupStatus          ( amt_tclServiceData* poMessage ) const;

   /* ============== AIVI-26132 [10/26/2016] ================= */
   void vHandleStatusDegradedCountValue ( amt_tclServiceData* poMessage ) const;
   void vHandleStatusDegradedTimeValue ( amt_tclServiceData* poMessage ) const;
   /* ============== AIVI-26132 [11/02/2016] ================= */
   void vHandleStatusEngineStoppedTimeValue ( amt_tclServiceData* poMessage ) const;
   /* ============== AIVI-37555 [11/25/2016] ================= */
   void vHandleStatusVehicleIdentifierValue ( amt_tclServiceData* poMessage ) const;
   
   void vHandleVoltageEventCounter    ( amt_tclServiceData* poMessage ) const;
   void vHandleVoltageRangeHistogram  ( amt_tclServiceData* poMessage ) const;
   void vHandleCpuUsageStatistic      ( amt_tclServiceData* poMessage ) const;
   void vHandleRamUsageStatistic      ( amt_tclServiceData* poMessage ) const;
   void vHandleStartupTimeStatistic   ( amt_tclServiceData* poMessage ) const;

   void vHandleSpecificSwVersionStatistic ( amt_tclServiceData* poMessage );
private:
   bool requestSpecificSwVersionStatistic(uint32_t index);

   template<class FIMSG>
   bool sendFiMessage(FIMSG &fiMsg, bool useCmdCounter) {
      fi_tclVisitorMessage oMsg(fiMsg);
      mpSrvPlugin->vInitServiceData(oMsg,  fiMsg.u16GetFunctionID(), fiMsg.u8GetOpCode(), useCmdCounter? mCmdCounter : 0);
      bool res=(mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE);
      if (useCmdCounter) {
         mCmdCounter++;
         if (!mCmdCounter) {
            mCmdCounter=10;
         }
      }
      return res;
   }
#ifndef __DIA_UNIT_TESTING__
   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureSpmBase)
#endif

protected:
   // current system state
   dia_eSpmSystemState mSystemState;
   // current Hmi state
   dia_eSpmHmiState mHmiState;
   // current critical voltage monitor state
   dia_eSpmCvmState mCVMState;
   // last critical voltage monitor event
   dia_eSpmCvmEvent mCVMEvent;
   // last activated error state request
   dia_eSpmErrState mLastRequestedErrState;
   uint16_t mCmdCounter;
   /*
     todo: could make map of all fn-ids.
     extension of fitypes by having static method to get fnid
   */
   FiMsgHandlerList<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult> mFiMsgHandlerListSpecificSWVersionStatistic;
};

#endif /* DIA_SAFEATURESPMBASE_H_ */
