 /*
 * \file        dia_SAFeatureSelfDiagnosisSecondDisplay.h
 *
 * \brief       System Adapter for selftest controller (used DiagLib routine control)
 *
 * \details
 *
 * \author      stc2hi
 *
 * \date        19-Oct-2017
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 *
 */

#ifndef __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_SECOND_DISPLAY__
#define __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_SECOND_DISPLAY__

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include <common/framework/sysadapters/dia_SystemAdapterFeature.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSelfDiagnosisSecondDisplay
   : public dia_SystemAdapterFeature,
     public dia_SystemSettingsModule
{
public:
   //! constructor
   dia_SAFeatureSelfDiagnosisSecondDisplay ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSelfDiagnosisSecondDisplay ();

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemSettingsModule
   //--------------------------------------------------------------------------

   //! prepare the module for the system setting
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! finalize the system setting
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

protected:
   //! deprecated default constructor
   dia_SAFeatureSelfDiagnosisSecondDisplay ( void );

   //! handle incoming CCA message for SelfDiagnosis
   void vHandleSelfDiagnosisResult ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureSelfDiagnosisSecondDisplay)
};

#endif /* __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_SECOND_DISPLAY__ */
