 /*
 * \file        dia_SAFeatureSelfDiagnosisExtAmplifier.h
 *
 * \brief       System Adapter for selftest controller (used DiagLib routine control)
 *
 * \details
 *
 * \author      wgl2hi, kaa1hi
 *
 * \date        14-Nov-2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 *
 */

#ifndef __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_EXTERNAL_AMPLIFIER__
#define __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_EXTERNAL_AMPLIFIER__

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSelfDiagnosisExtAmplifier
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IDiaglibRoutineControlListener,
     public dia_SystemSettingsModule
{
public:
   //! constructor
   dia_SAFeatureSelfDiagnosisExtAmplifier ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSelfDiagnosisExtAmplifier ();

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemSettingsModule
   //--------------------------------------------------------------------------

   //! prepare the module for the system setting
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! finalize the system setting
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IDiaglibRoutineControlListener methods
   //
   //-------------------------------------------------------------------------

   //! called on starting routine control
   virtual void vOnRoutineCtrlResult ( tU32 u32RoutineId, tenRoutineCtrlResult enRoutineStatus, const tDiaglibParamVector& oStartResult );
   //! called on requesting routine result
   virtual void vOnGetRoutineResult ( tU32 /*u32RoutineId*/, tenRoutineCtrlResult /*enRoutineStatus*/, const tDiaglibParamVector& /*oStartResult*/ ) {}

protected:
   //! deprecated default constructor
   dia_SAFeatureSelfDiagnosisExtAmplifier ( void );

   //! handle incoming CCA message for routine control
   void vHandleRoutineControl ( amt_tclServiceData* poMessage );

protected:
   //! diaglib routine control id
   const tU32 mDiagLibRoutineCtrlID;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureSelfDiagnosisExtAmplifier)
};

#endif /* __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_EXTERNAL_AMPLIFIER__ */
