/*
 * dia_SAFeatureSecurity.cpp
 *
 *  Created on: 19.01.2012
 *      Author: gib2hi
 */

#if 0
#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif
#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#if 0

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include <common/framework/application/dia_common_core.h>
#endif

#ifndef __INCLUDED_DIA_ERROR_INFO_INTERFACE__
#include <common/framework/errmgmt/dia_ErrorInfoInterface.h>
#endif

#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_DBGVISITORS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES

//#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG
//lint -e1516
//lint -e1712
//lint -e1735
//lint -e1739
#include "cfc_fi_if.h"
//lint +e1516
//lint +e1712
//lint +e1735
//lint +e1739
//#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#endif

#include "dia_SAFeatureSecurity.h"

#if 0
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureSecurity.cpp.trc.h"
#endif
#endif

#if 0
BEGIN_MSG_MAP(dia_SAFeatureSecurity, dia_SystemAdapterFeature)
   ON_MESSAGE(CFC_SPMFI_C_U16_MANUFACTURERSENABLECOUNTER, vHandleManufacturersEnableCounter)
   ON_MESSAGE(CFC_SPMFI_C_U16_VIN,                    vHandleVehicleIdentificationNumber)
   ON_MESSAGE(CFC_SPMFI_C_U16_CLEARVIN,               vHandleClearVin)
   ON_MESSAGE(CFC_SPMFI_C_U16_SECURITYSTATE,          vHandleSecurityState)
END_MSG_MAP()
#endif

#define DIA_PROP_NAVI_UNIT_SIZE 8
#define DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE 7
#define DIA_PROP_ECU_SERIAL_NR_RESERVED_SIZE 5
#define DIA_PROP_ECU_SERIAL_NR_TOTAL_SIZE (DIA_PROP_NAVI_UNIT_SIZE+DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE+DIA_PROP_ECU_SERIAL_NR_RESERVED_SIZE)

tU8 g_AIVI_ECUSerialNumber[DIA_PROP_ECU_SERIAL_NR_TOTAL_SIZE];

//------------------------------------------------------------------------------

dia_SAFeatureSecurity::dia_SAFeatureSecurity(void) :
      mResult(DIA_SUCCESS),
      mbTestKey(TRUE)
{
   if (dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING) == DIA_AIVI_VARIANT_CODING_LENGTH)
   {
      tU8 aiviVariantCoding[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
      tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCoding, DIA_AIVI_VARIANT_CODING_LENGTH);
      if (getPropRes == DIA_SUCCESS)
      {
         //Check SecurityAccessKeySelector
         mbTestKey = ((aiviVariantCoding[3] & (1 << 1)) == (1 << 1))? TRUE: FALSE;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSecurity ==============================================================");
         DIA_TR_ERR("dia_SAFeatureSecurity FAILURE WITH READING CONTENT OF DIA_PROP_AIVI_VARIANT_CODING !");
         DIA_TR_ERR("dia_SAFeatureSecurity ==============================================================");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSecurity ======================================================");
      DIA_TR_ERR("dia_SAFeatureSecurity AIVI_VARIANT_CODING_LENGTH WRONG! IS=%d SHOULD=%d !",
            dia_getPropertySize(DIA_PROP_AIVI_VARIANT_CODING), DIA_AIVI_VARIANT_CODING_LENGTH);
      DIA_TR_ERR("dia_SAFeatureSecurity ======================================================");
   }

   DIA_TR_INF("dia_SAFeatureSecurity => TestKey = %d.", mbTestKey);
}

//-----------------------------------------------------------------------------

dia_SAFeatureSecurity::~dia_SAFeatureSecurity(void)
{
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSecurity::getEcuSerialNumber ( void )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::getEcuSerialNumber");

   tU8 m_serialNumber[DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE];
   tU8 m_naviUnit[DIA_PROP_NAVI_UNIT_SIZE];

   mSerialno.clear();

   /* ECU Serial Number */
   if ((dia_getPropertySize(DIA_PROP_CM_ECU_SERIAL_NR) == DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE) &&
         (DIA_SUCCESS == dia_getProperty(DIA_PROP_CM_ECU_SERIAL_NR, m_serialNumber, DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE)))
   {
      DIA_TR_INF("dia_SAFeatureSecurity::getEcuSerialNumber:: serial nr = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x.",
            m_serialNumber[0], m_serialNumber[1], m_serialNumber[2], m_serialNumber[3],
            m_serialNumber[4], m_serialNumber[5], m_serialNumber[6]);

      for (int i = 0; i < DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE; i++) mSerialno.push_back(m_serialNumber[i]);
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSecurity::getEcuSerialNumber:: serial number empty - set default.");

      for (int i = 0; i < DIA_PROP_CM_ECU_SERIAL_NUMBER_SIZE; i++) mSerialno.push_back('0');
   }

   /* Navi Unit */
   if ((dia_getPropertySize(DIA_PROP_CM_NAVI_UNIT) == DIA_PROP_NAVI_UNIT_SIZE) &&
         (DIA_SUCCESS == dia_getProperty(DIA_PROP_CM_NAVI_UNIT, m_naviUnit, DIA_PROP_NAVI_UNIT_SIZE)))
   {
      DIA_TR_INF("dia_SAFeatureSecurity::getEcuSerialNumber:: Navi Unit = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x.",
            m_naviUnit[0], m_naviUnit[1], m_naviUnit[2], m_naviUnit[3],
            m_naviUnit[4], m_naviUnit[5], m_naviUnit[6], m_naviUnit[7]);

      for (int i = 0; i < DIA_PROP_NAVI_UNIT_SIZE; i++) mSerialno.push_back(m_naviUnit[i]);
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSecurity::getEcuSerialNumber:: navi unit empty - set default.");

      for (int i = 0; i < DIA_PROP_NAVI_UNIT_SIZE; i++) mSerialno.push_back('0');
   }

   /* Reserve */
   for (int i = 0; i < DIA_PROP_ECU_SERIAL_NR_RESERVED_SIZE; i++) mSerialno.push_back(' ');

   DIA_ASSERT(mSerialno.size() == DIA_PROP_ECU_SERIAL_NR_TOTAL_SIZE);

   for (int i = 0; i < DIA_PROP_ECU_SERIAL_NR_TOTAL_SIZE; i++)
   {
      g_AIVI_ECUSerialNumber[i] = mSerialno[i];
   }

   getInstanceOfApplication()->postMessage (
         OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSecurity, const std::vector<tU8>& >(this,
                     &dia_SAFeatureSecurity::vOnEcuSerialNumber, mSerialno)
         )
   );

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSecurity::getStaticKey ( void )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::getStaticKey");

   static std::vector<tU8> staticKey;

   if (mbTestKey)
   {
      staticKey.clear();
      staticKey.push_back(0x00);
      staticKey.push_back(0x01);
      staticKey.push_back(0x02);
      staticKey.push_back(0x03);
      staticKey.push_back(0x04);
      staticKey.push_back(0x05);
      staticKey.push_back(0x06);
      staticKey.push_back(0x07);
      staticKey.push_back(0x08);
      staticKey.push_back(0x09);
      staticKey.push_back(0x0A);
      staticKey.push_back(0x0B);
      staticKey.push_back(0x0C);
      staticKey.push_back(0x0D);
      staticKey.push_back(0x0E);
      staticKey.push_back(0x0F);
   }
   else
   {
      staticKey.clear();
      staticKey.push_back(0xEB);
      staticKey.push_back(0xB1);
      staticKey.push_back(0x9B);
      staticKey.push_back(0x81);
      staticKey.push_back(0x1A);
      staticKey.push_back(0xC7);
      staticKey.push_back(0x20);
      staticKey.push_back(0xB6);
      staticKey.push_back(0x05);
      staticKey.push_back(0xC3);
      staticKey.push_back(0xB8);
      staticKey.push_back(0xD5);
      staticKey.push_back(0xC2);
      staticKey.push_back(0x44);
      staticKey.push_back(0xAE);
      staticKey.push_back(0x0F);
   }

   getInstanceOfApplication()->postMessage (
         OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSecurity, const std::vector<tU8>& >(this,
                     &dia_SAFeatureSecurity::vOnStaticKey, staticKey)
         )
   );

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureSecurity::getIndexSrvData ( void )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::getIndexSrvData");

   static std::vector<tU8> indexSrvData;

   if (mbTestKey)
   {
      indexSrvData.clear();
      indexSrvData.push_back('B');
      indexSrvData.push_back('O');
      indexSrvData.push_back('S');
      indexSrvData.push_back('C');
      indexSrvData.push_back('H');
      indexSrvData.push_back('_');
      indexSrvData.push_back('T');
      indexSrvData.push_back('E');
      indexSrvData.push_back('S');
      indexSrvData.push_back('T');
   }
   else
   {
      indexSrvData.clear();
      indexSrvData.push_back('R');
      indexSrvData.push_back('B');
      indexSrvData.push_back('O');
      indexSrvData.push_back('S');
      indexSrvData.push_back('C');
      indexSrvData.push_back('H');
      indexSrvData.push_back('N');
      indexSrvData.push_back('A');
      indexSrvData.push_back('V');
      indexSrvData.push_back('I');
   }

   getInstanceOfApplication()->postMessage (
         OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSecurity, const std::vector<tU8>& >(this,
                     &dia_SAFeatureSecurity::vOnIndexSrvData, indexSrvData)
         )
   );

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

#if 0

tDiaResult
dia_SAFeatureSecurity::bGetManufacturersEnableCounter ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::bGetManufacturersEnableCounter"));

   tDiaResult retCode = DIA_FAILED;

   // create get request
   cfc_spmfi_tclMsgManufacturersEnableCounterGet oMsgData;

   //construct Get message
   fi_tclVisitorMessage oTestMsg(oMsgData);
   oTestMsg.vInitServiceData (
                               mAppID,
                               mpSrvPlugin->getClientID(),
                               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                               0,
                               mpSrvPlugin->getRegistrationID(),
                               0,
                               mpSrvPlugin->getServiceID(),
                               CFC_SPMFI_C_U16_MANUFACTURERSENABLECOUNTER,
                               AMT_C_U8_CCAMSG_OPCODE_GET
                               );

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureSecurity::bGetManufacturersEnableCounter => post the message to SPM"));

   if ( mpSrvPlugin->bTransmitMessage(&oTestMsg) == TRUE )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSensor::bGetManufacturersEnableCounter => ERROR: transmitMessage failed."));
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::bGetManufacturersEnableCounter (%x)",retCode));
   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSecurity::bSetManufacturersEnableCounter ( tU8 u8MEC )
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::bSetManufacturersEnableCounter"));

   tDiaResult retCode = DIA_FAILED;

   // create set request
   cfc_spmfi_tclMsgManufacturersEnableCounterSet oMsgData;
   oMsgData.MEC = u8MEC;

   //construct MethodStart message
   fi_tclVisitorMessage oTestMsg(oMsgData);
   oTestMsg.vInitServiceData (
                               mAppID,
                               mpSrvPlugin->getClientID(),
                               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                               0,
                               mpSrvPlugin->getRegistrationID(),
                               0,
                               mpSrvPlugin->getServiceID(),
                               CFC_SPMFI_C_U16_MANUFACTURERSENABLECOUNTER,
                               AMT_C_U8_CCAMSG_OPCODE_SET
                               );

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureSecurity::bSetManufacturersEnableCounter => post the message to SPM"));

   if ( mpSrvPlugin->bTransmitMessage(&oTestMsg) == TRUE )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSecurity::bSetManufacturersEnableCounter => ERROR: transmitMessage failed."));
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::bSetManufacturersEnableCounter (%x)",retCode));
   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSecurity::bGetVehicleIdentificationNumber ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::bGetVehicleIdentificationNumber"));

   tDiaResult retCode = DIA_FAILED;

   // create set request
   cfc_spmfi_tclMsgVINGet oMsgData;

   //construct MethodStart message
   fi_tclVisitorMessage oTestMsg(oMsgData);
   oTestMsg.vInitServiceData (
                               mAppID,
                               mpSrvPlugin->getClientID(),
                               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                               0,
                               mpSrvPlugin->getRegistrationID(),
                               0,
                               mpSrvPlugin->getServiceID(),
                               CFC_SPMFI_C_U16_VIN,
                               AMT_C_U8_CCAMSG_OPCODE_GET
                               );

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureSecurity::bGetVehicleIdentificationNumber => post the message to SPM"));

   if ( mpSrvPlugin->bTransmitMessage(&oTestMsg) == TRUE )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSecurity::bGetVehicleIdentificationNumber => ERROR: transmitMessage failed."));
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::bGetVehicleIdentificationNumber (%x)",retCode));
   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSecurity::bStartVinRelearn ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::bStartVinRelearn"));

   tDiaResult retCode = DIA_FAILED;

   // create set request
   cfc_spmfi_tclMsgClearVINMethodStart oMsgData;

   //construct MethodStart message
   fi_tclVisitorMessage oTestMsg(oMsgData);
   oTestMsg.vInitServiceData (
                               mAppID,                            // AppID of this application
                               mpSrvPlugin->getClientID(),        // AppID of the Server
                               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                               0,                                 // StreamCounter
                               mpSrvPlugin->getRegistrationID(),  // RegId
                               0,                                 // command counter
                               mpSrvPlugin->getServiceID(),       // SID of the service
                               CFC_SPMFI_C_U16_CLEARVIN,          // FID
                               AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                               );

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureSecurity::bStartVinRelearn => post the message to SPM"));

   if ( mpSrvPlugin->bTransmitMessage(&oTestMsg) == TRUE )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSecurity::bGetVehicleIdentificationNumber => ERROR: transmitMessage failed."));
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::bStartVinRelearn (%x)",retCode));
   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSecurity::bGetSecurityState ( tVoid )
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::bGetSecurityState"));

   tDiaResult retCode = DIA_FAILED;

   // create set request
   cfc_spmfi_tclMsgSecurityStateGet oMsgData;

   //construct Get message
   fi_tclVisitorMessage oTestMsg(oMsgData);
   oTestMsg.vInitServiceData (
          mAppID,                            // AppID of this application
          mpSrvPlugin->getClientID(),        // AppID of the Server
          AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
          0,                                 // StreamCounter
          mpSrvPlugin->getRegistrationID(),  // RegId
          0,                                 // command counter
          mpSrvPlugin->getServiceID(),       // SID of the service
          CFC_SPMFI_C_U16_SECURITYSTATE,     // FID
          AMT_C_U8_CCAMSG_OPCODE_GET         // Get
          );

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureSecurity::bGetSecurityState => post the message to SPM"));

   if ( mpSrvPlugin->bTransmitMessage(&oTestMsg) == TRUE )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSecurity::bGetSecurityState => ERROR: transmitMessage failed."));
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::bGetSecurityState (%x)",retCode));
   return retCode;
}

#endif

//-----------------------------------------------------------------------------

void
dia_SAFeatureSecurity::vOnEcuSerialNumber ( const std::vector<tU8>& mSerialno )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::vOnEcuSerialNumber");

   dia_IAIVISecurityListener* pListener = NULL;
   mResult = querySysAdapterListener<dia_IAIVISecurityListener>(&pListener);

   if ((mResult == DIA_SUCCESS) && (pListener != NULL))
   {
      pListener->vOnEcuSerialNumber(mSerialno);
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSecurity::vOnStaticKey ( const std::vector<tU8>& staticKey )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::vOnStaticKey");

   dia_IAIVISecurityListener* pListener = NULL;
   mResult = querySysAdapterListener<dia_IAIVISecurityListener>(&pListener);

   if ((mResult == DIA_SUCCESS) && (pListener != NULL))
   {
      pListener->vOnStaticKey(staticKey);
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSecurity::vOnIndexSrvData ( const std::vector<tU8>& indexSrvData )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::vOnIndexSrvData");

   dia_IAIVISecurityListener* pListener = NULL;
   mResult = querySysAdapterListener<dia_IAIVISecurityListener>(&pListener);

   if ((mResult == DIA_SUCCESS) && (pListener != NULL))
   {
      pListener->vOnIndexSrvData(indexSrvData);
   }
}

//-----------------------------------------------------------------------------

#if 0

tVoid
dia_SAFeatureSecurity::vHandleManufacturersEnableCounter ( amt_tclServiceData* poMessage ) const
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::vHandleManufacturersEnableCounter"));

   if(poMessage != NULL)
   {
      dia_ISecurityListener* pListener = OSAL_NULL;
      tDiaResult res = querySysAdapterListener<dia_ISecurityListener>(&pListener);

      if ((res == DIA_SUCCESS) && (pListener != NULL))
      {
         // Msg must come from a server
          DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

          // Extract the op code of the message called
          tU8 u8OpCode = poMessage->u8GetOpCode();

          // Switch on the opCode received
          switch (u8OpCode)
          {
              case AMT_C_U8_CCAMSG_OPCODE_STATUS:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleManufacturersEnableCounter => AMT_C_U8_CCAMSG_OPCODE_STATUS"));

                  fi_tclVisitorMessage oResultMsg(poMessage);
                  cfc_spmfi_tclMsgManufacturersEnableCounterStatus oData;
                  tS32 s32Result = oResultMsg.s32GetData(oData);

                  if ( s32Result == OSAL_OK )
                  {
                     pListener->vOnMECCounterGetResult(oData.MEC);
                     pListener->vOnMECCounterSetResult(oData.MEC);
                  }
                  else
                  {
                     ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleManufacturersEnableCounter => oResultMsg.s32GetData FAILED"));
                     dia_ErrorInfoInterface err(pListener->getUID());
                     pListener->vOnError(err);
                  }

                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

              case AMT_C_U8_CCAMSG_OPCODE_ERROR:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleManufacturersEnableCounter => AMT_C_U8_CCAMSG_OPCODE_ERROR"));
                  dia_ErrorInfoInterface err(pListener->getUID());
                  pListener->vOnError(err);
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

              default:
              {
                  ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureSecurity::vHandleManufacturersEnableCounter => ERROR: unsupported u8OpCode %x",u8OpCode));
                  // unkown opcode: enter error handling here ( trace or assert )
                  break;
              }
          }// switch (u8OpCode)
       } //if (pListener != NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      (void)poMessage->bDelete();
      poMessage = NULL;
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::vHandleManufacturersEnableCounter"));
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber ( amt_tclServiceData* poMessage ) const
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber"));

   if(poMessage != NULL)
   {
      dia_ISecurityListener* pListener = OSAL_NULL;
      tDiaResult res = querySysAdapterListener<dia_ISecurityListener>(&pListener);

      if ((res == DIA_SUCCESS) && (pListener != NULL))
      {
         // Msg must come from a server
          DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

          // Extract the op code of the message called
          tU8 u8OpCode = poMessage->u8GetOpCode();

          // Switch on the opCode received
          switch (u8OpCode)
          {
              case AMT_C_U8_CCAMSG_OPCODE_STATUS:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber => AMT_C_U8_CCAMSG_OPCODE_STATUS"));

                  fi_tclVisitorMessage oResultMsg(poMessage);
                  cfc_spmfi_tclMsgVINStatus oData;
                  tS32 s32Result = oResultMsg.s32GetData(oData);

                  if ( s32Result == OSAL_OK )
                  {
                     tU32 u32VINLength = oData.VehicleIdentificationNumber.u32GetSize() / 2;

                     ETG_TRACE_USR3_THR(("--- VIN size=%d", u32VINLength));

                     tU8 u8Data[17]={0};
                     tU32 i;

                     for (i = 0; i < u32VINLength; i++)
                     {
                        tU32 u32Char;
                        sscanf((char*)(&oData.VehicleIdentificationNumber.szValue[i*2]),"%02x", &u32Char);
                        u8Data[i] = (tU8) (u32Char & 0xff);
                        ETG_TRACE_USR3_THR(("--- VIN[%d]=0x%02x", i, u8Data[i]));
                     }

                     pListener->vVehicleIdentificationNumberResult(u8Data);
                  }
                  else
                  {
                     ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber => oResultMsg.s32GetData FAILED"));
                     pListener->vVehicleIdentificationNumberError(EN_ERROR_FATAL_INTERNAL);
                  }
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

              case AMT_C_U8_CCAMSG_OPCODE_ERROR:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber => AMT_C_U8_CCAMSG_OPCODE_ERROR"));
                  pListener->vVehicleIdentificationNumberError(EN_ERROR_FATAL_INTERNAL);
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

              default:
              {
                  ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber => ERROR: unsuported u8OpCode %x",u8OpCode));
                  // unkown opcode: enter error handling here ( trace or assert )
                  break;
              }
          }// switch (u8OpCode)
       } //if (pListener != NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      (void)poMessage->bDelete();
      poMessage = NULL;
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::vHandleVehicleIdentificationNumber"));
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureSecurity::vHandleClearVin( amt_tclServiceData* poMessage ) const
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::vHandleClearVin"));

   if(poMessage != NULL)
   {
      dia_ISecurityListener* pListener = OSAL_NULL;
      tDiaResult res = querySysAdapterListener<dia_ISecurityListener>(&pListener);

      if ((res == DIA_SUCCESS) && (pListener != NULL))
      {
         // Msg must come from a server
          DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

          // Extract the op code of the message called
          tU8 u8OpCode = poMessage->u8GetOpCode();

          // Switch on the opCode received
          switch (u8OpCode)
          {
              case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleClearVin => AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:"));

                  fi_tclVisitorMessage oResultMsg(poMessage);
                  cfc_spmfi_tclMsgClearVINMethodResult oData;
                  tS32 s32Result = oResultMsg.s32GetData(oData);

                  if ( s32Result == OSAL_OK )
                  {
                     pListener->vVinRelearnResult(oData.Result);
                  }
                  else
                  {
                     ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleClearVin => oResultMsg.s32GetData FAILED"));
                     pListener->vVinRelearnError(EN_ERROR_FATAL_INTERNAL);
                  }

                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:

              case AMT_C_U8_CCAMSG_OPCODE_ERROR:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleClearVin => AMT_C_U8_CCAMSG_OPCODE_ERROR"));
                  pListener->vVinRelearnError(EN_ERROR_FATAL_INTERNAL);
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

              default:
              {
                  ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureSecurity::vHandleClearVin => ERROR: unsuported u8OpCode %x",u8OpCode));
                  // unkown opcode: enter error handling here ( trace or assert )
                  break;
              }
          }// switch (u8OpCode)
       } //if (pListener != NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      (void)poMessage->bDelete();
      poMessage = NULL;
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::vHandleClearVin"));
}

//------------------------------------------------------------------------------

tVoid
dia_SAFeatureSecurity::vHandleSecurityState( amt_tclServiceData* poMessage ) const
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSecurity::vHandleSecurityState"));

   if(poMessage != NULL)
   {
      dia_ISecurityListener* pListener = OSAL_NULL;
      tDiaResult res = querySysAdapterListener<dia_ISecurityListener>(&pListener);

      if ((res == DIA_SUCCESS) && (pListener != NULL))
      {
         // Msg must come from a server
          DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

          // Extract the op code of the message called
          tU8 u8OpCode = poMessage->u8GetOpCode();

          // Switch on the opCode received
          switch (u8OpCode)
          {
              case AMT_C_U8_CCAMSG_OPCODE_STATUS:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleSecurityState => AMT_C_U8_CCAMSG_OPCODE_STATUS"));

                  fi_tclVisitorMessage oResultMsg(poMessage);
                  cfc_spmfi_tclMsgSecurityStateStatus oData;
                  tS32 s32Result = oResultMsg.s32GetData(oData);

                  if ( s32Result == OSAL_OK )
                  {
                     ETG_TRACE_USR3_THR(("--- SecurityState = %d", oData.State.enType));

                     pListener->vOnSecurityStateGetResult((tU32)(oData.State.enType));
                  }
                  else
                  {
                     ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleSecurityState => oResultMsg.s32GetData FAILED"));
                     pListener->vOnSecurityStateGetError(EN_ERROR_FATAL_INTERNAL);
                  }

                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

              case AMT_C_U8_CCAMSG_OPCODE_ERROR:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSecurity::vHandleSecurityState => AMT_C_U8_CCAMSG_OPCODE_ERROR"));
                  pListener->vOnSecurityStateGetError(EN_ERROR_FATAL_INTERNAL);
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

              default:
              {
                  ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureSecurity::vHandleSecurityState => ERROR: unsuported u8OpCode %x",u8OpCode));
                  // unkown opcode: enter error handling here ( trace or assert )
                  break;
              }
          }// switch (u8OpCode)
       } //if (pListener != NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      (void)poMessage->bDelete();
      poMessage = NULL;
   }

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSecurity::vHandleSecurityState"));
}

#endif
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSecurity::getStaticKey4CMCSecLevDoip ( void )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureSecurity::getStaticKeyCMC");

   static std::vector<tU8> staticKey;

      staticKey.clear();
      staticKey.push_back(0x58);
      staticKey.push_back(0xD9);
      staticKey.push_back(0xEB);
      staticKey.push_back(0xAB);
      staticKey.push_back(0xFD);
      staticKey.push_back(0x1C);
      staticKey.push_back(0xF1);
      staticKey.push_back(0x14);
      staticKey.push_back(0xA9);
      staticKey.push_back(0x7C);
      staticKey.push_back(0x38);
      staticKey.push_back(0x04);
      staticKey.push_back(0xB5);
      staticKey.push_back(0x43);
      staticKey.push_back(0x36);
      staticKey.push_back(0xFB);

      getInstanceOfApplication()->postMessage (
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
                  OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSecurity, const std::vector<tU8>& >(this,
                        &dia_SAFeatureSecurity::vOnStaticKey, staticKey)
            )
      );

      return DIA_SUCCESS;
}

