/*
 * dia_SAFeatureSdsGuiPopup.h
 *
 *  Created on: Apr 19, 2016
 *      Author: jas1hi
 */

#ifndef DIA_SAFEATURESDSGUIPOPUP_H_
#define DIA_SAFEATURESDSGUIPOPUP_H_

#include <sds_gui_fi/PopUpServiceProxy.h>
#include <sds_gui_fi/PopUpServiceClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP_LISTENER__
#include <project/interfaces/dia_ISdsGuiPopupListener.h>
#endif

using namespace sds_gui_fi::PopUpService;


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSdsGuiPopup
   : public dia_SystemAdapterFeatureASF<PopUpServiceProxy>,
     public PopUpServiceClientBase,
     public dia_ISdsGuiPopup
{
public:
	//! constructor
	   dia_SAFeatureSdsGuiPopup (dia_SystemAdapterServicePluginASF<PopUpServiceProxy>& pSrvPlugin );

	//! destructor
	virtual ~dia_SAFeatureSdsGuiPopup();

	//! start monitoring of properties
	virtual tDiaResult startMonitoring();
	//! stop monitoring of properties
	virtual tDiaResult stopMonitoring();

	//-------------------------------------------------------------------------
	//
	// Overloaded dia_ISdsGuiPopup methods
	//
	//-------------------------------------------------------------------------
	virtual tDiaResult getSdsSpeechInputStatus ( tVoid );
	virtual tDiaResult registerToSdsSpeechInputStatus ( tVoid );
	virtual tDiaResult getSdsScreenID ( tVoid );
	virtual tDiaResult registerToSdsScreenID ( tVoid );

	//-------------------------------------------------------------------------
	//
	// Overloaded PopUpServiceClientBase methods
	//
	//-------------------------------------------------------------------------
	virtual tVoid onScreenIDError(const ::boost::shared_ptr< PopUpServiceProxy >& proxy, const ::boost::shared_ptr< ScreenIDError >& error);
	virtual tVoid onScreenIDUpdate(const ::boost::shared_ptr< PopUpServiceProxy >& proxy, const ::boost::shared_ptr< ScreenIDUpdate >& update);
	virtual tVoid onScreenIDUpdate(std::string screenID); //lint !e1411 Warning : Member with different signature hides virtual member

	virtual tVoid onSdsStatusError(const ::boost::shared_ptr< PopUpServiceProxy >& proxy, const ::boost::shared_ptr< SdsStatusError >& error);
	virtual tVoid onSdsStatusUpdate(const ::boost::shared_ptr< PopUpServiceProxy >& proxy, const ::boost::shared_ptr< SdsStatusUpdate >& update);
	virtual tVoid onSdsStatusUpdate(dia_eSpeechInputStatus speechInputStatus); //lint !e1411 Warning : Member with different signature hides virtual member

protected:
   //! deprecated default constructor
	dia_SAFeatureSdsGuiPopup ();
};

#endif /* DIA_SAFEATURESDSGUIPOPUP_H_ */
