/*
 * dia_SAFeatureSWUpdatePrj.cpp
 *
*/

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif
#ifndef DIA_SAFEATURESWUPDATEPRJ_H_
#include <project/framework/sysadapters/dia_SAFeatureSWUpdatePrj.h>
#endif

#define UpdateType_Quick 0
#define UpdateType_Full 1

//------------------------------------------------------------------------------

dia_SAFeatureSWUpdatePrj::dia_SAFeatureSWUpdatePrj(
      dia_SystemAdapterServicePluginASF<FcSwUpdateSrvProxy>& pSrvPlugin
      )
   : dia_SystemAdapterFeatureASF(pSrvPlugin)
{
   /*
   CID 13224680 (#1 of 1): Uninitialized scalar field (UNINIT_CTOR)
   Fix: Removed extra datatype.
   */
   updateFinalState=DIA_EN_UPDATE_PRJ_UPDATESTATE_IDLE;
}
//-----------------------------------------------------------------------------

dia_SAFeatureSWUpdatePrj::~dia_SAFeatureSWUpdatePrj()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSWUpdatePrj::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
      // Register to properties
      (void)mpSrvPlugin->getProxy()->sendUpdateStateRegister(*this);
      (void)mpSrvPlugin->getProxy()->sendReleaseDocRegister(*this);
      (void)mpSrvPlugin->getProxy()->sendUpdateErrorsRegister(*this);
      (void)mpSrvPlugin->getProxy()->sendUpdateProgressRegister(*this);
   }
   return DIA_SUCCESS;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSWUpdatePrj::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      // DeRegister properties
   }
   return DIA_SUCCESS;
}

/*//-----------------------------------------------------------------------------
dia_eSourceType getSourceType(tU32 sourceType)
{
   dia_eSourceType updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_USB;
    switch (sourceType)
   {
      case tenSourceType__Sd:
      {
       updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_SD;
         //errorStatus = error_removed_stick;
      }
      break;
      case tenSourceType__Ota:
      {
         updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTA;
       //  errorStatus = error_incompatible_usb_format; //incompatiable
      }
      break;
      case tenSourceType__other:
      {
       updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenSourceType__Usb:
      {
       updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_USB;
         //errorStatus = error_downgrade_stick;
      }
      break;
      default:
      {
         if (updateSource != tenSourceType__Usb)
         {
            updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER;
         }
      }
      break;
   }
   return updateSource;
}
//-----------------------------------------------------------------------------
dia_eUpdateState getUpdateState(tU32 upState )
{
   dia_eUpdateState updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_IDLE;
   switch (upState)
   {
      case tenUpdState__NotReady:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_NOTREADY;
         //errorStatus = error_removed_stick;
      }
      break;
      case tenUpdState__SelectSource:
      {
         updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_SELECTSOURCE;
       //  errorStatus = error_incompatible_usb_format; //incompatiable
      }
      break;
      case tenUpdState__SelectRelease:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_SELECTRELEASE;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Config:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_CONFIG;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Running:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_RUNNING;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Error:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_ERROR;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Skipping:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_SKIPPING;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Aborting:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_ABORTING;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Result:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_RESULT;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Reboot:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_REBOOT;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__WaitAllowRecoveryMode:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_WAITALLOWRECOVERYMODE;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__MediumRemoved:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_MEDIUMREMOVED;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__PreResult:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_PRERESULT;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Ready:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_READY;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdState__Idle:
      {
       updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_IDLE;
         //errorStatus = error_downgrade_stick;
      }
      break;
      default:
      if (updateState != tenUpdState__Idle)
         {
            updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_ERROR;
         }
      break;
   }
   return updateState;
}
//-----------------------------------------------------------------------------



dia_eUpdOptions getUpdOptions(tU32 updOption)
{
   dia_eUpdOptions updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWONLY;
   switch (updOption)
   {
      case tenUpdOptions__DifferentOnly:
      {
       updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_DIFFERENTONLY;
         //errorStatus = error_removed_stick;
      }
      break;
      case tenUpdOptions__Any:
      {
         updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_ANY;
       //  errorStatus = error_incompatible_usb_format; //incompatiable
      }
      break;
      case tenUpdOptions__UserDefined:
      {
       updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_USERDEFINED;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdOptions__NewAndSameOnly:
      {
       updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWANDSAMEONLY;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdOptions__NewOnly:
      {
       updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWONLY;
         //errorStatus = error_downgrade_stick;
      }
      break;
      default:
      if (updateOption != tenUpdOptions__NewOnly)
         {
            updateOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_USERDEFINED;
         }
      break;
   }
   return updateOption;
}

//-----------------------------------------------------------------------------
dia_eUpdDirection getUpdDirection(tU32 updDirection)
{
   dia_eUpdDirection updateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UPGRADE;
   switch (updDirection)
   {
      case tenUpdateDirection__Same:
      {
       updateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_SAME;
         //errorStatus = error_removed_stick;
      }
      break;
      case tenUpdateDirection__Downgrade:
      {
         updateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_DOWNGRADE;
       //  errorStatus = error_incompatible_usb_format; //incompatiable
      }
      break;
      case tenUpdateDirection__Unknown:
      {
       updateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UNKNOWN;
         //errorStatus = error_downgrade_stick;
      }
      break;
      case tenUpdateDirection__Upgrade:
      {
       updateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UPGRADE;
         //errorStatus = error_downgrade_stick;
      }
      break;
      default:
      if (updateDirection != tenUpdateDirection__Upgrade)
         {
            updateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UNKNOWN;
         }
      break;
   }
   return updateDirection;
}


*/




//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSWUpdatePrj::getUpdateState ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::getUpdateState");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendUpdateStateGet(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::getUpdateState. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::getUpdateState. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSWUpdatePrj::onUpdateStateError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateStateError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateStateUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateStateUpdate");

   trUpdState updateStateData = update->getUpdateState();
   std::string currentSystemVersion = updateStateData.getMuVersion();
   std::string overallsoftwareVersion = updateStateData.getOverallCISSWVer();
   tU32 updateDiagSource = updateStateData.getEnSourceType();
   //dia_eSourceType updateSource = getSourceType(updateSource);

   dia_eSourceType updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_USB;
   switch (updateDiagSource)
   {
   case tenSourceType__Sd:
   {
      updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_SD;
      //errorStatus = error_removed_stick;
   }
      break;
   case tenSourceType__Ota:
   {
      updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTA;
      //  errorStatus = error_incompatible_usb_format; //incompatiable
   }
      break;
   case tenSourceType__other:
   {
      updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenSourceType__Usb:
   {
      updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_USB;
      //errorStatus = error_downgrade_stick;
   }
      break;
   default:
   {
      if (updateDiagSource != tenSourceType__Usb)
      {
         /*
         CID 13224682 (#1 of 1): Logically dead code (DEADCODE)
         Fix: wrong variable used
         */
         updateSource = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER;
      }
   }
      break;
   }


   tU32 updateDiagState=static_cast<tU32>(updateStateData.getEnState());
   //dia_eUpdateState updateState = static_cast<dia_eUpdateState>(getUpdateState(updateDiagState));
   dia_eUpdateState updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_IDLE;
   switch (updateDiagState)
   {
   case tenUpdState__NotReady:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_NOTREADY;
      //errorStatus = error_removed_stick;
   }
      break;
   case tenUpdState__SelectSource:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_SELECTSOURCE;
      //  errorStatus = error_incompatible_usb_format; //incompatiable
   }
      break;
   case tenUpdState__SelectRelease:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_SELECTRELEASE;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Config:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_CONFIG;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Running:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_RUNNING;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Error:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_ERROR;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Skipping:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_SKIPPING;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Aborting:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_ABORTING;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Result:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_RESULT;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Reboot:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_REBOOT;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__WaitAllowRecoveryMode:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_WAITALLOWRECOVERYMODE;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__MediumRemoved:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_MEDIUMREMOVED;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__PreResult:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_PRERESULT;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Ready:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_READY;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdState__Idle:
   {
      updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_IDLE;
      //errorStatus = error_downgrade_stick;
   }
      break;
   default:
      if (updateDiagState != tenUpdState__Idle)
      {
         /*
         CID 13224684 (#1 of 1): Logically dead code (DEADCODE)
         Fix: Wrong variable used
         */
         updateState = DIA_EN_UPDATE_PRJ_UPDATESTATE_ERROR;
      }
      break;
   }

   updateFinalState = static_cast<dia_eUpdateState>(updateState);
   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateStateUpdate: overall software version = %s", overallsoftwareVersion.c_str());
   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateStateUpdate: currentSystemVersion = %s", currentSystemVersion.c_str());
   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateStateUpdate: updateFinalState = %d", updateFinalState);
   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateStateUpdate: update Source = %d", updateSource);

   
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSWUpdatePrj::getReleaseDoc ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::getReleaseDoc");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendReleaseDocGet(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::getReleaseDoc. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::getReleaseDoc. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onReleaseDocError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< ReleaseDocError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onReleaseDocError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onReleaseDocUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< ReleaseDocUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onReleaseDocUpdate");
   std::vector<dia_tReleaseDocInfo> releaseInfo;
   releaseInfo.clear();

   dia_tReleaseDocInfo stReleaseDocInfo;
   trReleaseDoc releaseDocData = update->getReleaseDoc();
   stReleaseDocInfo.mReleaseName = releaseDocData.getName(); //::std::string&
   stReleaseDocInfo.mNeedFlashing = releaseDocData.getBNeedsFlashing(); //bool
   stReleaseDocInfo.mEstimatedTime = releaseDocData.getU32EstimatedUpdateTimeSec(); //uint32
   tU32 filterDiagOption=releaseDocData.getEnUpdOptions();
   //stReleaseDocInfo.mFilterOption = getUpdOptions(filterDiagOption);
   stReleaseDocInfo.mFilterOption= DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWONLY;
   switch (filterDiagOption)
   {
   case tenUpdOptions__DifferentOnly:
   {
      stReleaseDocInfo.mFilterOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_DIFFERENTONLY;
      //errorStatus = error_removed_stick;
   }
      break;
   case tenUpdOptions__Any:
   {
      stReleaseDocInfo.mFilterOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_ANY;
      //  errorStatus = error_incompatible_usb_format; //incompatiable
   }
      break;
   case tenUpdOptions__UserDefined:
   {
      stReleaseDocInfo.mFilterOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_USERDEFINED;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdOptions__NewAndSameOnly:
   {
      stReleaseDocInfo.mFilterOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWANDSAMEONLY;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdOptions__NewOnly:
   {
      stReleaseDocInfo.mFilterOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWONLY;
      //errorStatus = error_downgrade_stick;
   }
      break;
   default:
      if (stReleaseDocInfo.mFilterOption != tenUpdOptions__NewOnly)
      {
         stReleaseDocInfo.mFilterOption = DIA_EN_UPDATE_PRJ_UPDATEOPTION_USERDEFINED;
      }
      break;
   }
   tU32 updateDiagDirection=releaseDocData.getEnUpdateDirection();

   stReleaseDocInfo.mUpdateDirection= DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UPGRADE;
   switch (updateDiagDirection)
   {
   case tenUpdateDirection__Same:
   {
      stReleaseDocInfo.mUpdateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_SAME;
      //errorStatus = error_removed_stick;
   }
      break;
   case tenUpdateDirection__Downgrade:
   {
      stReleaseDocInfo.mUpdateDirection= DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_DOWNGRADE;
      //  errorStatus = error_incompatible_usb_format; //incompatiable
   }
      break;
   case tenUpdateDirection__Unknown:
   {
      stReleaseDocInfo.mUpdateDirection= DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UNKNOWN;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenUpdateDirection__Upgrade:
   {
      stReleaseDocInfo.mUpdateDirection = DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UPGRADE;
      //errorStatus = error_downgrade_stick;
   }
      break;
   default:
   {
      if (stReleaseDocInfo.mUpdateDirection != tenUpdateDirection__Upgrade)
      {
         stReleaseDocInfo.mUpdateDirection= DIA_EN_UPDATE_PRJ_UPDATEDIRECTION_UNKNOWN;
      }
   }
      break;

   }
   tU32 sourceType=releaseDocData.getEnSourceType();
   // stReleaseDocInfo.mSourceType = getSourceType(sourceType); //tenSourceType
   stReleaseDocInfo.mSourceType = DIA_EN_UPDATE_PRJ_SOURCETYPE_USB;
   switch (sourceType)
   {
   case tenSourceType__Sd:
   {
      stReleaseDocInfo.mSourceType = DIA_EN_UPDATE_PRJ_SOURCETYPE_SD;
      //errorStatus = error_removed_stick;
   }
      break;
   case tenSourceType__Ota:
   {
      stReleaseDocInfo.mSourceType = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTA;
      //  errorStatus = error_incompatible_usb_format; //incompatiable
   }
      break;
   case tenSourceType__other:
   {
      stReleaseDocInfo.mSourceType = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER;
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenSourceType__Usb:
   {
      stReleaseDocInfo.mSourceType = DIA_EN_UPDATE_PRJ_SOURCETYPE_USB;
      //errorStatus = error_downgrade_stick;
   }
      break;
   default:
   {
      if (stReleaseDocInfo.mSourceType != tenSourceType__Usb)
      {
         stReleaseDocInfo.mSourceType = DIA_EN_UPDATE_PRJ_SOURCETYPE_OTHER;
      }
   }
      break;
   }

   DIA_TR_INF("onReleaseDocUpdate : ReleaseDoc = %s", stReleaseDocInfo.mReleaseName.c_str());
   DIA_TR_INF("onReleaseDocUpdate : NeedFlashing = %s", (stReleaseDocInfo.mNeedFlashing? "TRUE": "FALSE") );
   DIA_TR_INF("onReleaseDocUpdate : EstimatedTime = %d", stReleaseDocInfo.mEstimatedTime);
   DIA_TR_INF("onReleaseDocUpdate : Filter Option = %d",  stReleaseDocInfo.mFilterOption);
   DIA_TR_INF("onReleaseDocUpdate : UpdateDirection = %d", stReleaseDocInfo.mUpdateDirection);
   DIA_TR_INF("onReleaseDocUpdate : SourceType = %d", stReleaseDocInfo.mSourceType);

   if(stReleaseDocInfo.mReleaseName.empty())
   {
      vCheck = false;
   }
   else{
      vCheck = true;
   }
   DIA_TR_INF("onReleaseDocUpdate : vCheck = %d", vCheck);
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSWUpdatePrj::getUpdateErrors ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::getUpdateErrors");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendUpdateErrorsGet(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::getUpdateErrors. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::getUpdateErrors. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateErrorsError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateErrorsError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateErrorsError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateErrorsUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate");
   tU32 errorType = 0;
   trErrorIds updateErrorsStatus = update->getUpdateErrors();
   ::std::vector< tenErrorId > errorId = updateErrorsStatus.getErrorIds();
   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate Error list Size=%d", updateErrorsStatus.getErrorIds().size());
   for (std::vector < tenErrorId>::const_iterator iter = errorId.begin(); iter != errorId.end(); ++iter)
   {
      errorType = *iter;
      //DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d", errorType);
   }
   dia_eSWUpdatePrjError eError =DIA_EN_UPDATE_PRJ_ERROR_DEFAULT_SWL_OK;
   switch (errorType)
   {
   case tenErrorId__SWL_ERROR_MEDIA_UNAVAILABLE:
   {
      eError = DIA_EN_UPDATE_PRJ_ERROR_UNAVAILABLE_STICK;
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:Error-USB stick not available!", eError);
      //  errorStatus = error_unavailable_stick; // NO Stickk
   }
      break;
   case tenErrorId__SWL_ERROR_MEDIUM_REMOVED:
   {
      eError = DIA_EN_UPDATE_PRJ_ERROR_REMOVED_STICK;
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:Error-USB stick was removed!", eError);
      //errorStatus = error_removed_stick;
   }
      break;
   case tenErrorId__SWL_ERROR_INCOMPATIBLE_USB_FORMAT:
   {
      eError = DIA_EN_UPDATE_PRJ_ERROR_INCOMPATIBLE_USB_FORMAT;
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:Error-USB Format incompatible!", eError);
      //  errorStatus = error_incompatible_usb_format; //incompatiable
   }
      break;
   case tenErrorId__SWL_ERROR_IMAGE_INCOMPATIBLE_DOWNGRADE:
   {
      eError = DIA_EN_UPDATE_PRJ_ERROR_DOWNGRADE_STICK;
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:Error-SW Downgrade not allowed!", eError);
      //errorStatus = error_downgrade_stick;
   }
      break;
   case tenErrorId__SWL_ERROR_IMAGE_INCOMPATIBLE_SAME_VERSION:
   {
      eError = DIA_EN_UPDATE_PRJ_ERROR_SAMEGRADE_STICK;
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:SW Update Started with same Version!", eError);
      //errorStatus = error_samegrade_stick;
   }
      break;
   case tenErrorId__SWL_OK:
   {
      eError = DIA_EN_UPDATE_PRJ_ERROR_DEFAULT_SWL_OK;
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:SW Update Started!", eError);
      //errorStatus = error_default_SWL_OK;
   }
      break;
   default:
   {
      if (errorType != tenErrorId__SWL_OK)
      {
         eError = DIA_EN_UPDATE_PRJ_ERROR_INCOMPATIBLE_STICK;
         DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate ErrorValue = %d:Error-USB stick incompatible!", eError);
      }
   }
      break;
   }

   getInstanceOfApplication()->postMessage (
            DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSWUpdatePrj,dia_eSWUpdatePrjError > (this,&dia_SAFeatureSWUpdatePrj::diagUpdateErrorsUpdate,eError)
               )
            );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::diagUpdateErrorsUpdate(dia_eSWUpdatePrjError eError)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateErrorsUpdate");

   dia_ISWUpdatePrjListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISWUpdatePrjListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      DIA_TR_INF("querySysAdapterListener dia_ISWUpdatePrjListener vCheck = %d",vCheck);
      pListener->vOnUpdateErrors(eError, vCheck);
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISWUpdatePrjListener NULL");
   }
}

//-----------------------------------------------------------------------------
tDiaResult dia_SAFeatureSWUpdatePrj::getUpdateProgress ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::getUpdateProgress");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendUpdateProgressGet(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::getUpdateProgress. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::getUpdateProgress. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateProgressError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateProgressError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateProgressUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateProgressUpdate");

   if (update->hasUpdateProgress())
   {
      // if we receive, this property in the boot-up. (Headunit restarted during cis update,with usb plugged in)
      // its evident that USBstick with valid software is pulgged in. we will not receive ReleaseDoc or UpdateErrorState here

      const trUpdProgress currUpdProgress = update->getUpdateProgress();
      std::string subModuleName = currUpdProgress.getSubModuleName().c_str();
      /*
      CID 13224683 (#1 of 1): Invalid type in argument to printf format specifier (PRINTF_ARGS)
      Fix: Removed extra printf statements
      */
      // progress.SubModuleName = MIS as in <-- SWUPDATE_UTIL_US1: "subModuleName": "MIS",-->::FCSWUPDATE_MAIN
      if ((strncmp(subModuleName.c_str(), "MIS", 4) == 0) && (updateFinalState == DIA_EN_UPDATE_PRJ_UPDATESTATE_RUNNING))
      {
         DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateProgressUpdate - MIS update is running in Background. ");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateProgressUpdate - FAILED! ");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateProgressUpdate is received - No Updates");
   }

   // DIA_TR_INF("onEnterRecoveryModeResponse : bRecoveryMode is = %s", (bRecoveryMode? "TRUE": "FALSE") );


}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSWUpdatePrj::getUpdateOptionsInfo ( tVoid/*const dia_tUpdOptions& updOptions*/ )
{

   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::getUpdateOptionsInfo");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendSetUpdateOptionsRequest(*this, tenUpdOptions__Any);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::getUpdateOptionsInfo. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::getUpdateOptionsInfo. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;

}

//-----------------------------------------------------------------------------

/**
* SetSoftwareUpdateType - Error handling for nature of update user request for
* @param[in] Update type (quick , Full)
* @parm[out] none
* @return void
*/
tDiaResult
dia_SAFeatureSWUpdatePrj::SetSoftwareUpdateType(tU8 updateType)
{
   // ETG_TRACE_USR4(("SWUpdateClient::SetSoftwareUpdateType with UpdateType = %d", updateType));
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::SetSoftwareUpdateType");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      // updateOptions Diag values : Full Update - 1 (Any), Quick Update -0-(DifferentOnly)
      // updateOption HMI values : Full Update - 0 (Any), Quick Update - 1 (DifferentOnly)
      if (UpdateType_Quick == updateType)
      {
         act_t token = mpSrvPlugin->getProxy()->sendSetUpdateOptionsRequest(*this,tenUpdOptions__DifferentOnly);
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
         //_fcSwUpdateProxy->sendSetUpdateOptionsRequest(*this, tenUpdOptions__DifferentOnly);
      }
      else if (UpdateType_Full == updateType)
      {
         act_t token = mpSrvPlugin->getProxy()->sendSetUpdateOptionsRequest(*this,tenUpdOptions__Any);
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
         //  _fcSwUpdateProxy->sendSetUpdateOptionsRequest(*this, tenUpdOptions__Any);
      }
      //act_t token = mpSrvPlugin->getProxy()->sendSetUpdateOptionsRequest(*this);


   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::SetSoftwareUpdateType. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::SetSoftwareUpdateType. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;

}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onSetUpdateOptionsError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< SetUpdateOptionsError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onSetUpdateOptionsError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onSetUpdateOptionsResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< SetUpdateOptionsResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onSetUpdateOptionsResponse");
   //ETG_TRACE_USR4(("SWUpdateClient::onSetUpdateOptionsResponse"));

   //Recovery Mode was set: true or false
   //tBool bRecoveryMode = response->getBOk();

   //DIA_TR_INF("onEnterRecoveryModeResponse : bRecoveryMode is = %s", (bRecoveryMode? "TRUE": "FALSE") );

}

//-----------------------------------------------------------------------------
/**
* SetAllowRecoveryModeRequest -  To Send the 'AllowRecoveryModeRequest', this is to restart the system in recovery mode
* @param[in] bool flag - whether to set it or not
* @parm[out] none
* @return
*/

tDiaResult
dia_SAFeatureSWUpdatePrj::setAllowRecoveryModeRequest(bool flag)
{
   //ETG_TRACE_USR4(("SWUpdateClient::SetAllowRecoveryModeRequest. "));
   /* if (_fcSwUpdateProxy)
   {
      _fcSwUpdateProxy->sendSetAllowRecoveryModeRequest(*this, flag);
   }*/
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::setAllowRecoveryModeRequest");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendSetAllowRecoveryModeRequest(*this, flag);

      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::setAllowRecoveryModeRequest: ERROR - token is zero!");
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::setAllowRecoveryModeRequest. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::setAllowRecoveryModeRequest. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}
//-----------------------------------------------------------------------------
/**
* onUpdateErrorsError - update handling for SetAllowRecoveryModeErrors.
* @param[in] proxy
* @param[in] SetAllowRecoveryModeError
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onSetAllowRecoveryModeError(const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                                           const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onSetAllowRecoveryModeError is called");
   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------
/**
* onUpdateErrorsError - update handling for Allow Recovery Mode Response.
* @param[in] proxy
* @param[in] SetAllowRecoveryModeResponse
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onSetAllowRecoveryModeResponse(const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                                              const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onSetAllowRecoveryModeResponse is called");
    tBool bRecoveryMode = response->getBOk();

   DIA_TR_INF("onSetAllowRecoveryModeResponse : bRecoveryMode is = %s", (bRecoveryMode? "TRUE": "FALSE") );

}
//-----------------------------------------------------------------------------
/**
* handleStartDownloadRequest -  To handle 'ApplyDoc' property request
* @param[in] none
* @parm[out] none
* @return
*/
tDiaResult
dia_SAFeatureSWUpdatePrj::handleStartDownloadRequest( )
{

   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::handleStartDownloadRequest");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendApplyDocRequest(*this);

      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::handleStartDownloadRequest: ERROR - token is zero!");
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::handleStartDownloadRequest. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::handleStartDownloadRequest. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

/**
* onApplyDocError - Error handling for ApplyDoc.
* @param[in] proxy
* @param[in] error
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onApplyDocError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                               const ::boost::shared_ptr< ApplyDocError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onApplyDocError");
   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------
/*
**
* onApplyDocResponse - update handling for ApplyDoc.
* @param[in] proxy
* @param[in] update
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onApplyDocResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                                  const ::boost::shared_ptr< ApplyDocResponse >& response)
{

   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onApplyDocResponse");
   tBool bApplyDocState = response->getBOk();

   DIA_TR_INF("onApplyDocResponse : bRecoveryMode is = %s", (bApplyDocState? "TRUE": "FALSE") );
}

//-----------------------------------------------------------------------------
/**
* sendAbortRequest -  To handle 'UpdateAbort' property request
* @param[in] none
* @parm[out] none
* @return
*/
tDiaResult
dia_SAFeatureSWUpdatePrj::sendAbortRequest( )
{

   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::sendAbortRequest : Sending Abort request to SW Update Component");

   tDiaResult retCode = DIA_FAILED;
   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendUpdateAbortRequest(*this, true);

      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::sendAbortRequest: ERROR - token is zero!");
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::sendAbortRequest. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::sendAbortRequest. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

/**
* onUpdateAbortError - Error handling for UpdateAbort.
* @param[in] proxy
* @param[in] error
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onUpdateAbortError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                               const ::boost::shared_ptr< UpdateAbortError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateAbortError");
   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------
/*
**
* onUpdateAbortResponse - update handling for UpdateAbort.
* @param[in] proxy
* @param[in] update
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onUpdateAbortResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                                  const ::boost::shared_ptr< UpdateAbortResponse >& response)
{

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateAbortResponse");
   tBool bUpdateAbortResponse = response->getBOk();

   bUpdateAbortResponse = true;

   DIA_TR_INF("onUpdateAbortResponse : bUpdateAbortResponse is = TRUE");   //Fix for Coverity CID : 16462313 
   getInstanceOfApplication()->postMessage (
            DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSWUpdatePrj,bool > (this,&dia_SAFeatureSWUpdatePrj::onUpdateAbortResponse,bUpdateAbortResponse)
               )
            );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateAbortResponse(bool bUpdateAbortResponse)
{
   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::onUpdateAbortResponse");
   //DIA_TR_INF("onUpdateAbortResponse : bRecoveryMode is = %s", (bApplyDocState? "TRUE": "FALSE") );
   dia_ISWUpdatePrjListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISWUpdatePrjListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnAbortStatus(bUpdateAbortResponse);
      DIA_TR_INF("dia_SAFeatureSWUpdatePrj::vOnAbortStatus");
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISWUpdatePrjListener NULL");
   }
}

//-----------------------------------------------------------------------------
/**
* SetReleaseFilter -  To handle 'UpdateSetReleaseFilter' property request
* @param[in] none
* @parm[out] none
* @return
*/
tDiaResult
dia_SAFeatureSWUpdatePrj::SetReleaseFilter()
{

   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::SetReleaseFilter : Sending UpdateSetReleaseFilter request to SW Update Component");

   tDiaResult retCode = DIA_FAILED;
   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendUpdateSetReleaseFilterRequest(*this,tenUpdOptions__NewAndSameOnly);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::SetReleaseFilter: ERROR - token is zero!");
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSWUpdatePrj::SetReleaseFilter. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureSWUpdatePrj::SetReleaseFilter. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

/**
* oUpdateSetReleaseFilterError - Error handling for UpdateSetReleaseFilter.
* @param[in] proxy
* @param[in] error
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                               const ::boost::shared_ptr< UpdateSetReleaseFilterError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterError");
   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------
/*
**
* onUpdateSetReleaseFilterResponse - update handling for UpdateSetReleaseFilter.
* @param[in] proxy
* @param[in] update
* @parm[out] none
* @return void
*/
void dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                                  const ::boost::shared_ptr< UpdateSetReleaseFilterResponse >& response)
{

   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterResponse");
   tU32 updateSetReleaseFilterResponse = static_cast<tU32>(response->getResFilter().getEnUpgradeDirectionFilter());
   DIA_TR_INF("onUpdateSetReleaseFilterResponse : updateSetReleaseFilterResponse is = %d", updateSetReleaseFilterResponse);

   getInstanceOfApplication()->postMessage (
            DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSWUpdatePrj,tU32 > (this,&dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterResponse,updateSetReleaseFilterResponse)
               )
            );
}
//-----------------------------------------------------------------------------
void
dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterResponse(tU32 updateSetReleaseFilterResponse)
{
   dia_tclFnctTrace trc("dia_SAFeatureSWUpdatePrj::onUpdateSetReleaseFilterResponse");
   dia_ISWUpdatePrjListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISWUpdatePrjListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnUpdateReleaseFilterStatus(updateSetReleaseFilterResponse);
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISWUpdatePrjListener NULL");
   }
}

//-----------------------------------------------------------------------------


