/**
 * \file      dia_SAFeatureRvcDimmingSystemSet.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      30.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "dia_SAFeatureRvcDimmingSystemSet.h"

//-----------------------------------------------------------------------------

dia_SAFeatureRvcDimmingSystemSet::dia_SAFeatureRvcDimmingSystemSet (
   tCString name,
   tU32 u32SystemSetId,
   tU32 u32SystemSetTypes,
   dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
   : dia_SAFeatureSystemSettings(name, u32SystemSetId, u32SystemSetTypes, pSrvPlugin),
     dia_ConfigNotifier(name)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureRvcDimmingSystemSet::dia_SAFeatureRvcDimmingSystemSet()");

   addProperty(DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF);
}

//-----------------------------------------------------------------------------

dia_SAFeatureRvcDimmingSystemSet::~dia_SAFeatureRvcDimmingSystemSet ( tVoid )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRvcDimmingSystemSet::onPropertyUpdate ( tU32 propID )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureRvcDimmingSystemSet::onPropertyUpdate()");

   tBool bResult = FALSE;

   switch (propID)
   {
   case DIA_PROP_CM_KEY_ILLUMINATION_ALIGNMENT_COEFF:
      bResult = dia_SAFeatureDiaglib::bExecuteSysSet(SYSSETID_DIMM, EN_TYPE_CALIBRATION, mpSrvPlugin);
      break;

   default:
      break;
   }

   DIA_TR_INF("dia_SAFeatureRvcDimmingSystemSet::onPropertyUpdate(%d) => res=%d", propID, bResult);

   return (bResult == TRUE)? DIA_SUCCESS: DIA_FAILED;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRvcDimmingSystemSet::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(SYSSETID_DIMM);
   return dia_SAFeatureSystemSettings::getDiaglibIDs(results);
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureRvcDimmingSystemSet::vOnSystemSetResult ( tU32 u32SysSetId, tenSystemSetType enSysSetType, tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureRvcDimmingSystemSet::vOnSystemSetResult()");

   DIA_TR_INF("dia_SAFeatureRvcDimmingSystemSet::vOnSystemSetResult: id=%d, type=%d", u32SysSetId, enSysSetType);

   if ((u32SysSetId == SYSSETID_DIMM) && (enSysSetType == EN_TYPE_CALIBRATION))
   {
      DIA_TR_INF("dia_SAFeatureRvcDimmingSystemSet::vOnSystemSetResult: SystemSet completed after PropertyUpdate");
   }
   else
   {
      dia_SAFeatureSystemSettings::vOnSystemSetResult(u32SysSetId, enSysSetType, enSystemSetResult, oErrorList);
   }
}


