/*
 * dia_SAFeatureRVCControl.cpp
 *
 *  Created on: 22.01.2013
 *      Author: shw2abt
 */
#include "dia_SAFeatureRVCControl.h"

/*
#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif
*/
#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureRVCControl,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

#define DIA_ACTIVATE_RVC     0x01
#define DIA_DEACTIVATE_RVC   0x00

//------------------------------------------------------------------------------

dia_SAFeatureRVCControl::dia_SAFeatureRVCControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureRVCControl::dia_SAFeatureRVCControl");
}


//-----------------------------------------------------------------------------

dia_SAFeatureRVCControl::~dia_SAFeatureRVCControl ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRVCControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_RVC_CONTROL_LINE);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRVCControl::freezeRVCControl_ControlLine ( dia_eRVCControl_ControlLineFreeze mode )
{
    dia_tclFnctTrace trc("dia_SAFeatureRVCControl::freezeRVCControl_ControlLine()");
    tDiaResult retCode = DIA_FAILED;

    tDiaglibParamVector vecRequest;
    // nothing to fill in

    tenIoControlAction ioAction;
    if(mode==DIA_EN_RVCCONTROL_CONTROLLINE_MODE_FREEZE){
       DIA_TR_INF("dia_SAFeatureRVCControl::freezeRVCControl_ControlLine - SET EN_ACTION_FREEZE.");
       ioAction = EN_ACTION_FREEZE;
    } else {
       DIA_TR_INF("dia_SAFeatureRVCControl::freezeRVCControl_ControlLine - SET EN_ACTION_UNFREEZE.");
       ioAction = EN_ACTION_UNFREEZE;
    }

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_RVC_CONTROL_LINE, ioAction, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureRVCControl::freezeRVCControl_ControlLine - bIOControlStart - SUCCESS.");
    } else {
       DIA_TR_INF("dia_SAFeatureRVCControl::freezeRVCControl_ControlLine - bIOControlStart - FAILED.");
    }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRVCControl::setRVCControl_ControlLine ( dia_eRVCControl_ControlLine mode )
{
    dia_tclFnctTrace trc("dia_SAFeatureRVCControl::setRVCControl_ControlLine()");
    tDiaResult retCode = DIA_FAILED;

    tDiaglibParamVector vecRequest;
    trParameter paramRCVC_ControlLine;

    paramRCVC_ControlLine.enType = static_cast<tenParameterType>(IOCONTROLID_RVC_CONTROL_LINE_SET_PARAM1);
    if(mode == DIA_EN_RVCCONTROL_CONTROLLINE_OFF){
       paramRCVC_ControlLine.u8Value = DIA_DEACTIVATE_RVC;
       DIA_TR_INF("dia_SAFeatureRVCControl::ControlLine = OFF");
    } else if (mode == DIA_EN_RVCCONTROL_CONTROLLINE_ON) {
       paramRCVC_ControlLine.u8Value = DIA_ACTIVATE_RVC;
       DIA_TR_INF("dia_SAFeatureRVCControl::ControlLine = ON");
    } else {
       DIA_TR_ERR("dia_SAFeatureRVCControl::setRVCControl_ControlLine - UNKOWN MODE.");
       DIA_TR_ERR("dia_SAFeatureRVCControl:: UNKOWN MODE = 0x%02x", mode);
       return retCode;
    }
    DIA_TR_INF("dia_SAFeatureRVCControl::setRVCControl_ControlLine - SET EN_ACTION_SET.");

    vecRequest.push_back(paramRCVC_ControlLine);

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_RVC_CONTROL_LINE, EN_ACTION_SET, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureRVCControl::setRVCControl_ControlLine - bIOControlStart - SUCCESS.");
    } else {
       DIA_TR_INF("dia_SAFeatureRVCControl::setRVCControl_ControlLine - bIOControlStart - FAILED.");
    }

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureRVCControl::vHandleIOControl ( amt_tclServiceData* poMessage ){
   dia_tclFnctTrace trc("dia_SAFeatureRVCControl::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureRVCControl::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& /*oStartResult*/){
   dia_tclFnctTrace trc("dia_SAFeatureRVCControl::vOnIoCtrlResult()");
   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32IoCtrlId);

   dia_IRVCControlListener* pRVCControlListener = OSAL_NULL;
   querySysAdapterListener<dia_IRVCControlListener>(&pRVCControlListener);

   tU8 currEnableMode = 0x00;

   if (pRVCControlListener)
   {
      tDiaResult ioControlOK = DIA_FAILED;
      if (enResult == EN_IO_CONTROL_OK)
      {
	      DIA_TR_INF("dia_SAFeatureRVCControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
	      ioControlOK = DIA_SUCCESS;
      }
      else
      {
          DIA_TR_INF("dia_SAFeatureRVCControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
      }

      switch (u32IoCtrlId)
      {
         case IOCONTROLID_RVC_CONTROL_LINE:
            DIA_TR_INF("dia_SAFeatureRVCControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_RVC_CONTROL_LINE.");

            switch(enActionId)
            {
               case EN_ACTION_FREEZE:
                  DIA_TR_INF("dia_SAFeatureRVCControl::vOnIoCtrlResult - ActionID = EN_ACTION_FREEZE.");
                  pRVCControlListener->vOnRVCControlLineFreezeMode(ioControlOK, DIA_EN_RVCCONTROL_CONTROLLINE_MODE_FREEZE, currEnableMode);
                  break;
               case EN_ACTION_SET:
                  DIA_TR_INF("dia_SAFeatureRVCControl::vOnIoCtrlResult - ActionID = EN_ACTION_SET.");
                  pRVCControlListener->vOnRVC_ControlLine(ioControlOK);
                  break;
               case EN_ACTION_UNFREEZE:
                  DIA_TR_INF("dia_SAFeatureRVCControl::vOnIoCtrlResult - ActionID = EN_ACTION_UNFREEZE.");
                  pRVCControlListener->vOnRVCControlLineFreezeMode(ioControlOK, DIA_EN_RVCCONTROL_CONTROLLINE_MODE_UNFREEZE , currEnableMode);
                  break;
               default:
                  DIA_TR_ERR("dia_SAFeatureRVCControl::vOnIoCtrlResult - ACTIONID = UNKNOWN.");
                  break;
            }
         break;
         default:
            DIA_TR_ERR("dia_SAFeatureRearViewCamera::vOnIoCtrlResult - u32IoCtrlId = u32IoCtrlId UNKNOWN.");
         break;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureRVCControl::vOnIoCtrlResult - No listener registered");
   }
}
