/*
 * dia_SAFeatureProductionCompressedAudio.cpp
 *
 *  Created on: 20.12.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_COMPRESSEDAUDIO_LISTENER__
#include "common/interfaces/dia_ICompressedAudioListener.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

// TODO: interface is not released, use this for time being
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//#define FC_COMPRESSEDAUDIO_S_IMPORT_INTERFACE_MSG
//#include "fc_compressedaudio_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//Include public FI interface of this service.
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO

#include "mplay_fi_if.h"


#include "dia_SAFeatureProductionCompressedAudio.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureProductionCompressedAudio.cpp.trc.h"
#endif

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP( dia_SAFeatureProductionCompressedAudio, dia_SystemAdapterFeature )
    ON_MESSAGE(MPLAY_MEDIAPLAYERFI_C_U16_DIAGNOSISPLAYSONG, vHandleSelectTrackViaUriResult)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureProductionCompressedAudio::dia_SAFeatureProductionCompressedAudio  (
        tCString name,      // feature name
        dia_SystemAdapterServicePlugin& pSrvPlugin
    )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureProductionCompressedAudio::dia_SAFeatureProductionCompressedAudio");
}

//-----------------------------------------------------------------------------

dia_SAFeatureProductionCompressedAudio::~dia_SAFeatureProductionCompressedAudio ( void )
{ }

//------------------------------------------------------------

tDiaResult
dia_SAFeatureProductionCompressedAudio::selectTrack ( dia_eCompAudioSource source, const std::vector<tU8>* pURI )
{
    dia_tclFnctTrace oTrace("dia_SAFeatureProductionCompressedAudio::selectTrack(dia_eCompAudioSource, vector<tU8>*)");

    tDiaResult retCode = DIA_FAILED;

    if ( !pURI ){
       return retCode;
    }

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
      mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart oSetFileStrMsg ;
        // store source
        switch(source){
         case DIA_EN_COMP_AUDIO_SOURCE_USB:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_USB;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_USB.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_IPOD:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPOD;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_IPOD.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_SD:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_SD;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_SD.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_BLUETOOTH:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_BLUETOOTH;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_BLUETOOTH.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_IPHONE:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_IPHONE;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_IPHONE.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_MTP:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_MTP;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_MTP.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_CD:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_CDROM;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_CDROM.");
                 break;
         case DIA_EN_COMP_AUDIO_SOURCE_FLASH:
                 oSetFileStrMsg.e8DeviceType.enType = mplay_fi_tcl_e8_MPlayDeviceType::FI_EN_E8DTY_FLASH;
                 DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::selectTrack Source FI_EN_E8DTY_FLASH.");
                 break;
           default:
              DIA_TR_ERR("dia_SAFeatureProductionCompressedAudio::selectTrack UNKNOWN Source Type!");
              break;
      }

      char uri[255] = " ";
//      for (tU8 i = 0; i < pURI->size(); i++) {
//         uri[i] = pURI->at(i);
//         DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness - copy at(%d)=%c to string.",i,pURI->at(i) );
//      }
      for (tU8 i = 0; i < pURI->size(); i++) {
         uri[i] = pURI->at(i);
         DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness - copy at(%d)=%c to string.",i,pURI->at(i) );
      }
//      for (tU8 i = 0; i < pURI->size()-1; i++) {
//         uri[i] = pURI->at(i+1);
//         DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness - copy at(%d)=%c to string.",i,pURI->at(i+1));
//      }
      oSetFileStrMsg.sFilename = uri;
      DIA_TR_INF("URI: \"%s\" .", oSetFileStrMsg.sFilename.szValue);

      fi_tclVisitorMessage oMsg(oSetFileStrMsg);
      mpSrvPlugin->vInitServiceData(oMsg, MPLAY_MEDIAPLAYERFI_C_U16_DIAGNOSISPLAYSONG, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ){
         retCode = DIA_SUCCESS;
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureProductionCompressedAudio::selectTrack AMT_C_U16_REGID_INVALID - Registration ID Invalid");
   }

   return retCode;
}

//-----------------------------------------------------

void
dia_SAFeatureProductionCompressedAudio::vHandleSelectTrackViaUriResult ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureProductionCompressedAudio::vHandleSelectTrackViaUriResult");
   tDiaResult result = DIA_FAILED;

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
          dia_ICompressedAudioListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ICompressedAudioListener>(&pListener);
         if ( pListener )
         {
             //fi_tclVisitorMessage oResultMsg(poMessage);
             //mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult oSelectTrackResult;
             //(void) oResultMsg.s32GetData(oSelectTrackResult);

             // TODO - real check
             // Candidates are:
             //    s32GetTypeId
             //if( ((tBool) oSelectTrackResult.Status) == TRUE ){
                result = DIA_SUCCESS;
                DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::vHandleSelectTrackViaUriResult SUCCESS.");
            //    DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::vHandleSelectTrackViaUriResult TypeID=0x%02x.", oSelectTrackResult.s32GetTypeId());
             //} else {
             //   DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::vHandleSelectTrackViaUriResult FAILED; status=%d .",(tBool)oSelectTrackResult.Status);
             //}

             // notify all registered listeners
             pListener->vOnSelectTrackResult(result);
         }
      }
      else
      {
        DIA_TR_INF("dia_SAFeatureProductionCompressedAudio::vHandleSelectTrackViaUriResult op code not correct, %d.", poMessage->u8GetOpCode());
         dia_ICompressedAudioListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ICompressedAudioListener>(&pListener);
         if ( pListener )
         {
          pListener->vOnSelectTrackResult(DIA_FAILED);
         }
      }

      (void) poMessage->bDelete();
   }
}
