/*!
 * \file       dia_SAFeaturePhoneBook.cpp
 *
 * \brief      Service Adapter for Phone Book
 *
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#include "dia_SAFeaturePhoneBook.h"

#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#include "diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

// FI is generated here:
//    <view>_GEN/ai_projects/generated/components/Connectivity/conn_most_fi/most_fi_if.h
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_DBGVISITORS        /* needed by most_fi_if.h */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_STDVISITORS             /* needed by most_fi_if.h */
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#include "Connectivity/conn_most_fi/most_fi_if.h"


#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC                 /* needed for gm_tclEmptyMessage */
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

BEGIN_MSG_MAP(dia_SAFeaturePhoneBook, dia_SystemAdapterFeature)
   ON_MESSAGE(MOST_PHONBKFI_C_U16_MAXCONTACTCOUNT,   vHandlePhoneBookMaxContactEntries)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeaturePhoneBook::dia_SAFeaturePhoneBook (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SAFeaturePhoneBook::dia_SAFeaturePhoneBook");
#endif
}

//-----------------------------------------------------------------------------

dia_SAFeaturePhoneBook::~dia_SAFeaturePhoneBook ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeaturePhoneBook::phonBook_MaxContactEntries_Get ( void )
{
   dia_tclFnctTrace trc("dia_SAFeaturePhoneBook::getPhoneBookMaxContactEntries()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeaturePhoneBook::getPhoneBookMaxContactEntries - send message.");
      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
		 MOST_PHONBKFI_C_U16_MAXCONTACTCOUNT,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeaturePhoneBook::getPhoneBookMaxContactEntries - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeaturePhoneBook::getPhoneBookMaxContactEntries - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeaturePhoneBook::getPhoneBookMaxContactEntries - getRegistrationID failed.");
      DIA_TR_ERR("dia_SAFeaturePhoneBook::getPhoneBookMaxContactEntries - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//===========================================================================================================

void
dia_SAFeaturePhoneBook::vHandlePhoneBookMaxContactEntries(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeaturePhoneBook::vHandlePhoneBookMaxContactEntries");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      DIA_TR_INF("dia_SAFeaturePhoneBook::vHandlePhoneBookMaxContactEntries poMessage OK.");

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
    	  dia_IPhonebookPrjListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IPhonebookPrjListener>(&pListener);

         if (pListener)
         {
           tU32 maxContactEntries=0;
            fi_tclVisitorMessage oResultMsg(poMessage);

            most_phonbkfi_tclMsgMaxContactCountStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);
            DIA_TR_INF("dia_SAFeaturePhoneBook --- before conversion: max contact count =oCompResp.u32MaxContactsCount=%d", oCompResp.u32MaxContactsCount);
            maxContactEntries = (tU32)(0xFFFFFFFFU & oCompResp.u32MaxContactsCount); //u32MaxContactsCount  size tU32
            DIA_TR_INF("dia_SAFeaturePhoneBook --- max contact count %d", maxContactEntries);
            //send to listener
            pListener->vOnPhoneBook_MaxContactEntries_Get(maxContactEntries);

            DIA_TR_INF("dia_SAFeaturePhoneBook::vHandlePhoneBookMaxContactEntries SUCCESS!");
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeaturePhoneBook --- opcode error received with error code 0x%04X", u16ErrorCode);
      }
      else
      {
         DIA_TR_INF("dia_SAFeaturePhoneBook::vHandlePhoneBookMaxContactEntries poMessage->u8GetOpCode() UNKNOWN => CODE==%d!", poMessage->u8GetOpCode());
      }

      (void) poMessage->bDelete();
   }
   else
   {
      DIA_TR_INF("dia_SAFeaturePhoneBook::vHandlePhoneBookMaxContactEntries poMessage EMPTY!");
   }
}
