/*
 * dia_SystemAdapterVehicleData.h
 *
 *  Created on: 11.01.2011
 *      Author: gib2hi
 *--------------------------------------------------------------------------------------------------------------------
 * 24.02.2017		| 1.6	| NLK1KOR (RBCM  )	| implemented feature  Feature 	AIVI-38980 	Working class for the Communication (connection) status
 *--------------------------------------------------------------------------------------------------------------------
 */

#ifndef DIA_SAFEATUREMETER_H_
#define DIA_SAFEATUREMETER_H_

// implemented interfaces
#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_MCAN__
#include "project/interfaces/dia_INissanMCanInfoListener.h"
#endif

class amt_tclServiceData;

class dia_SAFeatureMeter
    : public dia_SystemAdapterFeature,
      public dia_INissanMCanInfo
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureMeter);

public:
    //! default class constructor
    	dia_SAFeatureMeter ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
    //! class destructor
    virtual ~dia_SAFeatureMeter ( tVoid );

    //
    // implementation of the dia_INissanMCanInfo interface
    //
    // implementation of the getNissanMCANInfo interface
    virtual tDiaResult getNissanMCANInfo ( tVoid );
    // implementation of the getNissanMCANTransmissionStatus interface
    virtual tDiaResult getNissanMCANTransmissionStatus ( tVoid );
	virtual tDiaResult getNissanMCANMeterInfo(tVoid);
protected:
    //! handle the result of a Connection status message
    tVoid vHandleMCanConnectionState ( amt_tclServiceData* poMessage ) const;
    //! handle the result of a DataTransmission status message
    tVoid vHandleMCanDataTransmissionStatus ( amt_tclServiceData* poMessage ) const;
//    //! overloaded to register for all needed FIDs when the service is available
//    virtual tBool bOnServiceStateAvailable ( tU16 u16SrvID, tU16 u16SubId );
	tVoid vHandleMCanMeterConnectionState(amt_tclServiceData* poMessage) const;
    tBool bSendMessage (
            const tU8  u8MessageType,
            const tU16 u16FID,
            const tU8  u8Opcode,
            const tU16 u16MsgLength,
            const tU8  u8MsgBuffer[]
            );

    // declare message map data structures
    DECLARE_MSG_MAP(dia_SAFeatureMeter)
};

#endif /* DIA_SAFEATUREMETER_H_ */
